/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.mle_js;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.mle_js.DBMExtractionHandlerMLE_JS;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHMlejsHandler;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.mle_js.MLEConstants;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.MLEModule;

public class MOHModule
extends MOHMlejsHandler
implements MLEConstants {
    public static final String OBJECT_TYPE = "MODULE";
    public static final String DBA_TABLE = "SYS.DBA_MLE_MODULES";
    public static final String ALL_TABLE = "SYS.ALL_MLE_MODULES";
    public static final String DBA_ARGS_TABLE = "SYS.DBA_SCHEDULER_PROGRAM_ARGS";
    public static final String ALL_ARGS_TABLE = "SYS.ALL_SCHEDULER_PROGRAM_ARGS";

    public MOHModule(DBMExtractionHandlerMLE_JS dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List<PropertiesObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<PropertiesObject> res = new ArrayList<PropertiesObject>();
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                try {
                    PreparedStatement ps = conn.prepareStatement(sql);
                    try {
                        String schema = dbo.getSchema();
                        String name = dbo.getName();
                        ps.setString(1, schema);
                        ps.setString(2, name);
                        ResultSet rs = ps.executeQuery();
                        try {
                            if (!rs.next()) continue;
                            String version = rs.getString(3);
                            Blob blob = rs.getBlob(4);
                            String module = MLEJS_Util.blobToString(blob);
                            Clob clob = rs.getClob(5);
                            String metadata = null;
                            if (clob != null) {
                                metadata = clob.getSubString(1L, (int)clob.length());
                            }
                            MLEModule mod = new MLEModule();
                            mod.setProperty("MODULE_OWNER", schema);
                            mod.setProperty("MODULE_NAME", name);
                            mod.setProperty("VERSION", version);
                            mod.setProperty(OBJECT_TYPE, module);
                            mod.setProperty("METADATA", metadata);
                            res.add(mod);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (ps == null) continue;
                        ps.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select module_owner, module_name,version, module, metadata from " + (dba ? DBA_TABLE : ALL_TABLE) + " \n where module_owner = ? and module_name = ?";
        return sql;
    }
}

