/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.mle_js;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.mle_js.DBMExtractionHandlerMLE_JS;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHMlejsHandler;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.mle_js.AntlrAstParser;
import oracle.dbtools.mle_js.ExpNode;
import oracle.dbtools.mle_js.MLEConstants;
import oracle.dbtools.mle_js.MLEEnvironment;
import oracle.dbtools.mle_js.MLEJS_Util;
import oracle.dbtools.mle_js.ModuleMetadata;
import oracle.dbtools.mle_js.RequestProcessing;

public class MOHEnvironment
extends MOHMlejsHandler
implements MLEConstants {
    public static final String OBJECT_TYPE = "ENVIRONMENT";
    public static final String DBA_TABLE = "SYS.DBA_MLE_ENVS";
    public static final String ALL_TABLE = "SYS.ALL_MLE_ENVS";
    public static final String DBA_IMP_TABLE = "SYS.DBA_MLE_ENV_IMPORTS";
    public static final String ALL_IMP_TABLE = "SYS.ALL_MLE_ENV_IMPORTS";

    public MOHEnvironment(DBMExtractionHandlerMLE_JS dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List<PropertiesObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        String sqlimp = this.getSQLImp(dba);
        ArrayList<PropertiesObject> res = new ArrayList<PropertiesObject>();
        try {
            for (DBObject dbo : selectedObjects) {
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                try {
                    PreparedStatement cs = conn.prepareStatement(sql);
                    try {
                        String schema = dbo.getSchema();
                        String name = dbo.getName();
                        cs.setString(1, schema);
                        cs.setString(2, name);
                        ResultSet rs = cs.executeQuery();
                        try {
                            if (!rs.next()) continue;
                            String options = rs.getString(1);
                            MLEEnvironment mod = new MLEEnvironment();
                            mod.setProperty("ENV_OWNER", schema);
                            mod.setProperty("ENV_NAME", name);
                            mod.setProperty("LANGUAGE_OPTIONS", options);
                            try (PreparedStatement ps = conn.prepareStatement(sqlimp);){
                                ps.setString(1, schema);
                                ps.setString(2, name);
                                try (ResultSet rs2 = ps.executeQuery();){
                                    while (rs2.next()) {
                                        String import_name = rs2.getString(1);
                                        String module_owner = rs2.getString(2);
                                        String module_name = rs2.getString(3);
                                        MLEEnvironment.EnvImport imp = new MLEEnvironment.EnvImport();
                                        imp.setProperty("IMPORT_NAME", import_name);
                                        imp.setProperty("MODULE_OWNER", module_owner);
                                        imp.setProperty("MODULE_NAME", module_name);
                                        mod.addImportt(imp);
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            res.add(mod);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (cs == null) continue;
                        cs.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select language_options from " + (dba ? DBA_TABLE : ALL_TABLE) + " \n where env_owner = ? and env_name = ?";
        return sql;
    }

    String getSQLImp(boolean dba) {
        String sql = "select import_name, module_owner, module_name from " + (dba ? DBA_IMP_TABLE : ALL_IMP_TABLE) + " \n where env_owner = ? and env_name = ?";
        return sql;
    }

    public String getEnvironmentDependencies(Connection conn, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        String string;
        block22: {
            boolean dba = this.isDBA(conn);
            String modSQL = "select i.module_owner, i.module_name, I.IMPORT_NAME, m.metadata,m.module  from \r\n" + (dba ? " SYS.DBA_MLE_ENV_IMPORTS i, SYS.DBA_MLE_MODULES m " : " SYS.ALL_MLE_ENV_IMPORTS i, SYS.ALL_MLE_MODULES m ") + " \r\nwhere \r\nI.ENV_OWNER = ? and I.ENV_NAME = ? and \r\ni.MODULE_OWNER = M.MODULE_OWNER and I.MODULE_NAME = M.MODULE_NAME";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            PreparedStatement cs = conn.prepareStatement(modSQL);
            try {
                String schema = env_owner;
                String name = env_name;
                cs.setString(1, schema);
                cs.setString(2, name);
                try (ResultSet rs = cs.executeQuery();){
                    while (rs.next()) {
                        ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                        wr.module_owner = rs.getString(1);
                        wr.module_name = rs.getString(2);
                        wr.import_name = rs.getString(3);
                        ModuleMetadata metadata = null;
                        String meta = null;
                        ArrayList<String> lines = new ArrayList<String>();
                        Clob clob = rs.getClob(4);
                        boolean codeIncluded = false;
                        if (clob != null) {
                            meta = clob.getSubString(1L, (int)clob.length());
                            metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                        }
                        Blob blob = rs.getBlob(5);
                        String module = null;
                        if (blob != null) {
                            module = MLEJS_Util.blobToString(blob);
                            if (metadata == null) {
                                metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                                codeIncluded = true;
                            }
                        }
                        if (metadata == null) continue;
                        if (!codeIncluded && module != null) {
                            module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                            MOHEnvironment.addFunctionsCode(metadata, lines);
                        }
                        wr.metadata = metadata;
                        res.add(wr);
                    }
                }
                MOHEnvironment.resolveFunctionParameters(res, conn);
                MOHEnvironment.resolve(res);
                string = MOHEnvironment.toJsonString(res);
                if (cs == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (cs != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (cw != null) {
                        cw.logError("MOHEnvironment.getEnvironmentDependencies", e);
                    } else {
                        e.printStackTrace();
                    }
                    return "{\"items\":[]}";
                }
            }
            cs.close();
        }
        return string;
    }

    static void addFunctionsCode(ModuleMetadata metadata, List<String> lines) {
    }

    public Map<String, ModuleName> getEnvImportsMap(Connection conn, String env_owner, String env_name, RequestManager.ContentWrapper cw, boolean dba) {
        Hashtable<String, ModuleName> map = new Hashtable<String, ModuleName>();
        String sql = "select import_name, module_owner, module_name from \r\n" + (dba ? " SYS.DBA_MLE_ENV_IMPORTS " : " SYS.ALL_MLE_ENV_IMPORTS ") + " where ENV_OWNER = ? and ENV_NAME = ?";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            String schema = env_owner;
            String name = env_name;
            ps.setString(1, schema);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    ModuleName mn = new ModuleName();
                    String imp_name = rs.getString(1);
                    mn.owner = rs.getString(2);
                    mn.name = rs.getString(3);
                    map.put(imp_name, mn);
                }
            }
        }
        catch (Throwable e) {
            if (cw != null) {
                cw.logError("MOHEnvironment.getModuleDependencies", e);
            }
            e.printStackTrace();
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleName getEnvForModule(Connection conn, String module_owner, String module_name, RequestManager.ContentWrapper cw, boolean dba) {
        String sql = "select ENV_OWNER, ENV_NAME, count(*) from \r\n" + (dba ? " SYS.DBA_MLE_ENV_IMPORTS " : " SYS.ALL_MLE_ENV_IMPORTS ") + "  where exists (select 1 from \r\n" + (dba ? " SYS.DBA_MLE_ENV_IMPORTS " : " SYS.ALL_MLE_ENV_IMPORTS ") + "  where MODULE_OWNER = ? and MODULE_NAME = ? )\r\n group by ENV_OWNER, ENV_NAME order by 3 desc fetch next 1 rows only";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, module_owner);
            ps.setString(2, module_name);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                ModuleName mn = new ModuleName();
                mn.owner = rs.getString(1);
                mn.name = rs.getString(2);
                ModuleName moduleName = mn;
                return moduleName;
            }
        }
        catch (Throwable e) {
            if (cw != null) {
                cw.logError("MOHEnvironment.getModuleDependencies", e);
                return null;
            }
            e.printStackTrace();
        }
        return null;
    }

    public String getModuleDependencies(Connection conn, String module_owner, String module_name, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        String string;
        block26: {
            ModuleName mn;
            boolean dba = this.isDBA(conn);
            String modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            String e_owner = env_owner;
            String e_name = env_name;
            if ((e_name == null || e_name.isEmpty()) && (mn = this.getEnvForModule(conn, module_owner, module_name, cw, dba)) != null) {
                e_owner = mn.owner;
                e_name = mn.name;
            }
            PreparedStatement ps = conn.prepareStatement(modSQL);
            try {
                Map<String, ModuleName> imps;
                ps.setString(1, module_owner);
                ps.setString(2, module_name);
                ModuleMetadata metadata = null;
                ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        wr.module_owner = module_owner;
                        wr.module_name = module_name;
                        String meta = null;
                        ArrayList<String> lines = new ArrayList<String>();
                        Clob clob = rs.getClob(1);
                        boolean codeIncluded = false;
                        if (clob != null) {
                            meta = clob.getSubString(1L, (int)clob.length());
                            metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                        }
                        Blob blob = rs.getBlob(2);
                        String module = null;
                        if (blob != null) {
                            module = MLEJS_Util.blobToString(blob);
                            if (metadata == null) {
                                metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                                codeIncluded = true;
                            }
                        }
                        if (metadata != null) {
                            if (!codeIncluded && module != null) {
                                module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                                MOHEnvironment.addFunctionsCode(metadata, lines);
                            }
                            wr.metadata = metadata;
                            res.add(wr);
                        }
                    }
                }
                if (e_name != null && e_owner != null && metadata != null && metadata.getNotResolved().size() > 0 && (imps = this.getEnvImportsMap(conn, e_owner, e_name, cw, dba)).size() > 0) {
                    Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
                    String imp_name = this.getImportName(imps, module_owner, module_name);
                    if (imp_name != null) {
                        wr.import_name = imp_name;
                        modules.put(wr.import_name, wr);
                        this.loadImportedModules(ps, res, modules, imps, wr, env_owner, env_name, cw);
                    }
                }
                MOHEnvironment.resolveFunctionParameters(res, conn);
                MOHEnvironment.resolve(res);
                string = MOHEnvironment.toJsonString(res);
                if (ps == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (cw != null) {
                        cw.logError("MOHEnvironment.getModuleDependencies", e);
                    } else {
                        e.printStackTrace();
                    }
                    return "{\"items\":[]}";
                }
            }
            ps.close();
        }
        return string;
    }

    public String getModuleDependenciesList(Connection conn, String module_owner, String module_name, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        String string;
        block26: {
            ModuleName mn;
            boolean dba = this.isDBA(conn);
            String modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            String e_owner = env_owner;
            String e_name = env_name;
            if ((e_name == null || e_name.isEmpty()) && (mn = this.getEnvForModule(conn, module_owner, module_name, cw, dba)) != null) {
                e_owner = mn.owner;
                e_name = mn.name;
            }
            PreparedStatement ps = conn.prepareStatement(modSQL);
            try {
                String json;
                Map<String, ModuleName> imps;
                ps.setString(1, module_owner);
                ps.setString(2, module_name);
                ModuleMetadata metadata = null;
                ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        wr.module_owner = module_owner;
                        wr.module_name = module_name;
                        String meta = null;
                        ArrayList<String> lines = new ArrayList<String>();
                        Clob clob = rs.getClob(1);
                        boolean codeIncluded = false;
                        if (clob != null) {
                            meta = clob.getSubString(1L, (int)clob.length());
                            metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                        }
                        Blob blob = rs.getBlob(2);
                        String module = null;
                        if (blob != null) {
                            module = MLEJS_Util.blobToString(blob);
                            if (metadata == null) {
                                metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                                codeIncluded = true;
                            }
                        }
                        if (metadata != null) {
                            if (!codeIncluded && module != null) {
                                module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                                MOHEnvironment.addFunctionsCode(metadata, lines);
                            }
                            wr.metadata = metadata;
                            res.add(wr);
                        }
                    }
                }
                if (e_name != null && e_owner != null && metadata != null && metadata.getNotResolved().size() > 0 && (imps = this.getEnvImportsMap(conn, e_owner, e_name, cw, dba)).size() > 0) {
                    Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
                    String imp_name = this.getImportName(imps, module_owner, module_name);
                    if (imp_name != null) {
                        wr.import_name = imp_name;
                        modules.put(wr.import_name, wr);
                        this.loadImportedModules(ps, res, modules, imps, wr, env_owner, env_name, cw);
                    }
                }
                List<ModuleName> deps = MOHEnvironment.getDependenciesList(res);
                ModuleName mn2 = new ModuleName();
                mn2.owner = wr.module_owner;
                mn2.name = wr.module_name;
                mn2.import_name = wr.import_name;
                deps.add(0, mn2);
                ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
                string = json = ow.writeValueAsString(deps);
                if (ps == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (cw != null) {
                        cw.logError("MOHEnvironment.getModuleDependencies", e);
                    } else {
                        e.printStackTrace();
                    }
                    return "{\"items\":[]}";
                }
            }
            ps.close();
        }
        return string;
    }

    public String getModuleExports(Connection conn, String module_owner, String module_name, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        String string;
        block26: {
            ModuleName mn;
            boolean dba = this.isDBA(conn);
            String modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            String e_owner = env_owner;
            String e_name = env_name;
            if ((e_name == null || e_name.isEmpty()) && (mn = this.getEnvForModule(conn, module_owner, module_name, cw, dba)) != null) {
                e_owner = mn.owner;
                e_name = mn.name;
            }
            PreparedStatement ps = conn.prepareStatement(modSQL);
            try {
                Map<String, ModuleName> imps;
                ps.setString(1, module_owner);
                ps.setString(2, module_name);
                ModuleMetadata metadata = null;
                ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        wr.module_owner = module_owner;
                        wr.module_name = module_name;
                        String meta = null;
                        ArrayList<String> lines = new ArrayList<String>();
                        Clob clob = rs.getClob(1);
                        boolean codeIncluded = false;
                        if (clob != null) {
                            meta = clob.getSubString(1L, (int)clob.length());
                            metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                        }
                        Blob blob = rs.getBlob(2);
                        String module = null;
                        if (blob != null) {
                            module = MLEJS_Util.blobToString(blob);
                            if (metadata == null) {
                                metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                                codeIncluded = true;
                            }
                        }
                        if (metadata != null) {
                            if (!codeIncluded && module != null) {
                                module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                                MOHEnvironment.addFunctionsCode(metadata, lines);
                            }
                            wr.metadata = metadata;
                            res.add(wr);
                        }
                    }
                }
                if (e_name != null && e_owner != null && metadata != null && metadata.getNotResolvedExports().size() > 0 && (imps = this.getEnvImportsMap(conn, e_owner, e_name, cw, dba)).size() > 0) {
                    Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
                    String imp_name = this.getImportName(imps, module_owner, module_name);
                    if (imp_name != null) {
                        wr.import_name = imp_name;
                        modules.put(wr.import_name, wr);
                        this.loadImportedModules(ps, res, modules, imps, wr, env_owner, env_name, cw);
                    }
                }
                MOHEnvironment.resolveFunctionParameters(res, conn);
                MOHEnvironment.resolve(res);
                string = AntlrAstParser.toJsonMetadata("exports", metadata.getExports());
                if (ps == null) break block26;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (cw != null) {
                        cw.logError("MOHEnvironment.getModuleExports", e);
                    } else {
                        e.printStackTrace();
                    }
                    return "{\"exports\":[]}";
                }
            }
            ps.close();
        }
        return string;
    }

    public String getModuleOwnExports(Connection conn, String module_owner, String module_name, RequestManager.ContentWrapper cw) {
        String string;
        block23: {
            boolean dba = this.isDBA(conn);
            String modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            PreparedStatement ps = conn.prepareStatement(modSQL);
            try {
                ps.setString(1, module_owner);
                ps.setString(2, module_name);
                ModuleMetadata metadata = null;
                ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        wr.module_owner = module_owner;
                        wr.module_name = module_name;
                        String meta = null;
                        ArrayList<String> lines = new ArrayList<String>();
                        Clob clob = rs.getClob(1);
                        boolean codeIncluded = false;
                        if (clob != null) {
                            meta = clob.getSubString(1L, (int)clob.length());
                            metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                        }
                        Blob blob = rs.getBlob(2);
                        String module = null;
                        if (blob != null) {
                            module = MLEJS_Util.blobToString(blob);
                            if (metadata == null) {
                                metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                                codeIncluded = true;
                            }
                        }
                        if (metadata != null) {
                            if (!codeIncluded && module != null) {
                                module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                                MOHEnvironment.addFunctionsCode(metadata, lines);
                            }
                            wr.metadata = metadata;
                            res.add(wr);
                        }
                    }
                }
                MOHEnvironment.resolveFunctionParameters(res, conn);
                string = AntlrAstParser.toJsonMetadata("exports", metadata.getExports());
                if (ps == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    if (cw != null) {
                        cw.logError("MOHEnvironment.getModuleExports", e);
                    } else {
                        e.printStackTrace();
                    }
                    return "{\"exports\":[]}";
                }
            }
            ps.close();
        }
        return string;
    }

    String getImportName(Map<String, ModuleName> map, String module_owner, String module_name) {
        for (Map.Entry<String, ModuleName> node : map.entrySet()) {
            if (!node.getValue().owner.equals(module_owner) || !node.getValue().name.equals(module_name)) continue;
            return node.getKey();
        }
        return null;
    }

    public String getResolvedImports(Connection conn, String code, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        ModuleMetadata metadata = AntlrAstParser.getModuleMetadataFromJS(code);
        return this.getResolvedImports(conn, metadata, env_owner, env_name, cw);
    }

    public String getResolvedImports(Connection conn, ModuleMetadata metadata, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        block10: {
            boolean dba = this.isDBA(conn);
            String modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            String e_owner = env_owner;
            String e_name = env_name;
            try {
                if (metadata == null) break block10;
                ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                wr.module_name = "Provided_jscode";
                Map<String, ModuleName> imps = this.getEnvImportsMap(conn, e_owner, e_name, cw, dba);
                wr.import_name = wr.module_name;
                wr.metadata = metadata;
                res.add(wr);
                if (metadata.getNotResolvedImports().size() > 0 && imps.size() > 0) {
                    Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
                    modules.put(wr.import_name, wr);
                    try (PreparedStatement ps = conn.prepareStatement(modSQL);){
                        this.loadImportedModules(ps, res, modules, imps, wr, env_owner, env_name, cw);
                    }
                }
                MOHEnvironment.resolveFunctionParameters(res, conn);
                MOHEnvironment.resolve(res);
                return AntlrAstParser.toJsonMetadata("imports", metadata.getImports());
            }
            catch (Throwable e) {
                if (cw != null) {
                    cw.logError("MOHEnvironment.getResolvedCodeMetadata", e);
                }
                e.printStackTrace();
            }
        }
        return "{\"imports\":[]}";
    }

    public String getModulesDeclarationForImports(Connection conn, String code, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        ModuleMetadata metadata = AntlrAstParser.getModuleMetadataFromJS(code);
        return this.getModulesDeclarationForImports(conn, metadata, env_owner, env_name, cw);
    }

    public String getModulesDeclarationForImports(Connection conn, ModuleMetadata metadata, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        block10: {
            boolean dba = this.isDBA(conn);
            String modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
            ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
            String e_owner = env_owner;
            String e_name = env_name;
            try {
                if (metadata == null) break block10;
                ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
                wr.module_name = "Provided_jscode";
                Map<String, ModuleName> imps = this.getEnvImportsMap(conn, e_owner, e_name, cw, dba);
                wr.import_name = wr.module_name;
                wr.metadata = metadata;
                res.add(wr);
                if (imps.size() > 0) {
                    Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
                    modules.put(wr.import_name, wr);
                    try (PreparedStatement ps = conn.prepareStatement(modSQL);){
                        this.loadImportedModules(ps, res, modules, imps, wr, env_owner, env_name, cw);
                    }
                }
                res.remove(wr);
                MOHEnvironment.resolveFunctionParameters(res, conn);
                String decl = MOHEnvironment.getModulesDeclarationForCodeComletion(res);
                String uri = this.getURIPart(env_owner, env_name, res);
                return "{\"uri_part\":\"" + RequestProcessing.encode(uri) + "\",\"modules\":\"" + RequestProcessing.encode(decl) + "\"}";
            }
            catch (Throwable e) {
                if (cw != null) {
                    cw.logError("MOHEnvironment.getResolvedCodeMetadata", e);
                }
                e.printStackTrace();
            }
        }
        return "{}";
    }

    public static String getModulesDeclarationForCodeComletion(List<ModuleMetadata.ModuleMetadataWrapper> modules) {
        Object res = "";
        for (ModuleMetadata.ModuleMetadataWrapper wr : modules) {
            if (((String)res).isEmpty()) {
                res = MOHEnvironment.generateModuleDeclaration(wr);
                continue;
            }
            res = (String)res + "\n" + MOHEnvironment.generateModuleDeclaration(wr);
        }
        return res;
    }

    public static String generateModuleDeclaration(ModuleMetadata.ModuleMetadataWrapper wr) {
        String start = "declare module '" + wr.import_name + "'{\n";
        String imports = "";
        Object exports = "";
        Object body = "";
        String end = "}";
        HashMap<String, String> names = new HashMap<String, String>();
        String functions = MOHEnvironment.getFunctions(wr, names);
        imports = MOHEnvironment.getImports(wr, names);
        exports = MOHEnvironment.getExports(wr, names);
        String vars = MOHEnvironment.getVars(wr, names);
        String expNames = MOHEnvironment.getExportsForNames(wr, names);
        exports = (String)exports + (String)(expNames.isEmpty() ? "" : "\n" + expNames);
        body = imports + (String)(vars.isEmpty() ? "" : "\n" + vars) + (String)(functions.isEmpty() ? "" : "\n" + functions) + (String)(((String)exports).isEmpty() ? "" : "\n" + (String)exports);
        return start + (String)body + end;
    }

    public static String getFunctions(ModuleMetadata.ModuleMetadataWrapper wr, Map<String, String> names) {
        Object res = "";
        ModuleMetadata meta = wr.metadata;
        for (ExpNode exp : meta.getExports()) {
            String code;
            if (exp.type == null || !"var_function".equals(exp.type) && !"var_class".equals(exp.type) && !"function".equals(exp.type) && !"class".equals(exp.type)) continue;
            String help = exp.comment;
            if (exp.hasParamsWithDataType()) {
                help = MOHEnvironment.getHelpWithParameters(help, exp);
            }
            if ((code = exp.code) == null) continue;
            String alias = exp.name_in_code;
            if (alias != null) {
                if (alias.isEmpty()) {
                    alias = exp.name;
                }
                names.put(alias, exp.name);
            }
            if (help != null) {
                res = ((String)res).isEmpty() ? help : (String)res + "\n" + help;
            }
            if (((String)res).isEmpty()) {
                res = code;
                continue;
            }
            res = (String)res + "\n" + code;
        }
        return res;
    }

    public static String getHelpWithParameters(String help, ExpNode exp) {
        Object res = help;
        if (res == null) {
            res = "";
        }
        if (((String)res).indexOf("@param") > 0 || ((String)res).indexOf("@return") > 0) {
            return help;
        }
        boolean changed = false;
        if (((String)res).startsWith("/*") && ((String)res).endsWith("*/")) {
            res = ((String)res).substring(1, help.length() - 1);
            changed = true;
        }
        Object par = "";
        for (ExpNode.Param p : exp.getParams()) {
            if (p.type == null || p.type.isEmpty()) continue;
            par = (String)par + "\n * @param {" + p.type + "} " + p.name + " - data type is " + p.type;
        }
        if (exp.return_type != null && !exp.return_type.isEmpty()) {
            par = (String)par + "\n * @return {" + exp.return_type + "} - return type is " + exp.return_type;
        }
        res = "/**\n" + (String)res + (String)par + "\n*/";
        return res;
    }

    public static String getVars(ModuleMetadata.ModuleMetadataWrapper wr, Map<String, String> names) {
        Object res = "";
        ModuleMetadata meta = wr.metadata;
        for (ExpNode exp : meta.getExports()) {
            if (exp.type == null || !"var".equals(exp.type)) continue;
            String type = exp.subtype;
            if (type == null) {
                type = "var";
            }
            String exp_name = names.get(exp.name);
            String export = "";
            if (exp_name == null) {
                export = "export ";
            }
            String decl = export + type + " " + exp.name + ";";
            if (((String)res).isEmpty()) {
                res = decl;
                continue;
            }
            res = (String)res + "\n" + decl;
        }
        return res;
    }

    public static String getImports(ModuleMetadata.ModuleMetadataWrapper wr, Map<String, String> names) {
        Object res = "";
        ModuleMetadata meta = wr.metadata;
        for (ExpNode exp : meta.getNotResolved()) {
            Object decl;
            Object alias;
            if (exp.type != null && "importNamespace".equals(exp.type)) {
                alias = "";
                if (exp.imp_alias != null) {
                    alias = " as " + exp.imp_alias;
                }
                decl = "import " + exp.scope + " " + (String)alias + " from '" + exp.imp_name + "';";
                if (((String)res).isEmpty()) {
                    res = decl;
                    continue;
                }
                res = (String)res + "\n" + (String)decl;
                continue;
            }
            if (exp.type == null || !"importItems".equals(exp.type) || exp.getExpItems().size() <= 0) continue;
            alias = "";
            for (String item : exp.getExpItems()) {
                if (((String)alias).isEmpty()) {
                    alias = item;
                    continue;
                }
                alias = (String)alias + ", " + item;
            }
            decl = "import {" + (String)alias + "} from '" + exp.imp_name + "';";
            if (((String)res).isEmpty()) {
                res = decl;
                continue;
            }
            res = (String)res + "\n" + (String)decl;
        }
        return res;
    }

    public static String getExports(ModuleMetadata.ModuleMetadataWrapper wr, Map<String, String> names) {
        Object res = "";
        ModuleMetadata meta = wr.metadata;
        for (ExpNode exp : meta.getNotResolved()) {
            Object decl;
            Object alias;
            if (exp.type != null && "exportNamespaceFromModule".equals(exp.type)) {
                alias = "";
                if (exp.imp_alias != null) {
                    alias = " as " + exp.imp_alias;
                }
                decl = "export " + exp.scope + " " + (String)alias + " from '" + exp.imp_name + "';";
                if (((String)res).isEmpty()) {
                    res = decl;
                    continue;
                }
                res = (String)res + "\n" + (String)decl;
                continue;
            }
            if (exp.type != null && "exportItemsFromModule".equals(exp.type)) {
                if (exp.getExpItems().size() <= 0) continue;
                alias = "";
                for (String item : exp.getExpItems()) {
                    if (((String)alias).isEmpty()) {
                        alias = item;
                        continue;
                    }
                    alias = (String)alias + ", " + item;
                }
                decl = "export {" + (String)alias + "} from '" + exp.imp_name + "';";
                if (((String)res).isEmpty()) {
                    res = decl;
                    continue;
                }
                res = (String)res + "\n" + (String)decl;
                continue;
            }
            if (exp.type == null || !"exportPossibleImport".equals(exp.type) || exp.name_in_code == null || exp.name == null) continue;
            names.put(exp.name_in_code, exp.name);
            String decl2 = "export {" + exp.name_in_code + " as " + exp.name + "};";
            if (((String)res).isEmpty()) {
                res = decl2;
                continue;
            }
            res = (String)res + "\n" + decl2;
        }
        return res;
    }

    public static String getExportsForNames(ModuleMetadata.ModuleMetadataWrapper wr, Map<String, String> names) {
        Object res = "";
        for (Map.Entry<String, String> entry : names.entrySet()) {
            Object decl = "";
            decl = !entry.getKey().equals(entry.getValue()) ? "export {" + entry.getKey() + " as " + entry.getValue() + "};" : "export {" + entry.getKey() + "};";
            if (((String)res).isEmpty()) {
                res = decl;
                continue;
            }
            res = (String)res + "\n" + (String)decl;
        }
        return res;
    }

    public String getURIPart(String env_owner, String env_name, List<ModuleMetadata.ModuleMetadataWrapper> modules) {
        String res = env_owner + "." + env_name;
        for (ModuleMetadata.ModuleMetadataWrapper wr : modules) {
            res = res + "." + wr.import_name;
        }
        res = res + ".js";
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCodeDependencies(Connection conn, String code, String code_name, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        boolean dba = this.isDBA(conn);
        String modSQL = "select i.module_owner, i.module_name, I.IMPORT_NAME, m.metadata,m.module  from \r\n" + (dba ? " SYS.DBA_MLE_ENV_IMPORTS i, SYS.DBA_MLE_MODULES m " : " SYS.ALL_MLE_ENV_IMPORTS i, SYS.ALL_MLE_MODULES m ") + " \r\nwhere \r\nI.ENV_OWNER = ? and I.ENV_NAME = ? and I.module_owner = ? and I.module_name = ? and \r\n i.MODULE_OWNER = M.MODULE_OWNER and I.MODULE_NAME = M.MODULE_NAME";
        modSQL = "select metadata, case when metadata is null then module end as module from \r\n" + (dba ? " SYS.DBA_MLE_MODULES " : " SYS.ALL_MLE_MODULES ") + "\r\n where module_owner = ? and module_name = ?";
        ArrayList<ModuleMetadata.ModuleMetadataWrapper> res = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
        String e_owner = env_owner;
        String e_name = env_name;
        try (PreparedStatement ps = conn.prepareStatement(modSQL);){
            ModuleMetadata metadata = null;
            ModuleMetadata.ModuleMetadataWrapper wr = new ModuleMetadata.ModuleMetadataWrapper();
            wr.module_name = code_name != null && !code_name.isEmpty() ? code_name : "Provided_jscode";
            if (code != null) {
                metadata = AntlrAstParser.getModuleMetadataFromJS(code);
            }
            if (metadata == null) return "{\"items\":[]}";
            Map<String, ModuleName> imps = this.getEnvImportsMap(conn, e_owner, e_name, cw, dba);
            wr.import_name = wr.module_name;
            wr.metadata = metadata;
            res.add(wr);
            if (metadata.getNotResolved().size() > 0 && imps.size() > 0) {
                Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
                modules.put(wr.import_name, wr);
                this.loadImportedModules(ps, res, modules, imps, wr, env_owner, env_name, cw);
            }
            MOHEnvironment.resolveFunctionParameters(res, conn);
            MOHEnvironment.resolve(res);
            String string = MOHEnvironment.toJsonString(res);
            return string;
        }
        catch (Throwable e) {
            if (cw != null) {
                cw.logError("MOHEnvironment.getModuleDependencies", e);
                return "{\"items\":[]}";
            }
            e.printStackTrace();
        }
        return "{\"items\":[]}";
    }

    public void loadImportedModules(PreparedStatement ps, List<ModuleMetadata.ModuleMetadataWrapper> res, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, Map<String, ModuleName> envImports, ModuleMetadata.ModuleMetadataWrapper inwr, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        ArrayList<ModuleMetadata.ModuleMetadataWrapper> localRes = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
        try {
            for (ExpNode node : inwr.metadata.getNotResolved()) {
                ModuleMetadata.ModuleMetadataWrapper wr;
                String imp_name;
                ModuleName mn;
                if (node.imp_name == null || (mn = envImports.get(imp_name = node.imp_name)) == null || (wr = modules.get(imp_name)) != null) continue;
                ps.setString(1, mn.owner);
                ps.setString(2, mn.name);
                ModuleMetadata metadata = null;
                wr = new ModuleMetadata.ModuleMetadataWrapper();
                ResultSet rs = ps.executeQuery();
                try {
                    String impname;
                    if (!rs.next()) continue;
                    wr.module_owner = mn.owner;
                    wr.module_name = mn.name;
                    wr.import_name = impname = this.getImportName(envImports, mn.owner, mn.name);
                    String meta = null;
                    ArrayList<String> lines = new ArrayList<String>();
                    Clob clob = rs.getClob(1);
                    boolean codeIncluded = false;
                    if (clob != null) {
                        meta = clob.getSubString(1L, (int)clob.length());
                        metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                    }
                    Blob blob = rs.getBlob(2);
                    String module = null;
                    if (blob != null) {
                        module = MLEJS_Util.blobToString(blob);
                        if (metadata == null) {
                            metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                            codeIncluded = true;
                        }
                    }
                    if (metadata == null) continue;
                    if (!codeIncluded && module != null) {
                        module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                        MOHEnvironment.addFunctionsCode(metadata, lines);
                    }
                    wr.metadata = metadata;
                    res.add(wr);
                    localRes.add(wr);
                    if (wr.import_name == null) continue;
                    modules.put(wr.import_name, wr);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        catch (Throwable e) {
            if (cw != null) {
                cw.logError("MOHEnvironment.loadImportedModules", e);
            }
            e.printStackTrace();
        }
        for (ModuleMetadata.ModuleMetadataWrapper wr : localRes) {
            if (wr.metadata == null || wr.metadata.getNotResolved().size() <= 0) continue;
            this.loadImportedModules(ps, res, modules, envImports, wr, env_owner, env_name, cw);
        }
    }

    public void loadAndResolveImportedModules(PreparedStatement ps, List<ModuleMetadata.ModuleMetadataWrapper> res, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, Map<String, ModuleName> envImports, ModuleMetadata.ModuleMetadataWrapper inwr, String env_owner, String env_name, RequestManager.ContentWrapper cw) {
        ArrayList<ModuleMetadata.ModuleMetadataWrapper> localRes = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
        try {
            for (ExpNode node : inwr.metadata.getNotResolved()) {
                ModuleMetadata.ModuleMetadataWrapper wr;
                String imp_name;
                ModuleName mn;
                if (node.imp_name == null || (mn = envImports.get(imp_name = node.imp_name)) == null || (wr = modules.get(imp_name)) != null) continue;
                ps.setString(1, mn.owner);
                ps.setString(2, mn.name);
                ModuleMetadata metadata = null;
                wr = new ModuleMetadata.ModuleMetadataWrapper();
                ResultSet rs = ps.executeQuery();
                try {
                    String impname;
                    if (!rs.next()) continue;
                    wr.module_owner = mn.owner;
                    wr.module_name = mn.name;
                    wr.import_name = impname = this.getImportName(envImports, mn.owner, mn.name);
                    String meta = null;
                    ArrayList<String> lines = new ArrayList<String>();
                    Clob clob = rs.getClob(1);
                    boolean codeIncluded = false;
                    if (clob != null) {
                        meta = clob.getSubString(1L, (int)clob.length());
                        metadata = AntlrAstParser.getModuleMetaDataFromJSON(meta);
                    }
                    Blob blob = rs.getBlob(2);
                    String module = null;
                    if (blob != null) {
                        module = MLEJS_Util.blobToString(blob);
                        if (metadata == null) {
                            metadata = AntlrAstParser.getModuleMetadataFromJS(module);
                            codeIncluded = true;
                        }
                    }
                    if (metadata == null) continue;
                    if (!codeIncluded && module != null) {
                        module.lines().forEach(line -> lines.add(line + System.lineSeparator()));
                        MOHEnvironment.addFunctionsCode(metadata, lines);
                    }
                    wr.metadata = metadata;
                    res.add(wr);
                    localRes.add(wr);
                    if (wr.import_name == null) continue;
                    modules.put(wr.import_name, wr);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
        }
        catch (Throwable e) {
            if (cw != null) {
                cw.logError("MOHEnvironment.loadImportedModules", e);
            }
            e.printStackTrace();
        }
        for (ModuleMetadata.ModuleMetadataWrapper wr : localRes) {
            if (wr.metadata == null || wr.metadata.getNotResolved().size() <= 0) continue;
            this.loadImportedModules(ps, res, modules, envImports, wr, env_owner, env_name, cw);
        }
    }

    public static void resolveFunctionParameters(List<ModuleMetadata.ModuleMetadataWrapper> list, Connection conn) {
        String sql = "select json_arrayagg( json_object(p.owner, p.object_name, p.signature, 'params':(select json_arrayagg(obj format json returning json)   from\r\n(select json_object('pname' : argument_name , data_type, in_out, position) obj from ALL_ARGUMENTS a where a.owner = p.owner  and a.object_name = p.object_name order by a.position)) ) format json returning clob) pars from ALL_MLE_PROCEDURES p  \r\nwhere p.module_owner = ? and p.module_name = ?";
        sql = "select  m.signature, a.argument_name pname , a.data_type, a.in_out, a.position from all_mle_procedures m, ALL_ARGUMENTS a \r\nwhere m.module_owner = ? and m.module_name = ?  \r\nand m.owner = a.owner and m.object_name = a.object_name order by m.OWNER, m.OBJECT_NAME, a.position";
        Hashtable<String, ExpNode> map = new Hashtable<String, ExpNode>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setFetchSize(200);
            for (ModuleMetadata.ModuleMetadataWrapper wr : list) {
                if (!wr.metadata.hasExportedOwnFunctions()) continue;
                map.clear();
                String tfn = "";
                ExpNode exp = null;
                int k = 0;
                if (wr.module_owner == null) continue;
                String owner = MLEJS_Util.getName(wr.module_owner);
                String mname = MLEJS_Util.getName(wr.module_name);
                ps.setString(1, owner);
                ps.setString(2, mname);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String[] types = new String[]{};
                        String signature = rs.getString(1);
                        String type = Token.getValBetweenBrackets(signature);
                        if (type != null) {
                            types = type.indexOf(44) > 0 ? type.split(",") : new String[]{type};
                        }
                        if (!signature.equals(tfn)) {
                            String fname;
                            if (exp != null) {
                                map.put(exp.getNameId(), exp);
                            }
                            exp = new ExpNode();
                            tfn = signature;
                            k = 0;
                            exp.name = fname = Token.getValBeforeBrackets(signature);
                            exp.params = new ArrayList<ExpNode.Param>();
                        }
                        String pname = rs.getString(2);
                        String dtype = rs.getString(3);
                        String direction = rs.getString(4);
                        int pos = rs.getInt(5);
                        if (k < types.length) {
                            dtype = types[k].trim();
                        }
                        if (pos == 0) {
                            exp.return_type = dtype;
                            continue;
                        }
                        ExpNode.Param p = new ExpNode.Param();
                        p.name = pname;
                        p.type = dtype;
                        p.direction = direction;
                        exp.params.add(p);
                        ++k;
                    }
                    if (exp != null) {
                        map.put(exp.getNameId(), exp);
                    }
                }
                for (ExpNode node : wr.metadata.getExports()) {
                    ExpNode t = (ExpNode)map.get(node.getNameId());
                    if (t == null) continue;
                    node.return_type = t.return_type;
                    if (node.params == null) continue;
                    int kk = 0;
                    for (ExpNode.Param p : node.params) {
                        ExpNode.Param tp;
                        if (kk < t.params.size() && (tp = t.params.get(kk)) != null) {
                            p.type = tp.type;
                            p.direction = tp.direction;
                        }
                        ++kk;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void resolve(List<ModuleMetadata.ModuleMetadataWrapper> list) {
        Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
        for (ModuleMetadata.ModuleMetadataWrapper wr : list) {
            if (wr.import_name == null) continue;
            modules.put(wr.import_name, wr);
        }
        ArrayList<ExpNode> resolved = new ArrayList<ExpNode>();
        ArrayList<ModuleMetadata.ModuleMetadataWrapper> trackedModules = new ArrayList<ModuleMetadata.ModuleMetadataWrapper>();
        for (ModuleMetadata.ModuleMetadataWrapper wr : list) {
            MOHEnvironment.resolveModule(wr, modules, resolved, trackedModules);
            if (resolved.size() <= 0) continue;
            wr.metadata.getNotResolved().removeAll(resolved);
            resolved.clear();
        }
    }

    public static void resolveModule(ModuleMetadata.ModuleMetadataWrapper wr, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, List<ExpNode> resolved, List<ModuleMetadata.ModuleMetadataWrapper> trackedModules) {
        ModuleMetadata metadata = wr.metadata;
        trackedModules.add(wr);
        ArrayList<ExpNode> notResolved = new ArrayList<ExpNode>(metadata.getNotResolved());
        List<ExpNode> list = metadata.getNotResolvedByType("exportPossibleImport");
        notResolved.removeAll(list);
        notResolved.addAll(list);
        for (ExpNode node : notResolved) {
            String imp_name;
            ModuleMetadata.ModuleMetadataWrapper wr1;
            if (node.imp_name != null && (wr1 = modules.get(imp_name = MLEJS_Util.getName(node.imp_name))) != null && wr1.metadata.getNotResolved().size() > 0 && !trackedModules.contains(wr1)) {
                ArrayList<ExpNode> t_resolved = new ArrayList<ExpNode>();
                MOHEnvironment.resolveModule(wr1, modules, t_resolved, trackedModules);
                if (t_resolved.size() > 0) {
                    wr1.metadata.getNotResolved().removeAll(t_resolved);
                    t_resolved.clear();
                }
            }
            if ("importNamespace".equalsIgnoreCase(node.type)) {
                MOHEnvironment.resolveImportNameSpace(node, metadata, modules, resolved);
                continue;
            }
            if ("importItems".equalsIgnoreCase(node.type)) {
                MOHEnvironment.resolveImportItems(node, metadata, modules, resolved);
                continue;
            }
            if ("exportItemsFromModule".equalsIgnoreCase(node.type)) {
                MOHEnvironment.resolveExportImportedItems(node, metadata, modules, resolved);
                continue;
            }
            if ("exportNamespaceFromModule".equalsIgnoreCase(node.type)) {
                MOHEnvironment.resolveExportImportedNameSpace(node, metadata, modules, resolved);
                continue;
            }
            if (!"exportPossibleImport".equalsIgnoreCase(node.type)) continue;
            MOHEnvironment.resolveExportPossibleImport(node, metadata, modules, resolved);
        }
        trackedModules.remove(wr);
    }

    public static void resolveExportPossibleImport(ExpNode node, ModuleMetadata metadata, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, List<ExpNode> resolved) {
        if ("exportPossibleImport".equalsIgnoreCase(node.type)) {
            boolean found = false;
            for (ExpNode n : metadata.getImports()) {
                try {
                    ExpNode x;
                    if (node.name_in_code != null && node.name_in_code.equals(n.name)) {
                        x = (ExpNode)n.clone();
                        x.name = node.name;
                        metadata.getExports().add(x);
                        found = true;
                        continue;
                    }
                    if (node.name_in_code == null || !node.name_in_code.equals(n.imp_alias)) continue;
                    x = (ExpNode)n.clone();
                    x.imp_alias = node.name;
                    metadata.getExports().add(x);
                    found = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (found) {
                resolved.add(node);
            }
        }
    }

    public static void resolveImportNameSpace(ExpNode node, ModuleMetadata metadata, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, List<ExpNode> resolved) {
        String imp_name = MLEJS_Util.getName(node.imp_name);
        ModuleMetadata.ModuleMetadataWrapper wr = modules.get(imp_name);
        if (wr != null && node.scope.equals("*")) {
            for (ExpNode n : wr.metadata.getExports()) {
                try {
                    ExpNode x = (ExpNode)n.clone();
                    x.imp_name = imp_name;
                    x.imp_alias = node.imp_alias;
                    x.schema = wr.module_owner;
                    x.module = wr.module_name;
                    metadata.getImports().add(x);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            if (wr.metadata.getExports().size() > 0) {
                resolved.add(node);
            }
        }
    }

    public static void resolveExportImportedNameSpace(ExpNode node, ModuleMetadata metadata, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, List<ExpNode> resolved) {
        String imp_name = MLEJS_Util.getName(node.imp_name);
        ModuleMetadata.ModuleMetadataWrapper wr = modules.get(imp_name);
        boolean found = false;
        if (wr != null && node.scope.equals("*")) {
            found = true;
            for (ExpNode n : wr.metadata.getExports()) {
                try {
                    ExpNode x = (ExpNode)n.clone();
                    x.imp_name = imp_name;
                    x.imp_alias = node.imp_alias;
                    x.schema = wr.module_owner;
                    x.module = wr.module_name;
                    metadata.getExports().add(x);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            if (found) {
                resolved.add(node);
            }
        }
    }

    static void addExportItems(List<String> items, Map<String, String> names) {
        if (items != null && items.size() > 0) {
            for (String name : items) {
                String[] parts;
                String alias = name = name.strip();
                if (name.indexOf(" as ") > 0 && (parts = name.split(" as ")).length == 2) {
                    name = parts[0];
                    alias = parts[1];
                }
                names.put(name, alias);
            }
        }
    }

    public static void resolveImportItems(ExpNode node, ModuleMetadata metadata, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, List<ExpNode> resolved) {
        String imp_name = MLEJS_Util.getName(node.imp_name);
        if (node.getExpItems().size() > 0) {
            Hashtable<String, String> names = new Hashtable<String, String>();
            int found = 0;
            MOHEnvironment.addExportItems(node.getExpItems(), names);
            ModuleMetadata.ModuleMetadataWrapper wr = modules.get(imp_name);
            if (wr != null) {
                for (ExpNode n : wr.metadata.getExports()) {
                    try {
                        String rname;
                        String name;
                        if (n.name == null || (name = (String)names.get(rname = MLEJS_Util.getName(n.name))) == null) continue;
                        ExpNode x = (ExpNode)n.clone();
                        x.imp_name = imp_name;
                        x.imp_alias = node.imp_alias;
                        x.schema = wr.module_owner;
                        x.module = wr.module_name;
                        if (!n.name.equals(name)) {
                            x.name = name;
                            x.name_in_code = n.name;
                        }
                        metadata.getImports().add(x);
                        ++found;
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                }
                if (found > 0) {
                    resolved.add(node);
                    if (found < node.getExpItems().size()) {
                        System.out.println("some imports are not resolved - " + (node.getExpItems().size() - found));
                        System.out.println(node.toJSONString());
                    }
                }
            }
        }
    }

    public static void resolveExportImportedItems(ExpNode node, ModuleMetadata metadata, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, List<ExpNode> resolved) {
        String imp_name = MLEJS_Util.getName(node.imp_name);
        if (node.getExpItems().size() > 0) {
            Hashtable<String, String> names = new Hashtable<String, String>();
            int found = 0;
            MOHEnvironment.addExportItems(node.getExpItems(), names);
            ModuleMetadata.ModuleMetadataWrapper wr = modules.get(imp_name);
            if (wr != null) {
                for (ExpNode n : wr.metadata.getExports()) {
                    try {
                        String rname;
                        String name;
                        if (n.name == null || (name = (String)names.get(rname = MLEJS_Util.getName(n.name))) == null) continue;
                        ExpNode x = (ExpNode)n.clone();
                        x.imp_name = imp_name;
                        x.imp_alias = node.imp_alias;
                        x.schema = wr.module_owner;
                        x.module = wr.module_name;
                        if (!n.name.equals(name)) {
                            x.name = name;
                            x.name_in_code = n.name;
                        }
                        metadata.getExports().add(x);
                        ++found;
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                }
                if (found > 0) {
                    resolved.add(node);
                    if (found < node.getExpItems().size()) {
                        System.out.println("some imports are not resolved - " + (node.getExpItems().size() - found));
                        System.out.println(node.toJSONString());
                    }
                }
            }
        }
    }

    public static String toJsonString(List<ModuleMetadata.ModuleMetadataWrapper> items) {
        ExpNode.StringAdd s = new ExpNode.StringAdd();
        s.addText("{").addNL_Tabs("\"items\":[", 1);
        boolean first = true;
        for (ModuleMetadata.ModuleMetadataWrapper wr : items) {
            if (!first) {
                s.addText(",");
            } else {
                first = false;
            }
            s.addTabs(wr.toJSONString(), 2);
        }
        s.addNL().addTabs("]", 1);
        s.addNL().addText("}");
        return s.toString();
    }

    public static List<ModuleName> getDependenciesList(List<ModuleMetadata.ModuleMetadataWrapper> list) {
        Hashtable<String, ModuleMetadata.ModuleMetadataWrapper> modules = new Hashtable<String, ModuleMetadata.ModuleMetadataWrapper>();
        for (ModuleMetadata.ModuleMetadataWrapper wr : list) {
            if (wr.import_name == null) continue;
            modules.put(wr.import_name, wr);
        }
        TreeMap<String, ModuleName> depdendencies = new TreeMap<String, ModuleName>();
        for (ModuleMetadata.ModuleMetadataWrapper wr : list) {
            for (ExpNode node : wr.metadata.getNotResolved()) {
                MOHEnvironment.addDependencies(node, modules, depdendencies);
            }
        }
        if (depdendencies.size() > 0) {
            return new ArrayList<ModuleName>(depdendencies.values());
        }
        return Collections.emptyList();
    }

    public static void addDependencies(ExpNode node, Map<String, ModuleMetadata.ModuleMetadataWrapper> modules, Map<String, ModuleName> depdendencies) {
        String imp_name;
        ModuleMetadata.ModuleMetadataWrapper wr;
        if (("importNamespace".equalsIgnoreCase(node.type) || "importItems".equalsIgnoreCase(node.type) || "exportItemsFromModule".equalsIgnoreCase(node.type) || "exportNamespaceFromModule".equalsIgnoreCase(node.type)) && (wr = modules.get(imp_name = MLEJS_Util.getName(node.imp_name))) != null) {
            ModuleName mn = new ModuleName();
            mn.import_name = imp_name;
            mn.owner = wr.module_owner;
            mn.name = wr.module_name;
            if (!depdendencies.containsKey(mn.getID())) {
                depdendencies.put(mn.getID(), mn);
            }
        }
    }

    public static void main(String[] args) throws IOException, SQLException {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:2323/orclpdb1", "MLE_T", "oracle");
        System.out.println("start - " + System.currentTimeMillis());
        DBMExtractionHandlerMLE_JS handler = new DBMExtractionHandlerMLE_JS(conn);
        MOHEnvironment moh = new MOHEnvironment(handler);
        String code = "import {greet as hello} from \"mod1\";\n import * as imp1 from 'dept_rs';\n import * as m1 from 'mod1';";
        code = "import * as m1 from 'mod1';\r\nimport * as imp1 from 'dept_rs';\r\nimport * as m1 from 'str';\r\nimport * as m from 'mle-js-oracledb';";
        String res = moh.getModulesDeclarationForImports(conn, code, "MLE_T", "ENV55", null);
        System.out.println("end - " + System.currentTimeMillis());
        System.out.println(res);
    }

    public static class ModuleName {
        public String owner;
        public String name;
        public String import_name;

        String getID() {
            return this.owner + "." + this.name;
        }

        public String toString() {
            return this.getID() + (String)(this.import_name != null ? "/" + this.import_name : "");
        }
    }
}

