/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerWindow;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class CSSBSchedulerWindow
extends CSSBScheduler {
    Map<String, String> excludeNullsMap = new HashMap<String, String>();

    public CSSBSchedulerWindow() {
        this.excludeNullsMap.put("OWNER", "OWNER");
        this.excludeNullsMap.put("WINDOW_NAME", "WINDOW_NAME");
        this.excludeNullsMap.put("SCHEDULE_OWNER", "WINDOW_NAME");
        this.excludeNullsMap.put("DURATION", "DURATION");
        this.excludeNullsMap.put("RESOURCE_PLAN", "RESOURCE_PLAN");
        this.excludeNullsMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeNullsMap.put("ENABLED", "ENABLED");
    }

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("WINDOW_NAME", "WINDOW_NAME");
        this.excludeMap.put("SCHEDULE_OWNER", "WINDOW_NAME");
        this.excludeMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SchedulerObjectCompare comp;
        if (object instanceof SchedulerObjectCompare && (comp = (SchedulerObjectCompare)object).isModified()) {
            Map<String, String> excludeMap = this.getExcludeMap();
            StringBuffer buffer = new StringBuffer();
            CSSBSchedulerWindow.appendStringWithSpace(buffer, "BEGIN");
            boolean disabled = false;
            if (comp.hasAttributesToSetNull(this.excludeNullsMap)) {
                CSSBSchedulerWindow.appendDisable(buffer, comp, prettyPrint);
                disabled = true;
            }
            CSSBSchedulerWindow.appendNullAtrtributes(buffer, comp, prettyPrint, this.excludeNullsMap);
            CSSBSchedulerWindow.appendSchedule(buffer, comp, prettyPrint);
            CSSBSchedulerWindow.appendAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerWindow.appendEnable(buffer, comp, disabled, prettyPrint);
            CSSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 0);
            CSSBSchedulerWindow.appendString(buffer, "END");
            CSSBSchedulerWindow.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, "");
        }
    }

    public static void appendSchedule(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String type = comp.getProperty("SCHEDULE_TYPE");
        if (type != null && !type.isEmpty()) {
            if ("NAMED".equalsIgnoreCase(type)) {
                String schedName = comp.getFormattedName("SCHEDULE_OWNER", "SCHEDULE_NAME");
                if (schedName != null && !schedName.isEmpty()) {
                    CSSBSchedulerWindow.appendSetAttribute(buffer, comp.getObjectFormattedName(), "schedule_name", schedName, "VARCHAR", prettyPrint);
                }
            } else if ("CALENDAR".equalsIgnoreCase(type)) {
                // empty if block
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerObjectCompare && ((SchedulerObjectCompare)object).getSource() instanceof SchedulerWindow;
    }
}

