/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.SSBSchedulerProgram;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.CSSBScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerArgument;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerProgramCompare;

public class CSSBSchedulerProgram
extends CSSBScheduler {
    Map<String, String> excludeNullsMap = new HashMap<String, String>();

    public CSSBSchedulerProgram() {
        this.excludeNullsMap.put("NUMBER_OF_ARGUMENTS", "NUMBER_OF_ARGUMENTS");
        this.excludeNullsMap.put("PROGRAM_NAME", "PROGRAM_NAME");
        this.excludeNullsMap.put("PROGRAM_TYPE", "PROGRAM_NAME");
        this.excludeNullsMap.put("PROGRAM_ACTION", "PROGRAM_NAME");
        this.excludeNullsMap.put("OWNER", "PROGRAM_OWNER");
        this.excludeNullsMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeNullsMap.put("ENABLED", "ENABLED");
        this.excludeNullsMap.put("DETACHED", "ENABLED");
        this.excludeNullsMap.put("PRIORITY", "ENABLED");
    }

    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new HashMap();
        }
        this.excludeMap.put("PROGRAM_NAME", "PROGRAM_NAME");
        this.excludeMap.put("OWNER", "PROGRAM_OWNER");
        this.excludeMap.put("HAS_CONSTRAINTS", "HAS_CONSTRAINTS");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        SchedulerProgramCompare comp;
        if (object instanceof SchedulerProgramCompare && (comp = (SchedulerProgramCompare)object).isModified()) {
            Map<String, String> excludeMap = this.getExcludeMap();
            StringBuffer buffer = new StringBuffer();
            CSSBSchedulerProgram.appendStringWithSpace(buffer, "BEGIN");
            boolean disabled = false;
            if (comp.hasAttributesToSetNull(this.excludeNullsMap)) {
                disabled = true;
                CSSBSchedulerProgram.appendDisable(buffer, comp, prettyPrint);
            }
            CSSBSchedulerProgram.appendNullAtrtributes(buffer, comp, prettyPrint, excludeMap);
            CSSBSchedulerProgram.appendAtrtributes(buffer, comp, prettyPrint, excludeMap);
            this.appendArguments(buffer, comp, (SchedulerProgram)comp.getSource(), prettyPrint, excludeMap);
            CSSBSchedulerProgram.appendEnable(buffer, comp, disabled, prettyPrint);
            CSSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 0);
            CSSBSchedulerProgram.appendString(buffer, "END");
            CSSBSchedulerProgram.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, "");
        }
    }

    public static void setNumberOfArgumentsToZero(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getTarget().getProperty("NUMBER_OF_ARGUMENTS");
        if (val == null) {
            CSSBSchedulerProgram.appendSetAttribute(buffer, comp.getObjectFormattedName(), "NUMBER_OF_ARGUMENTS", "0", "NUMBER", prettyPrint);
        }
    }

    public static void setNumberOfArguments(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String val = comp.getProperty("NUMBER_OF_ARGUMENTS");
        if (val != null && !val.isEmpty()) {
            CSSBSchedulerProgram.appendSetAttribute(buffer, comp.getObjectFormattedName(), "NUMBER_OF_ARGUMENTS", val, "NUMBER", prettyPrint);
        } else if (comp.containsNullProp("NUMBER_OF_ARGUMENTS")) {
            CSSBSchedulerProgram.appendNullAtrtribute(buffer, comp, "NUMBER_OF_ARGUMENTS", prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerObjectCompare && ((SchedulerObjectCompare)object).getSource() instanceof SchedulerProgram;
    }

    public void appendArguments(StringBuffer buffer, SchedulerProgramCompare comp, SchedulerProgram prog, boolean prettyPrint, Map<String, String> excludeMap) {
        for (SchedulerArgument arg : comp.getArgsToRemove()) {
            CSSBSchedulerProgram.dropdProgramArgument(buffer, comp, arg, prettyPrint);
        }
        for (SchedulerArgument arg : comp.getArgsToAdd()) {
            if (arg.isMetadataArgument()) {
                SSBSchedulerProgram.appendMetadataArgument(buffer, prog, arg, prettyPrint);
                continue;
            }
            SSBSchedulerProgram.appendProgramArgument(buffer, prog, arg, prettyPrint);
        }
    }

    public static void dropdProgramArgument(StringBuffer buffer, SchedulerProgramCompare comp, SchedulerArgument arg, boolean prettyPrint) {
        CSSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
        CSSBSchedulerProgram.appendStringWithSpace(buffer, "DBMS_SCHEDULER.DROP_PROGRAM_ARGUMENT(");
        SSBSchedulerProgram.appendStringAttribute(buffer, "program_name".toLowerCase(), comp.getObjectFormattedName(), prettyPrint);
        CSSBSchedulerProgram.appendString(buffer, ',');
        SSBSchedulerProgram.appendNonStringAttribute(buffer, "ARGUMENT_POSITION".toLowerCase(), arg.getProperty("ARGUMENT_POSITION"), prettyPrint);
        CSSBSchedulerProgram.appendNewLine(buffer, prettyPrint, 1);
        CSSBSchedulerProgram.appendStringWithSpace(buffer, ");");
    }
}

