/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling.compare;

import java.util.Map;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;

public class CSSBScheduler
extends SQLStatementBuilderScheduler {
    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
    }

    @Override
    public boolean canHandle(Object object) {
        return false;
    }

    public static void appendDisable(StringBuffer buffer, SchedulerObjectCompare cmp, boolean prettyPrint) {
        String name = cmp.getSource().getNameFormatted();
        if (cmp.getTarget() != null) {
            name = cmp.getTarget().getNameFormatted();
            String enabled = cmp.getTarget().getProperty("enabled");
            if (enabled != null && "FALSE".equalsIgnoreCase(enabled)) {
                return;
            }
        }
        CSSBScheduler.appendNewLine(buffer, prettyPrint, 1);
        CSSBScheduler.appendStringWithSpace(buffer, "DBMS_SCHEDULER.disable(name => '" + name + "');");
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObjectCompare cmp, boolean prettyPrint) {
        CSSBScheduler.appendEnable(buffer, cmp, false, prettyPrint);
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObjectCompare cmp, boolean wasDisabled, boolean prettyPrint) {
        String res = cmp.getProperty("enabled");
        String name = cmp.getSource().getNameFormatted();
        if (res != null && !res.isEmpty()) {
            CSSBScheduler.appendNewLine(buffer, prettyPrint, 1);
            if ("TRUE".equalsIgnoreCase(res)) {
                CSSBScheduler.appendStringWithSpace(buffer, "DBMS_SCHEDULER.enable(name => '" + name + "');");
            } else {
                CSSBScheduler.appendStringWithSpace(buffer, "DBMS_SCHEDULER.disable(name => '" + name + "');");
            }
        } else if (wasDisabled) {
            if (cmp.getTarget() != null) {
                String enabled = cmp.getTarget().getProperty("enabled");
                if (enabled != null && "FALSE".equalsIgnoreCase(enabled)) {
                    return;
                }
                name = cmp.getTarget().getNameFormatted();
            }
            CSSBScheduler.appendNewLine(buffer, prettyPrint, 1);
            CSSBScheduler.appendStringWithSpace(buffer, "DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    public static void appendAtrtributes(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint, Map<String, String> excludeMap) {
        SchedulerObject obj = comp.getSource();
        for (String prop : obj.getPropsList()) {
            String value;
            if (excludeMap.get(prop) != null || (value = comp.getProperty(prop)) == null) continue;
            String dataType = obj.getPropertyDataType(prop);
            CSSBScheduler.appendSetAttribute(buffer, obj.getNameFormatted(), prop.toLowerCase(), CSSBScheduler.replaceSingle_Quote(value), dataType, prettyPrint);
        }
    }

    public static void appendSetAttribute(StringBuffer buffer, String name, String attribute, String value, String dataType, boolean prettyPrint) {
        CSSBScheduler.appendSetAttribute(buffer, name, attribute, value, dataType, prettyPrint, false, null, null);
    }

    public static void appendSetAttribute(StringBuffer buffer, String name, String attribute, String value, String dataType, boolean prettyPrint, boolean secondValue, String value2, String dataType2) {
        if (name != null && !name.isEmpty() && attribute != null && !attribute.isEmpty()) {
            String val;
            CSSBScheduler.appendNewLine(buffer, prettyPrint, 1);
            CSSBScheduler.appendStringWithSpace(buffer, "DBMS_SCHEDULER.SET_ATTRIBUTE(");
            CSSBScheduler.appendNewLine(buffer, prettyPrint, 2);
            CSSBScheduler.appendString(buffer, "NAME".toLowerCase() + " => '" + name + "',");
            CSSBScheduler.appendNewLine(buffer, prettyPrint, 2);
            CSSBScheduler.appendString(buffer, "ATTRIBUTE".toLowerCase() + " => '" + attribute + "',");
            CSSBScheduler.appendNewLine(buffer, prettyPrint, 2);
            if (value == null) {
                CSSBScheduler.appendString(buffer, "VALUE".toLowerCase() + " => null");
            } else {
                val = CSSBScheduler.getValue(value, dataType);
                CSSBScheduler.appendString(buffer, "VALUE".toLowerCase() + " => " + val);
            }
            if (secondValue) {
                CSSBScheduler.appendString(buffer, ',');
                if (value2 == null) {
                    CSSBScheduler.appendString(buffer, "value2 => null");
                } else {
                    val = CSSBScheduler.getValue(value2, dataType2);
                    CSSBScheduler.appendString(buffer, "value2 => " + val);
                }
            }
            CSSBScheduler.appendString(buffer, ");");
        }
    }

    public static void appendNullAtrtributes(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint, Map<String, String> excludeMap) {
        for (String prop : comp.getSetNullAttrList()) {
            if (excludeMap.get(prop) != null) continue;
            CSSBScheduler.appendNullAtrtribute(buffer, comp, prop, prettyPrint);
        }
    }

    public static void appendNullAtrtribute(StringBuffer buffer, SchedulerObjectCompare comp, String prop, boolean prettyPrint) {
        CSSBScheduler.appendNewLine(buffer, prettyPrint, 1);
        CSSBScheduler.appendStringWithSpace(buffer, "DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(" + "NAME".toLowerCase() + " => '" + comp.getObjectFormattedName() + "'," + "ATTRIBUTE".toLowerCase() + " => '" + prop + "');");
    }

    public static void appendCredential(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String[] arr = new String[]{"CREDENTIAL_OWNER", "CREDENTIAL_NAME"};
        boolean changed = comp.propertyChanged(arr);
        if (changed) {
            String res = comp.getFormattedName("CREDENTIAL_OWNER", "CREDENTIAL_NAME");
            if (comp.containsNullProp("CREDENTIAL_NAME") || res == null || res.isEmpty()) {
                CSSBScheduler.appendNullAtrtribute(buffer, comp, "credential_name", prettyPrint);
            } else {
                CSSBScheduler.appendSetAttribute(buffer, comp.getObjectFormattedName(), "credential_name", res, null, prettyPrint);
            }
        }
    }

    public static void appendDestination(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String[] arr = new String[]{"DESTINATION_OWNER", "DESTINATION"};
        boolean changed = comp.propertyChanged(arr);
        if (changed) {
            String res = comp.getFormattedName("DESTINATION_OWNER", "DESTINATION");
            if (comp.containsNullProp("DESTINATION") || res == null || res.isEmpty()) {
                CSSBScheduler.appendNullAtrtribute(buffer, comp, "DESTINATION".toLowerCase(), prettyPrint);
            } else {
                CSSBScheduler.appendSetAttribute(buffer, comp.getObjectFormattedName(), "DESTINATION".toLowerCase(), res, null, prettyPrint);
            }
        }
    }

    public static void appendDestinationName(StringBuffer buffer, SchedulerObjectCompare comp, boolean prettyPrint) {
        String[] arr = new String[]{"DESTINATION_OWNER", "DESTINATION"};
        boolean changed = comp.propertyChanged(arr);
        if (changed) {
            String res = comp.getFormattedName("DESTINATION_OWNER", "DESTINATION");
            if (comp.containsNullProp("DESTINATION_NAME") || res == null || res.isEmpty()) {
                CSSBScheduler.appendNullAtrtribute(buffer, comp, "destination_name", prettyPrint);
            } else {
                CSSBScheduler.appendSetAttribute(buffer, comp.getObjectFormattedName(), "destination_name", res, null, prettyPrint);
            }
        }
    }
}

