/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.util.Iterator;
import java.util.logging.Logger;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;
import oracle.javatools.util.PlatformUtils;

public class OracleEnvHelper {
    private static Logger logger = Logger.getLogger("oracle.dbtools.raptor.utils");
    private static String OH = null;
    private static String HOME_KEY = null;
    private static Object LOCK = new Object();

    public static String getOracleEnv(String string) {
        if (PlatformUtils.isWindows()) {
            return OracleEnvHelper.getFromRegistry(string);
        }
        return OracleEnvHelper.getFromEnv(string);
    }

    private static String getFromEnv(String string) {
        String string2 = null;
        string2 = System.getenv(string);
        logger.info("Found:" + string + "=" + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFromRegistry(String string) {
        String string2 = null;
        logger.info("Attempting to read");
        try {
            Object object = LOCK;
            synchronized (object) {
                if (HOME_KEY == null) {
                    OracleEnvHelper.getOracleHome();
                }
            }
            if (HOME_KEY != null) {
                logger.info("Checking with Key:" + HOME_KEY);
                object = NativeHandler.getRegistry().getLocalMachineKey().openKey(HOME_KEY, 131097L);
                string2 = object.getStringValue(string);
                logger.info("Found:" + string + "=" + string2);
            }
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
        return string2;
    }

    private static void getOracleHome() {
        String string = "SOFTWARE\\ORACLE";
        String string2 = null;
        NativeHandler nativeHandler = new NativeHandler();
        nativeHandler.initialize();
        try {
            RegistryKey registryKey;
            logger.info("Checking with Key:" + string);
            RegistryKey registryKey2 = NativeHandler.getRegistry().getLocalMachineKey().openKey(string, 131097L);
            Iterator iterator = registryKey2.iterateSubKeys();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                e.toString();
                try {
                    String string3 = string + "\\" + e.toString();
                    logger.info("Checking with Key:" + string3);
                    registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string3, 131097L);
                    HOME_KEY = registryKey.getStringValue("ORACLE_HOME_KEY");
                }
                catch (RegistryException registryException) {
                    logger.fine("registry execption" + registryException.getMessage());
                }
            }
            if (string2 != null) {
                logger.info("Checking with Key:" + string2);
                registryKey = NativeHandler.getRegistry().getLocalMachineKey().openKey(string2, 131097L);
                OH = registryKey.getStringValue("ORACLE_HOME");
                logger.info("Found:" + OH);
            }
        }
        catch (RegistryNotAvailableException registryNotAvailableException) {
        }
        catch (RegistryException registryException) {
            // empty catch block
        }
    }
}

