/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.Component;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.RaptorMessageDialog;
import oracle.dbtools.raptor.dialogs.SQLErrorPanel;
import oracle.dbtools.raptor.dialogs.SQLExceptionScrubber;
import oracle.javatools.dialogs.MessageDialog;

public class SQLErrorDialog {
    public static synchronized void registerScrubber(SQLExceptionScrubber sQLExceptionScrubber) {
        ScrubberHolder.INSTANCE.registerScrubber(sQLExceptionScrubber);
    }

    public static void showErrorDialog(String string, Component component, String string2, SQLException sQLException, String string3, int n) {
        SQLErrorPanel.Builder builder = SQLErrorPanel.createBuilder(string);
        SQLErrorPanel sQLErrorPanel = builder.sql(string3).offset(n).error(sQLException).build();
        SQLErrorDialog.runErrorDialog(sQLErrorPanel, string, component, string2, null);
    }

    public static void showErrorDialog(String string, Component component, String string2, SQLException sQLException, String string3, int n, int n2, int n3) {
        SQLErrorPanel sQLErrorPanel = SQLErrorPanel.createBuilder(string).sql(string3).offset(n).position(n3, n2).error(sQLException).build();
        SQLErrorDialog.runErrorDialog(sQLErrorPanel, string, component, string2, null);
    }

    public static void showErrorDialog(String string, Component component, String string2, SQLException sQLException) {
        SQLErrorPanel sQLErrorPanel = SQLErrorPanel.createBuilder(string).error(sQLException).build();
        String string3 = DialogResources.getString("SQL_EXCEPTION_TITLE");
        SQLErrorDialog.runErrorDialog(sQLErrorPanel, string, component, string3, null);
    }

    public static void showWarningDialog(String string, Component component, SQLWarning sQLWarning) {
        SQLErrorPanel sQLErrorPanel = SQLErrorPanel.createBuilder(string).warning(sQLWarning).build();
        String string2 = DialogResources.getString("SQL_WARNING_TITLE");
        SQLErrorDialog.runWarningDialog(sQLErrorPanel, string, component, string2, null);
    }

    public static boolean showErrorWithActionsDialog(String string, Component component, String string2, SQLException sQLException, String string3, String string4) {
        SQLErrorPanel sQLErrorPanel = SQLErrorPanel.createBuilder(string).error(sQLException).build();
        if (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return SQLErrorDialog.runErrorWithActionDialog(sQLErrorPanel, string, component, string2, null, string3, string4);
    }

    private static void runErrorDialog(SQLErrorPanel sQLErrorPanel, String string, Component component, String string2, String string3) {
        MessageDialog.error((Component)component, (Object)sQLErrorPanel, (String)string2, (String)string3);
    }

    protected static void runWarningDialog(SQLErrorPanel sQLErrorPanel, String string, Component component, String string2, String string3) {
        MessageDialog.information((Component)component, (Object)sQLErrorPanel, (String)string2, (String)string3);
    }

    protected static boolean runConfirmDialog(SQLErrorPanel sQLErrorPanel, String string, Component component, String string2, String string3) {
        return MessageDialog.confirm((Component)component, (Object)sQLErrorPanel, (String)string2, (String)string3, (boolean)false, (String)Messages.getString("SQLErrorDialog.3"), (String)Messages.getString("SQLErrorDialog.4"));
    }

    protected static boolean runErrorWithActionDialog(SQLErrorPanel sQLErrorPanel, String string, Component component, String string2, String string3, String string4, String string5) {
        return RaptorMessageDialog.errorAction(component, sQLErrorPanel, string2, null, string4, string5);
    }

    public static Object[] getLineAndColumn(String string, int n, int n2, int n3) {
        String[] stringArray = null;
        if (string.length() >= n) {
            String string2 = "";
            string2 = string.length() >= n + 1 ? string.substring(0, n + 1) : string.substring(0, n);
            stringArray = string2.split("\n");
        } else {
            stringArray = new String[]{string};
        }
        int n4 = stringArray[stringArray.length - 1].length();
        int n5 = stringArray.length;
        if (n2 >= 0 && n3 >= 0 && n5 == 1) {
            n4 = n4 + n3 - 1;
        }
        if (n2 >= 0) {
            n5 = n5 + n2 - 1;
        }
        return new Object[]{n5, n4};
    }

    static class ScrubberHolder
    implements Iterable<SQLExceptionScrubber> {
        static final ScrubberHolder INSTANCE = new ScrubberHolder();
        private List<SQLExceptionScrubber> SCRUBBERS = new ArrayList<SQLExceptionScrubber>();

        private ScrubberHolder() {
        }

        void registerScrubber(SQLExceptionScrubber sQLExceptionScrubber) {
            this.SCRUBBERS.add(sQLExceptionScrubber);
        }

        @Override
        public Iterator<SQLExceptionScrubber> iterator() {
            return this.SCRUBBERS.iterator();
        }
    }
}

