/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.treetable;

import java.awt.Component;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.treetable.RowNode;
import oracle.dbtools.raptor.controls.treetable.SpannedRowsUI;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.JTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;

public class QueryModel
extends AbstractTreeTableModel {
    private PreparedStatement stmt = null;
    private ResultSet rs = null;
    ResultSetMetaData metaData = null;
    List<String> columns = new ArrayList<String>();

    public QueryModel(String string, Object object, Connection connection) throws Exception {
        super((Object)new RowNode());
        ((RowNode)this.root).id = 1;
        this.stmt = connection.prepareStatement(string);
        this.stmt.setObject(1, object);
        this.rs = this.stmt.executeQuery();
        this.metaData = this.rs.getMetaData();
        for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
            String string2 = this.metaData.getColumnLabel(i);
            if ("id".equalsIgnoreCase(string2) || "parent_id".equalsIgnoreCase(string2)) continue;
            this.columns.add(string2);
        }
    }

    public QueryModel(String string, Connection connection) throws Exception {
        super((Object)new RowNode());
        ((RowNode)this.root).id = 1;
        this.stmt = connection.prepareStatement(string);
        List list = LexerToken.parse((String)string);
        boolean bl = false;
        int n = 1;
        for (Object object : list) {
            if (bl) {
                this.stmt.setObject(n++, null);
            }
            bl = ":".equals(object.content);
        }
        this.rs = this.stmt.executeQuery();
        this.metaData = this.rs.getMetaData();
        for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
            Object object;
            object = this.metaData.getColumnLabel(i);
            if ("id".equalsIgnoreCase((String)object) || "parent_id".equalsIgnoreCase((String)object)) continue;
            this.columns.add((String)object);
        }
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.rs = null;
    }

    public int getColumnCount() {
        return this.displayedColumns().size();
    }

    public String getColumnName(int n) {
        return this.displayedColumns().get(n);
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object object, int n) {
        if (n == 0) {
            return object;
        }
        String string = this.getColumnName(n);
        RowNode rowNode = (RowNode)object;
        return rowNode.row.get(string);
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public List<String> displayedColumns() {
        return this.columns;
    }

    public void query() {
        this.query(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(List<Object> list) {
        this.root = new RowNode();
        ((RowNode)this.root).id = 1;
        try {
            if (this.rs == null) {
                int n = 1;
                for (Object object : list) {
                    this.stmt.setObject(n++, object);
                }
                this.rs = this.stmt.executeQuery();
                this.metaData = this.rs.getMetaData();
            }
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            RowNode rowNode = (RowNode)this.root;
            hashMap.put(1, rowNode);
            while (this.rs.next()) {
                Object object;
                object = new RowNode();
                ((RowNode)object).id = this.rs.getInt("id");
                ((RowNode)object).parentId = this.rs.getInt("parent_id");
                for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
                    String string = this.metaData.getColumnLabel(i);
                    if ("id".equalsIgnoreCase(string) || "parent_id".equalsIgnoreCase(string)) continue;
                    if (((RowNode)object).name == null) {
                        ((RowNode)object).name = this.rs.getString(i);
                    }
                    ((RowNode)object).row.put(string, this.rs.getString(i));
                }
                hashMap.put(((RowNode)object).id, object);
                if (1 == ((RowNode)object).id) {
                    this.root = object;
                    continue;
                }
                RowNode rowNode2 = (RowNode)hashMap.get(((RowNode)object).parentId);
                rowNode2.add((MutableTreeNode)object);
                ((DefaultMutableTreeNode)object).setParent(rowNode2);
            }
            if (rowNode.row.size() == 0) {
                for (String string : this.columns) {
                    rowNode.row.put(string, "");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException sQLException) {}
            }
            this.rs = null;
        }
    }

    public void reload(final JTree jTree) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TreeNode treeNode = (TreeNode)QueryModel.this.root;
                QueryModel.this.fireTreeStructureChanged((Object)QueryModel.this, new TreeNode[]{treeNode}, null, null);
                for (int i = 0; i < jTree.getRowCount(); ++i) {
                    jTree.expandRow(i);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JTreeTable createGUI() {
        Serializable serializable;
        JTreeTable jTreeTable = new JTreeTable((TreeTableModel)this){

            protected Boolean isZebraRows() {
                return true;
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 == 0 || n == 0) {
                    return component;
                }
                if (n2 != 0 && this.isZebraRows().booleanValue() && !this.isCellSelected(n, n2)) {
                    if (n % 2 == 0 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color00);
                    } else if (n % 2 == 0 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color10);
                    } else if (n % 2 == 1 && n2 % 2 == 0) {
                        component.setBackground(RaptorGridTable.color01);
                    } else if (n % 2 == 1 && n2 % 2 == 1) {
                        component.setBackground(RaptorGridTable.color11);
                    }
                }
                return component;
            }
        };
        jTreeTable.setUI((TableUI)new SpannedRowsUI(jTreeTable));
        jTreeTable.setAutoResizeMode(0);
        jTreeTable.setCellSelectionEnabled(false);
        jTreeTable.setColumnSelectionAllowed(false);
        jTreeTable.setRowSelectionAllowed(false);
        for (int i = 1; i < jTreeTable.getColumnModel().getColumnCount(); ++i) {
            serializable = jTreeTable.getColumnModel().getColumn(i);
        }
        JTree jTree = jTreeTable.getTree();
        jTree.setShowsRootHandles(true);
        jTree.setRootVisible(false);
        serializable = new DefaultTreeCellRenderer();
        ((DefaultTreeCellRenderer)serializable).setLeafIcon(null);
        ((DefaultTreeCellRenderer)serializable).setClosedIcon(null);
        ((DefaultTreeCellRenderer)serializable).setOpenIcon(null);
        jTree.setCellRenderer((TreeCellRenderer)((Object)serializable));
        return jTreeTable;
    }
}

