/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.IRowIterator;
import oracle.dbtools.raptor.controls.grid.IterableRow;
import oracle.dbtools.raptor.controls.grid.RaptorGridCell;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;

public class IteratorTableModel<R extends IterableRow>
extends AbstractRaptorGridModel {
    private transient IRowIterator<R> rowIterator = null;
    private transient ArrayList<GridColumn> columns = null;

    public void setIterator(IRowIterator<R> iRowIterator) {
        if (this.rowIterator != iRowIterator) {
            this.rowIterator = iRowIterator;
        }
    }

    @Override
    protected RaptorTask<List<RaptorGridRowModel>> createFetchTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, final int n) {
        return new RaptorTask<List<RaptorGridRowModel>>(string, bl, iRaptorTaskRunMode){

            protected List<RaptorGridRowModel> doWork() throws TaskException {
                try {
                    this.checkCanProceed();
                    IteratorTableModel.this.fetchNext(n, this.getRaptorTaskProgressUpdater());
                    this.checkCanProceed();
                }
                catch (ExecutionException executionException) {
                    throw new TaskException((Throwable)executionException);
                }
                return IteratorTableModel.this.getModelList();
            }

            public boolean cancel() {
                return true;
            }
        };
    }

    @Override
    protected void fetchNext(int n, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        if (this.rowIterator == null) {
            this.setIterator(this.getTableIterator());
        }
        if (this.rowIterator != null) {
            int n2 = this.getModelList().size();
            while (n > 0 && this.rowIterator.hasNext()) {
                IterableRow iterableRow = (IterableRow)this.rowIterator.next();
                this.addRow(this.getGridRow(iterableRow), n2);
                ++n2;
                --n;
            }
        }
        if (this.rowIterator == null || !this.rowIterator.hasNext()) {
            this.setAllRowsFetched(true);
        }
    }

    protected List<? extends RaptorGridCell> getGridRow(R r) {
        ArrayList<RaptorGridCell> arrayList = new ArrayList<RaptorGridCell>();
        for (Object t : r) {
            arrayList.add(new RaptorGridCell(t));
        }
        return arrayList;
    }

    @Override
    public List<? extends GridColumn> getGridColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList();
            if (this.rowIterator != null) {
                for (int i = 0; i < this.rowIterator.getFieldCount(); ++i) {
                    Object object = this.rowIterator.getFieldName(i);
                    if (object == null) {
                        object = "" + i;
                    }
                    this.columns.add(new GridColumn((String)object, false));
                }
            }
        }
        return this.columns;
    }

    @Override
    public int getColumnCount() {
        return this.getGridColumns().size();
    }

    @Override
    public boolean isFilterApplied() {
        return false;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    protected int findTotalRows(boolean bl) {
        return -1;
    }

    protected IRowIterator<R> getTableIterator() {
        return this.rowIterator;
    }

    @Override
    public String getModelUniqueName() {
        return null;
    }
}

