/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.controls.grid.ColumnHeaderCellRenderer;
import oracle.dbtools.raptor.controls.grid.IRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.Messages;

public class ColumnAutoSizer
extends MouseAdapter {
    private static final int DEFAULT_COLUMN_PADDING = 5;
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    public static String AUTO_FIT_ALL = Messages.getString("ColumnAutoSize.0");
    public static String AUTO_FIT_SELECTED = Messages.getString("ColumnAutoSize.1");
    public static String AUTO_FIT_ON_DATA = Messages.getString("ColumnAutoSize.2");
    public static String AUTO_FIT_ON_HEADER = Messages.getString("ColumnAutoSize.3");
    public static String AUTO_FIT_DEFAULT = Messages.getString("ColumnAutoSize.4");
    public static String AUTO_FIT_OPTIMUM = Messages.getString("ColumnAutoSize.5");
    public static String AUTO_FIT_SCREEN = Messages.getString("ColumnAutoSize.6");

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            JTable jTable = jTableHeader.getTable();
            TableColumn tableColumn = this.getResizingColumn(jTableHeader, mouseEvent.getPoint());
            if (tableColumn != null) {
                ColumnAutoSizer.autoResizeTableColumn(jTable, tableColumn, AUTO_FIT_OPTIMUM, 5);
                jTableHeader.setResizingColumn(tableColumn);
                jTable.getParent().validate();
            }
        }
    }

    public static int autoResizeTable(JTable jTable, String string) {
        return ColumnAutoSizer.autoResizeTable(jTable, string, 5);
    }

    public static int autoResizeSelectedColumns(JTable jTable, String string) {
        int n = 0;
        int[] nArray = jTable.getSelectedColumns();
        for (int i = 0; i < nArray.length; ++i) {
            n += ColumnAutoSizer.autoResizeTableColumn(jTable, jTable.getColumnModel().getColumn(nArray[i]), string, 5);
        }
        return n;
    }

    public static int autoResizeTable(JTable jTable, String string, int n) {
        TableColumn tableColumn;
        int n2;
        if (string.equals(AUTO_FIT_SCREEN)) {
            jTable.setAutoResizeMode(4);
            return jTable.getWidth();
        }
        jTable.setAutoResizeMode(0);
        int n3 = jTable.getWidth();
        int n4 = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        Dimension dimension = jTable.getIntercellSpacing();
        int[] nArray = jTable.getSelectedColumns();
        int n5 = nArray.length;
        n5 = jTable.getColumnCount();
        nArray = new int[n5];
        for (int i = 0; i < n5; ++i) {
            nArray[i] = i;
        }
        int[] nArray2 = new int[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            tableColumn = tableColumnModel.getColumn(nArray[n2]);
            nArray2[n2] = ColumnAutoSizer.getMaxColumnWidth(jTable, tableColumn, string, n);
            n4 += nArray2[n2];
        }
        n4 += (n5 - 1) * dimension.width;
        for (n2 = 0; n2 < n5; ++n2) {
            tableColumn = tableColumnModel.getColumn(nArray[n2]);
            tableColumn.setPreferredWidth(nArray2[n2]);
        }
        ColumnAutoSizer.repaint(jTable);
        return n4;
    }

    public static int autoResizeTableColumn(JTable jTable, TableColumn tableColumn, String string, int n) {
        int n2 = 0;
        tableColumn.setPreferredWidth(ColumnAutoSizer.getMaxColumnWidth(jTable, tableColumn, string, n));
        ColumnAutoSizer.repaint(jTable);
        return n2;
    }

    public static int getMaxColumnWidth(JTable jTable, TableColumn tableColumn, String string, int n) {
        int n2 = 0;
        if (string.equals(AUTO_FIT_ON_HEADER) || string.equals(AUTO_FIT_DEFAULT)) {
            n2 = ColumnAutoSizer.getHeaderWidth(jTable, tableColumn);
        } else if (string.equals(AUTO_FIT_ON_DATA)) {
            n2 = ColumnAutoSizer.getMaxCellDataWidth(jTable, tableColumn);
        } else if (string.equals(AUTO_FIT_OPTIMUM)) {
            int n3 = ColumnAutoSizer.getHeaderWidth(jTable, tableColumn);
            int n4 = ColumnAutoSizer.getMaxCellDataWidth(jTable, tableColumn);
            n2 = Math.max(n3, n4);
        }
        if (string.equals(AUTO_FIT_DEFAULT)) {
            n2 = Math.max(n2, 200);
        }
        return n2 + n;
    }

    private static int getHeaderWidth(JTable jTable, TableColumn tableColumn) {
        int n = jTable.convertColumnIndexToView(tableColumn.getModelIndex());
        Component component = null;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer != null) {
            component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n);
            return ColumnAutoSizer.getComponentWidth(component);
        }
        String string = (String)tableColumn.getHeaderValue();
        JLabel jLabel = new JLabel(string);
        return ColumnAutoSizer.getComponentWidth(jLabel);
    }

    private static int getMaxCellDataWidth(JTable jTable, TableColumn tableColumn) {
        int n = 0;
        int n2 = jTable.convertColumnIndexToView(tableColumn.getModelIndex());
        Component component = null;
        int n3 = 0;
        n3 = jTable.getModel() instanceof IRaptorGridModel ? ((IRaptorGridModel)jTable.getModel()).getLoadedRowCount() : jTable.getRowCount();
        for (int i = 0; i < n3; ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n2);
            component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n2), false, false, i, n2);
            n = Math.max(n, ColumnAutoSizer.getComponentWidth(component));
        }
        return n;
    }

    private static int getComponentWidth(Component component) {
        String string = null;
        FontMetrics fontMetrics = null;
        if (component instanceof ColumnHeaderCellRenderer) {
            return component.getPreferredSize().width;
        }
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            string = abstractButton.getText();
            fontMetrics = abstractButton.getFontMetrics(abstractButton.getFont());
            return SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            string = jTextComponent.getText();
            fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
            return SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            fontMetrics = jLabel.getFontMetrics(component.getFont());
            return SwingUtilities.computeStringWidth(fontMetrics, jLabel.getText());
        }
        return component.getPreferredSize().width;
    }

    private TableColumn getResizingColumn(JTableHeader jTableHeader, Point point) {
        return this.getResizingColumn(jTableHeader, point, jTableHeader.columnAtPoint(point));
    }

    private TableColumn getResizingColumn(JTableHeader jTableHeader, Point point, int n) {
        int n2;
        if (n == -1) {
            return null;
        }
        Rectangle rectangle = jTableHeader.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n3 = rectangle.x + rectangle.width / 2;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n2 = point.x < n3 ? n - 1 : n;
        } else {
            int n4 = n2 = point.x < n3 ? n : n - 1;
        }
        if (n2 == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n2);
    }

    private static void repaint(JTable jTable) {
    }
}

