/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import oracle.dbtools.raptor.backgroundTask.dialogs.TaskDialog;
import oracle.ide.Ide;

public class GlassPaneUIBlocker
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private boolean glassPanelUIBlockerShowBusy = true;
    private boolean mIsRunning;
    private boolean mIsFadingOut;
    private boolean mShowBusy;
    private Timer mTimer;
    private int mAngle;
    private int mFadeCount;
    private int mFadeLimit = 15;
    private static int ANIMATION_SIZE = 32;
    private static GlassPaneUIBlocker __ideUIBlocker = new GlassPaneUIBlocker();
    private static Component __ideGlassPane;
    private static int __ideBlockerCount;

    public GlassPaneUIBlocker() {
        this.addMouseListener(new MouseInputAdapter(){});
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setOpaque(false);
        this.setVisible(false);
        String string = System.getProperty("glassPanelUIBlockerShowBusy");
        if (string != null) {
            this.glassPanelUIBlockerShowBusy = Boolean.valueOf(string);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.start();
        } else {
            this.stop();
        }
        super.setVisible(bl);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.glassPanelUIBlockerShowBusy) {
            return;
        }
        if (!this.mShowBusy) {
            return;
        }
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setPaint(this.getParent().getBackground().darker());
        float f = (float)this.mFadeCount / (float)this.mFadeLimit;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f * f));
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setComposite(composite);
        int n5 = ANIMATION_SIZE / 5;
        int n6 = n3 / 2;
        int n7 = ANIMATION_SIZE / 2;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(n5 / 4, 1, 1));
        graphics2D.setPaint(this.getParent().getBackground().darker());
        graphics2D.rotate(Math.PI * (double)this.mAngle / 180.0, n6, n7);
        for (int i = 0; i < 12; ++i) {
            float f2 = (11.0f - (float)i) / 11.0f;
            graphics2D.drawLine(n6 + n5, n7, n6 + n5 * 2, n7);
            graphics2D.rotate(-0.5235987755982988, n6, n7);
            graphics2D.setComposite(AlphaComposite.getInstance(3, f2 * f));
        }
        graphics2D.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mIsRunning) {
            this.mShowBusy = true;
            this.repaint();
            this.mAngle += 3;
            if (this.mAngle >= 360) {
                this.mAngle = 0;
            }
            if (this.mIsFadingOut) {
                if (--this.mFadeCount <= 0) {
                    this.mIsRunning = false;
                    this.mTimer.stop();
                }
            } else if (this.mFadeCount < this.mFadeLimit) {
                ++this.mFadeCount;
            }
        }
    }

    public void start() {
        if (this.mIsRunning) {
            return;
        }
        this.mIsRunning = true;
        this.mIsFadingOut = false;
        this.mFadeCount = 0;
        int n = 24;
        int n2 = 1000 / n;
        this.mTimer = new Timer(n2, this);
        this.mShowBusy = false;
        this.mTimer.setInitialDelay(TaskDialog.DELAY_MS);
        this.mTimer.start();
    }

    public void stop() {
        this.mIsRunning = false;
        if (this.mTimer != null) {
            this.mTimer.stop();
        }
        this.mIsFadingOut = true;
        this.mFadeCount = 1;
    }

    public static GlassPaneUIBlocker getIdeUIBlocker() {
        return __ideUIBlocker;
    }

    public static synchronized void blockIde(boolean bl) {
        if (bl) {
            if (0 == __ideBlockerCount) {
                __ideGlassPane = Ide.getMainWindow().getGlassPane();
                Ide.getMainWindow().setGlassPane((Component)__ideUIBlocker);
                __ideUIBlocker.setVisible(true);
            }
            ++__ideBlockerCount;
        } else if (0 == --__ideBlockerCount) {
            __ideUIBlocker.setVisible(false);
            Ide.getMainWindow().setGlassPane(__ideGlassPane);
        }
    }

    static {
        __ideUIBlocker.setName("ideUIBlocker");
        String string = System.getProperty("ideUIBlockerShowBusy");
        if (string != null) {
            GlassPaneUIBlocker.__ideUIBlocker.glassPanelUIBlockerShowBusy = Boolean.valueOf(string);
        }
    }
}

