/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.java;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.java.JavaProgram;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.util.Service;

public class JdbcCallsStats
extends JavaProgram {
    Map<String, Integer> callStats = new TreeMap<String, Integer>();

    public static void main(String[] stringArray) throws Exception {
        Program.debug = false;
        JdbcCallsStats jdbcCallsStats = new JdbcCallsStats();
        jdbcCallsStats.debug = false;
        String string = "/EclipseWorkspace/common/common/";
        Files.walk(Paths.get(string, new String[0]), new FileVisitOption[0]).forEach(path -> {
            if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".java")) {
                System.out.println(path + "***********************************");
                try {
                    String string = Service.readFile((String)path.toString());
                    jdbcCallsStats.run(string, (Object)jdbcCallsStats);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : jdbcCallsStats.callStats.keySet()) {
            stringBuilder.append(string2 + "=" + jdbcCallsStats.callStats.get(string2) + "\n");
        }
        System.out.println(stringBuilder.toString());
    }

    public JdbcCallsStats() throws Exception {
        super(Service.readFile(JdbcCallsStats.class, (String)"jdbcCalls.arbori"));
    }

    void jdbc_classes(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println("**jdbc_classes(): **" + MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
    }

    void local_declarations(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println("**local_declarations(): **" + MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
    }

    void object_calls(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println("**object_calls(): **" + MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
    }

    void local_declarations_in_narrowest_scope(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println("**local_declarations_in_narrowest_scope(): **" + MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
    }

    void function_calls(Parsed parsed, Map<String, ParseNode> map) {
        if (this.debug) {
            System.out.println("**function_calls(): **" + MaterializedPredicate.tupleMnemonics(map, (List)parsed.getSrc()));
        }
        List list = parsed.getSrc();
        ParseNode parseNode = map.get("method");
        Object object = parsed.getInput().substring(((LexerToken)list.get((int)parseNode.from)).begin, ((LexerToken)list.get((int)parseNode.to)).begin).trim();
        ParseNode parseNode2 = map.get("prefix");
        String string = parsed.getInput().substring(((LexerToken)list.get((int)parseNode2.from)).begin, ((LexerToken)list.get((int)parseNode2.to)).begin).trim();
        object = string + "." + ((String)object).trim();
        Integer n = this.callStats.get(object);
        if (n == null) {
            n = 0;
        }
        n = n + 1;
        this.callStats.put((String)object, n);
    }
}

