/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.java;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.Grammar;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Service;

public class JavaEarley
extends Earley {
    private static JavaEarley instance = null;
    public static String[] keywords = new String[]{"'abstract'", "'assert'", "'boolean'", "'break'", "'byte'", "'case'", "'catch'", "'char'", "'class'", "'continue'", "'default'", "'do'", "'double'", "'else'", "'enum'", "'extends'", "'final'", "'finally'", "'float'", "'for'", "'if'", "'implements'", "'import'", "'instanceof'", "'int'", "'interface'", "'long'", "'native'", "'new'", "'package'", "'private'", "'protected'", "'public'", "'return'", "'short'", "'static'", "'strictfp'", "'super'", "'switch'", "'synchronized'", "'this'", "'throw'", "'throws'", "'transient'", "'try'", "'void'", "'volatile'", "'while'"};
    private Set<Integer> _keywords = new TreeSet<Integer>();

    public JavaEarley(Set<RuleTuple> set) {
        super(set);
        this.initKeywords();
    }

    public static JavaEarley getInstance() throws Exception {
        if (instance != null) {
            return instance;
        }
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        String string = Service.readFile(JavaEarley.class, (String)"java8.grammar");
        List list = LexerToken.parse((String)string, (boolean)false, (int)1);
        ParseNode parseNode = Grammar.parseGrammarFile((List)list, (String)string);
        Grammar.grammar((ParseNode)parseNode, (List)list, treeSet);
        RuleTransforms.eliminateEmptyProductions(treeSet);
        instance = new JavaEarley(treeSet);
        JavaEarley.instance.isCaseSensitive = true;
        return instance;
    }

    protected boolean isIdentifier(int n, List<LexerToken> list, int n2, Integer n3) {
        if (n2 != this.identifier) {
            return false;
        }
        if (n3 != null && this._keywords.contains(n3)) {
            return false;
        }
        LexerToken lexerToken = list.get(n);
        if (lexerToken.type != Token.IDENTIFIER) {
            return false;
        }
        if (n3 == null) {
            return true;
        }
        return true;
    }

    protected boolean isScannedSymbol(int n, List<LexerToken> list, int n2, Parser.Tuple tuple, Integer n3) {
        int n4 = tuple.content(n2);
        LexerToken lexerToken = list.get(n);
        if (n4 == this.digits && lexerToken.type == Token.DIGITS) {
            return true;
        }
        if (lexerToken.type == Token.QUOTED_STRING && n4 == (Integer)this.symbolIndexes.get("character_literal")) {
            return true;
        }
        if (n4 == this.string_literal && lexerToken.type == Token.DQUOTED_STRING) {
            return true;
        }
        return n3 != null && n3 == n4 || this.isIdentifier(n, list, n4, n3) && (n3 == null || this.notConfusedAsId(n3, tuple.head, n2));
    }

    void initKeywords() {
        for (String string : keywords) {
            this._keywords.add(this.getSymbol(string));
        }
    }

    public static boolean isKeyword(String string) {
        for (String string2 : keywords) {
            if (!string2.substring(1, string2.length() - 1).equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean recognizedJava(String string) {
        JavaEarley javaEarley;
        List list = LexerToken.parse((String)string, (String)"&");
        try {
            javaEarley = JavaEarley.getInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        Matrix matrix = new Matrix((Parser)javaEarley);
        javaEarley.parse(list, matrix);
        Parser.EarleyCell earleyCell = matrix.get(0, list.size());
        if (earleyCell == null) {
            return false;
        }
        ParseNode parseNode = javaEarley.forest(list, matrix);
        return parseNode != null && list.size() < parseNode.to + 5;
    }

    public static void main(String[] stringArray) throws Exception {
        Parser.EarleyCell earleyCell;
        String string = Service.readFile((String)"/EclipseWorkspace/raptor_trunk/utils/src/oracle/dbtools/java/javaparser.testinput");
        List<LexerToken> list = JavaEarley.lex(string);
        JavaEarley javaEarley = JavaEarley.getInstance();
        javaEarley.printOrderedRules("postfixExpre ssion", false, false);
        Matrix matrix = new Matrix((Parser)javaEarley);
        if (list.size() < 1100) {
            matrix.visual = new Visual(list, (Parser)javaEarley);
        }
        javaEarley.parse(list, matrix);
        if (matrix.visual != null) {
            matrix.visual.draw(matrix);
        }
        if ((earleyCell = matrix.get(0, list.size())) != null) {
            System.out.println(list.size() + " tokens, top = " + earleyCell.toString());
        } else {
            System.out.println("***** Syntactically Invalid fargment *****");
        }
        ParseNode parseNode = javaEarley.forest(list, matrix);
        if (list.size() < 1100) {
            parseNode.printTree();
        }
    }

    public static List<LexerToken> lex(String string) throws InterruptedException {
        List list = LexerToken.parse((String)string, (String)"&", (int)41);
        return list;
    }
}

