/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.List;
import java.util.TreeMap;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.util.Service;
import oracle.javatools.buffer.TextBuffer;

public class Replacements {
    private String input;
    private TreeMap<Long, String> substitutions = new TreeMap();

    public Replacements(String string) {
        this.input = string;
    }

    public void put(int n, int n2, String string) {
        for (long l : this.substitutions.keySet()) {
            if (n <= Service.lX((long)l) && Service.lX((long)l) < n2 || n < Service.lY((long)l) && Service.lY((long)l) <= n2) {
                throw new AssertionError((Object)("[" + n + "," + n2 + ") overlaps with [" + n + "," + n2 + ")"));
            }
        }
        this.substitutions.put(Service.lPair((int)n, (int)n2), string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            if (n < n2) {
                stringBuilder.append(this.input.substring(n, n2));
            }
            stringBuilder.append("\n---\n");
            stringBuilder.append(this.input.substring(n2, n3));
            stringBuilder.append("\n--->>>\n");
            stringBuilder.append(this.substitutions.get(l));
            stringBuilder.append("\n---\n");
            n = n3;
        }
        stringBuilder.append(this.input.substring(n));
        return stringBuilder.toString();
    }

    public String string4test() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            stringBuilder.append(n2);
            stringBuilder.append(',');
            stringBuilder.append(n3);
            stringBuilder.append(" `");
            stringBuilder.append(this.substitutions.get(l));
            stringBuilder.append("`\n");
            n = n3;
        }
        return stringBuilder.toString();
    }

    public String output() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            if (n < n2) {
                stringBuilder.append(this.input.substring(n, n2));
            }
            stringBuilder.append(this.substitutions.get(l));
            n = n3;
        }
        stringBuilder.append(this.input.substring(n));
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        String string;
        if (object instanceof String) {
            String string2 = this.output();
            String string3 = (String)object;
            if (string3.startsWith("`") && string3.endsWith("`")) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            return this.lexicalDiff(string2, string3) == null;
        }
        Replacements replacements = (Replacements)object;
        for (Long l : this.substitutions.keySet()) {
            string = replacements.substitutions.get(l);
            if (string == null) {
                return false;
            }
            if (this.lexicalDiff(string, this.substitutions.get(l)) == null) continue;
            return false;
        }
        for (Long l : replacements.substitutions.keySet()) {
            string = this.substitutions.get(l);
            if (string != null) continue;
            return false;
        }
        return true;
    }

    private String lexicalDiff(String string, String string2) {
        if (string.contains("/*?*/") && !string2.contains("/*?*/")) {
            return "no match for /*?*/";
        }
        if (string2.contains("/*?*/") && !string.contains("/*?*/")) {
            return "no match for /*?*/";
        }
        List list = LexerToken.parse((String)string);
        List list2 = LexerToken.parse((String)string2);
        for (int i = 0; i < Integer.min(list.size(), list.size()); ++i) {
            if (((LexerToken)list.get((int)i)).content.equals(((LexerToken)list2.get((int)i)).content)) continue;
            return "mismatch at offset " + ((LexerToken)list.get((int)i)).begin + ": " + ((LexerToken)list.get((int)i)).content + " vs. " + ((LexerToken)list2.get((int)i)).content;
        }
        if (list.size() != list.size()) {
            return "size mismatch (prefix match)";
        }
        return null;
    }

    public String diff(Object object) {
        String string;
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.startsWith("`") && string2.endsWith("`")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return this.lexicalDiff(this.output(), string2);
        }
        Replacements replacements = (Replacements)object;
        for (Long l : this.substitutions.keySet()) {
            string = replacements.substitutions.get(l);
            if (string == null) {
                return "no match for " + Service.lX((long)l) + "," + Service.lY((long)l) + " `" + this.substitutions.get(l) + "`";
            }
            String string3 = this.lexicalDiff(string, this.substitutions.get(l));
            if (string3 == null) continue;
            return Service.lX((long)l) + "," + Service.lY((long)l) + " `" + this.substitutions.get(l) + "` != `" + string + "`";
        }
        for (Long l : replacements.substitutions.keySet()) {
            string = this.substitutions.get(l);
            if (string != null) continue;
            return "no match for " + Service.lX((long)l) + "," + Service.lY((long)l) + " `" + replacements.substitutions.get(l) + "`";
        }
        return "=";
    }

    public String[] lines() {
        String[] stringArray = new String[this.substitutions.size()];
        int n = -1;
        for (long l : this.substitutions.keySet()) {
            stringArray[++n] = Service.lX((long)l) + "," + Service.lY((long)l) + " `" + this.substitutions.get(l) + "`";
        }
        return stringArray;
    }

    public UndoableEdit modify(TextBuffer textBuffer) {
        textBuffer.beginEdit();
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            String string = this.substitutions.get(l);
            textBuffer.remove(n2 + n, n3 - n2);
            textBuffer.insert(n2 + n, string.toCharArray());
            int n4 = string.length() - n3 + n2;
            n += n4;
        }
        return textBuffer.endEdit();
    }

    public String apply() {
        Object object = this.input;
        int n = 0;
        for (long l : this.substitutions.keySet()) {
            int n2 = Service.lX((long)l);
            int n3 = Service.lY((long)l);
            String string = this.substitutions.get(l);
            object = ((String)object).substring(0, n2 + n) + new String(string.toCharArray()) + ((String)object).substring(n3 + n);
            int n4 = string.length() - n3 + n2;
            n += n4;
        }
        return object;
    }

    public static void main(String[] stringArray) {
        Replacements replacements = new Replacements("0123456789012345");
        replacements.put(1, 2, "[1,2)");
        replacements.put(11, 12, "[11,12)");
        System.out.println(replacements.toString());
    }
}

