/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;

public class SVNURLInfoIO {
    private static final long SERIALVERSION_V1 = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] marshall(SVNURLInfo urlInfo) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        try {
            dataOut.writeLong(1L);
            dataOut.writeInt(urlInfo.getTextStatus().getID());
            dataOut.writeInt(urlInfo.getPropStatus().getID());
            dataOut.writeBoolean(urlInfo.getTreeStatus());
            dataOut.writeLong(urlInfo.getRevision());
            dataOut.writeLong(urlInfo.getLastChangedRevision());
            String author = urlInfo.getLastCommitAuthor();
            dataOut.writeUTF(author != null ? author : "");
            SVNUrl url = urlInfo.getURL();
            dataOut.writeUTF(url != null ? url.toString() : "");
            dataOut.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                dataOut.close();
            }
            catch (IOException ioe) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).severe(ioe.getMessage());
            }
            try {
                out.close();
            }
            catch (IOException ioe) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ioe.getMessage());
            }
        }
    }

    public SVNURLInfo unmarshall(byte[] bytes) throws IOException, SVNException {
        return null;
    }
}

