/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class ValidatedPanel
extends JPanel {
    Collection<PanelValidationListener> _listeners = new ArrayList<PanelValidationListener>();

    public ValidatedPanel() {
    }

    public ValidatedPanel(boolean b) {
        super(b);
    }

    public ValidatedPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public ValidatedPanel(LayoutManager layoutManager, boolean b) {
        super(layoutManager, b);
    }

    public abstract void initListeners();

    public abstract boolean validateContent();

    public void addListener(PanelValidationListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(PanelValidationListener listener) {
        this._listeners.remove(listener);
    }

    public void removeAllListeners() {
        this._listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireValidContent(boolean validationResult) {
        Collection<PanelValidationListener> collection = this._listeners;
        synchronized (collection) {
            for (PanelValidationListener listener : this._listeners) {
                listener.onReceiveValidationResult(validationResult);
            }
        }
    }

    public class FieldListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.validatePanelContent();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.validatePanelContent();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.validatePanelContent();
        }

        private void validatePanelContent() {
            boolean validContent = ValidatedPanel.this.validateContent();
            ValidatedPanel.this.fireValidContent(validContent);
        }
    }

    public static interface PanelValidationListener {
        public void onReceiveValidationResult(boolean var1);
    }
}

