/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;
import oracle.jdevimpl.vcs.svn.res.Resource;

public final class ExportFromWCPanel
extends JPanel {
    private final Collection _listeners = new LinkedList();
    private JLabel _wcPathLabel;
    private JLabel _wcPath;
    private JLabel _destLabel;
    private JLabel _revisionLabel;
    private JLabel _revisionId;
    private FileField _fileField;
    private JButton _browseButton;

    public ExportFromWCPanel(URL sourcePath) {
        super(new GridBagLayout());
        this.createComponents(sourcePath, null);
        this.layoutComponents();
        this.initListeners();
    }

    public ExportFromWCPanel(URL sourcePath, String revisionId) {
        super(new GridBagLayout());
        this.createComponents(sourcePath, revisionId);
        this.layoutComponents();
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExportPathListener(ExportPathListener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    public URL getExportPath() {
        String path = this._fileField.getText();
        return path != null && path.length() > 0 ? URLFactory.newDirURL((String)path) : null;
    }

    public Component getDefaultComp() {
        return this._fileField;
    }

    private void createComponents(URL sourcePath, String revisionId) {
        this._wcPath = new JLabel();
        this._wcPath.setText(URLFileSystem.getPlatformPathName((URL)sourcePath));
        this._wcPathLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._wcPathLabel, (Component)this._wcPath, (String)Resource.get("UI_EXP_WCPATH"));
        this._fileField = new FileField(true);
        this._fileField.setText("");
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._fileField, (String)Resource.get("UI_EXP_DEST"));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)Resource.get("UI_EXP_BROWSE"));
        if (revisionId != null) {
            this._revisionLabel = new JLabel();
            this._revisionId = new JLabel(revisionId);
            ResourceUtils.resLabel((JLabel)this._revisionLabel, (Component)this._revisionId, (String)Resource.get("EXPORT_COMMIT_REVISION"));
        }
    }

    private void layoutComponents() {
        int row = 0;
        this.add((Component)this._wcPathLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._wcPath, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 17, 2, new Insets(6, 5, 5, 0), 0, 0));
        if (this._revisionLabel != null) {
            this.add((Component)this._revisionLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 5, 5, 0), 0, 0));
            this.add((Component)this._revisionId, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 5, 5, 0), 0, 0));
        }
        this.add((Component)this._destLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 5, 0, 0), 0, 0));
        this.add((Component)this._fileField, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 17, 2, new Insets(6, 5, 5, 0), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(3, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 6, 5, 0), 0, 0));
    }

    private void initListeners() {
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e != null && e.getSource() == ExportFromWCPanel.this._browseButton) {
                    URL current = null;
                    String currentStr = ExportFromWCPanel.this._fileField.getText();
                    current = currentStr != null && currentStr.length() > 0 ? URLFactory.newDirURL((String)currentStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
                    URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                    chooser.setSelectionMode(0);
                    chooser.setSelectionScope(1);
                    if (chooser.showOpenDialog((Component)ExportFromWCPanel.this) == 0) {
                        ExportFromWCPanel.this._fileField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                    }
                }
            }
        });
        this._fileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.firePathSelected();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.firePathSelected();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.firePathSelected();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void firePathSelected() {
                String path = ExportFromWCPanel.this._fileField.getText();
                Collection collection = ExportFromWCPanel.this._listeners;
                synchronized (collection) {
                    Iterator it = ExportFromWCPanel.this._listeners.iterator();
                    while (it.hasNext()) {
                        ((ExportPathListener)it.next()).exportPathSelected(path);
                    }
                }
            }
        });
    }
}

