/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.op.ui.DepthOperationPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class BasicCheckoutPanel
extends ValidatedPanel
implements CheckoutInfo,
ActionListener {
    private final SVNRevision _revisionStart = SVNRevision.HEAD;
    private final SVNRevision _revisionEnd = new SVNRevision.Number(0L);
    private final Collection _listeners = new ArrayList(10);
    private final SVNRepositoryInfo _reposInfo;
    private final SVNUrl _sourceUrl;
    private final URL _defaultDestination;
    private JLabel _destLabel;
    private FileField _destField;
    private JButton _browseButton;
    private JButton _revisionButton;
    private JCheckBox _revisionCheckbox;
    private JTextField _revisionField;
    private DepthOperationPanel _depthPanel;
    private SVNUrl _reposUrl;

    public BasicCheckoutPanel(SVNRepositoryInfo reposInfo, SVNUrl sourceUrl, URL defaultDestination) {
        super(new GridBagLayout());
        this._reposInfo = reposInfo;
        this._sourceUrl = sourceUrl;
        this._defaultDestination = defaultDestination;
        this.createComponents(defaultDestination);
        this.layoutComponents();
        this.listen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBCPListener(Listener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBCPListener(Listener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.remove(listener);
        }
    }

    @Override
    public SVNRepositoryInfo getRepositoryInfo() {
        return this._reposInfo;
    }

    @Override
    public SVNUrl getSourceURL() {
        return this._sourceUrl;
    }

    @Override
    public URL getDestinationURL() {
        return URLFileSystem.canonicalize((URL)URLFactory.newDirURL((String)this._destField.getText()));
    }

    public void setDestinationURL(final URL dest) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BasicCheckoutPanel.this._destField.setText(URLFileSystem.getPlatformPathName((URL)dest));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    @Override
    public SVNRevision getRevision() {
        String revisionText;
        if (this._revisionCheckbox.isSelected() && (revisionText = this._revisionField.getText()) != null && revisionText.length() > 0) {
            try {
                return SVNRevision.getRevision((String)this._revisionField.getText());
            }
            catch (ParseException pe) {
                return SVNRevision.INVALID_REVISION;
            }
        }
        return SVNRevision.HEAD;
    }

    @Override
    public int getDepth() {
        return this._depthPanel.getDepthSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this._revisionCheckbox) {
            this._revisionField.setEnabled(this._revisionCheckbox.isSelected());
        } else if (source == this._browseButton) {
            this.chooseNewDirectory();
            this.fireNewURLChosen(this.getDestinationURL());
        }
    }

    private void chooseNewDirectory() {
        URL currentUrl = URLFactory.newURL((String)this._destField.getText());
        if (!URLFileSystem.exists((URL)currentUrl)) {
            currentUrl = this._defaultDestination;
        }
        URLChooser chooser = DialogUtil.newURLChooser((URL)currentUrl);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(1);
        if (chooser.showOpenDialog((Component)this) == 0) {
            this._destField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
        }
    }

    private void createComponents(URL defaultUrl) {
        this._destField = new FileField(true);
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._destField, (String)Resource.get("UI_BASIC_CHECKOUT_PANEL_LABEL_DESTINATION"));
        this._destField.setText(URLFileSystem.getPlatformPathName((URL)defaultUrl));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)Resource.get("UI_BASIC_CHECKOUT_PANEL_LABEL_BROWSE"));
        this._revisionCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._revisionCheckbox, (String)Resource.get("UI_BASIC_CHECKOUT_PANEL_LABEL_REVISION"));
        this._revisionField = new JTextField();
        this._revisionCheckbox.setSelected(false);
        this._revisionField.setEnabled(false);
        this._depthPanel = new DepthOperationPanel();
        this._revisionButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._revisionButton, (String)Resource.get("BUTTON_LIST_REV"));
    }

    private void layoutComponents() {
        this.add((Component)this._destLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 5), 0, 0));
        this.add((Component)this._destField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionCheckbox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._depthPanel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    private void setRevisionField(SVNRevision svnRevision) {
        this._revisionField.setText(svnRevision.toString());
    }

    private void listen() {
        this._revisionCheckbox.addActionListener(this);
        this._browseButton.addActionListener(this);
        this._revisionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SVNRevisionLister revLister = new SVNRevisionLister(BasicCheckoutPanel.this.getReposUrl(), BasicCheckoutPanel.this._revisionStart, BasicCheckoutPanel.this._revisionEnd);
                revLister.addObserver(new Observer(){

                    @Override
                    public void update(Observable o, Object arg) {
                        BasicCheckoutPanel.this.setRevisionField((SVNRevision)arg);
                        BasicCheckoutPanel.this._revisionCheckbox.setSelected(true);
                        BasicCheckoutPanel.this._revisionField.setEnabled(true);
                    }
                });
                revLister.showLister();
            }
        });
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNewURLChosen(URL newUrl) {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).newURLChosen(newUrl);
            }
        }
    }

    private SVNUrl getReposUrl() {
        if (this._sourceUrl != null) {
            return this._sourceUrl;
        }
        return this._reposUrl;
    }

    void setReposUrl(SVNUrl svnUrl) {
        this._reposUrl = svnUrl;
    }

    @Override
    public void initListeners() {
        this._destField.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        this._revisionField.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        this._revisionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicCheckoutPanel.this.fireValidContent(BasicCheckoutPanel.this.validateContent());
            }
        });
    }

    @Override
    public boolean validateContent() {
        boolean destfieldResult = !this._destField.getText().equals("") && URLFileSystem.isDirectoryPath((URL)this.getDestinationURL());
        boolean revisionfieldResult = true;
        if (this._revisionCheckbox.isSelected() && (this._revisionField.getText() == null || this._revisionField.getText().length() == 0 || this.getRevision().equals((Object)SVNRevision.INVALID_REVISION))) {
            revisionfieldResult = false;
        }
        return destfieldResult && revisionfieldResult;
    }

    public static interface Listener {
        public void newURLChosen(URL var1);
    }
}

