/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.svn.op.SVNOperationUpdate;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNOperationUpdateWC
extends SVNOperationUpdate {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.update-workingcopy";

    public SVNOperationUpdateWC() {
        super(COMMAND_ID);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        URL wc;
        URL url;
        Element[] elem = this.getContext().getSelection();
        if (elem != null && elem.length > 0 && elem[0] instanceof ChangeListItem && !URLFileSystem.exists((URL)(url = ((ChangeListItem)elem[0]).getURL())) && (wc = SVNUtil.resolveWorkingCopy(url)) != null) {
            return new Locatable[]{new Node(wc)};
        }
        if (elem != null && elem.length > 0 && elem[0] instanceof Locatable && (url = SVNUtil.resolveWorkingCopy(((Locatable)elem[0]).getURL())) != null) {
            Node node = new Node(url){

                public Icon getIcon() {
                    return OracleIcons.getIcon((String)"folder.png");
                }
            };
            return new Locatable[]{node};
        }
        return super.getOperands(profile);
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        this.collapseSelectionToWorkingCopy(commandState);
        Locatable[] workingCopies = commandState.getLocatables();
        if (workingCopies == null || workingCopies.length == 0 || workingCopies[0] == null) {
            throw new VCSException(Resource.get("ACTION_UPDATE_WC_ERROR_TITLE"), Resource.get("ACTION_UPDATE_WC_ERROR_NOWC_MSG"));
        }
        return super.invokeCommand(profile, commandState);
    }

    @Override
    protected String getOperation() {
        return Resource.get("OP_UPDATE_WC");
    }
}

