/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.IgnorePanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNOperationIgnore
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.ignore";
    private URL[] _selectedURLs;
    private JPanel _ui;

    public SVNOperationIgnore() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        URL[] selectedURLs = this.getSelectedURLs(profile);
        if (selectedURLs == null || selectedURLs.length == 0) {
            return false;
        }
        VCSStatusFilter ignoredFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.IGNORED");
        StatusCache statusCache = profile.getPolicyStatusCache();
        for (URL url : selectedURLs) {
            VCSStatus parentstatus = (VCSStatus)statusCache.get(URLFileSystem.getParent((URL)url));
            if (!ignoredFilter.accept(parentstatus)) continue;
            return false;
        }
        return this.inSameFolder(selectedURLs);
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        return this.invokeIgnore(profile);
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeIgnore(profile);
    }

    protected JEWTDialog createDialog() throws SVNClientException {
        String title = Resource.get("ACTION_IGNORE_DIALOG_TITLE");
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this.getPanel(), null, (String)title, (int)7);
        dialog.setInitialFocus(((IgnorePanel)((Object)this.getPanel())).getInitialFocusComponent());
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("ACTION_IGNORE_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        dialog.setDefaultButton(1);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getPanel(), "f1_svnignore_html");
        return dialog;
    }

    private JPanel getPanel() throws SVNClientException {
        if (this._ui == null) {
            File resourceFile = SVNUtil.toFile(URLFileSystem.getParent((URL)this._selectedURLs[0]));
            String exisitingIgnoredValue = this.getExistingIgnoredValue(resourceFile);
            this._ui = new IgnorePanel(this._selectedURLs, exisitingIgnoredValue);
        }
        return this._ui;
    }

    protected String getExistingIgnoredValue(File resourceFile) throws SVNClientException {
        String exisitingIgnoredValue = null;
        ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
        SVNOperationLogger.getInstance().beginOperation(svnClient, null);
        ISVNProperty existingProp = svnClient.propertyGet(resourceFile, "svn:ignore");
        List ignoredList = svnClient.getIgnoredPatterns(resourceFile);
        if (existingProp != null) {
            exisitingIgnoredValue = existingProp.getValue();
        }
        SVNOperationLogger.getInstance().successFinish(Resource.get("OP_IGNORE"));
        SVNOperationLogger.getInstance().successFinish(Resource.get("OP_IGNORE"));
        SVNOperationLogger.getInstance().endOperation();
        return exisitingIgnoredValue;
    }

    private boolean invokeIgnore(VCSProfile profile) throws Exception, SVNClientException {
        this._selectedURLs = this.getSelectedURLs(profile);
        if (this._selectedURLs.length > 0) {
            URL parent = URLFileSystem.getParent((URL)this._selectedURLs[0]);
            JEWTDialog dialog = this.createDialog();
            if (dialog.runDialog()) {
                this.addToIgnoreProperty();
                profile.getPolicyStatusCache().clear(new URL[]{parent});
                profile.getPolicyStatusCache().clear(new URL[]{parent}, Depth.IMMEDIATES);
                return true;
            }
        }
        return false;
    }

    private URL[] getSelectedURLs(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        return VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
    }

    private boolean inSameFolder(URL[] selectedURLs) {
        URL commonParent = URLFileSystem.getParent((URL)selectedURLs[0]);
        for (int i = 1; i < selectedURLs.length; ++i) {
            if (commonParent.equals(URLFileSystem.getParent((URL)selectedURLs[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIgnoreProperty() throws SVNClientException {
        URL parentURL = URLFileSystem.getParent((URL)this._selectedURLs[0]);
        String pattern = ((IgnorePanel)((Object)this.getPanel())).getPattern();
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(svnClient, null);
            svnClient.addToIgnoredPatterns(SVNUtil.toFile(parentURL), pattern);
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)e)));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }
}

