/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNCompareOperation;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNOperationComparePrevious
extends AbstractSVNCompareOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.compare-previous";

    public SVNOperationComparePrevious() {
        super(COMMAND_ID);
    }

    public SVNOperationComparePrevious(String commandId) {
        super(commandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getContextRevision(VCSProfile profile, Locatable locatable) throws Exception {
        long previousRevision = -1L;
        if (URLFileSystem.isDirectoryPath((URL)locatable.getURL()) || this.isDirty(locatable) || this.isLocallyModified(locatable, profile)) {
            previousRevision = SVNURLInfoCache.getInstance().getRevision(locatable.getURL());
        } else {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            try {
                previousRevision = SVNURLInfoCache.getInstance().getLastChangedRevision(locatable.getURL());
                SVNRepositoryInfo reposInfo = SVNUtil.getFirstAssociatedRepository(locatable.getURL());
                SVNOperationLogger.getInstance().beginOperation(client, reposInfo);
                SVNRevision.Number svnRev = new SVNRevision.Number(previousRevision);
                ISVNLogMessage[] log = client.getLogMessages(SVNUtil.toFile(locatable.getURL()), SVNRevision.START, (SVNRevision)svnRev);
                SVNRevision rvPrev = this.getPreviousFromLog(log, (SVNRevision)svnRev);
                if (rvPrev != null) {
                    SVNRevision sVNRevision = rvPrev;
                    return sVNRevision;
                }
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
        if (previousRevision > -1L) {
            return new SVNRevision.Number(previousRevision);
        }
        throw new IllegalStateException(Resource.format("ERROR_UNEXPECTED_REV", String.valueOf(previousRevision)));
    }

    protected HistoryEntrySelector getHistoryEntrySelector(VCSProfile profile, Locatable source, Object revision) throws Exception {
        return new HistoryEntrySelector(((SVNRevision.Number)revision).toString());
    }

    private boolean isDirty(Locatable resource) {
        return resource instanceof Dirtyable && ((Dirtyable)resource).isDirty();
    }

    private boolean isLocallyModified(Locatable resource, VCSProfile profile) throws Exception {
        return profile.getStatusInstance("MODIFIED") == profile.getPolicyStatusCache().get(resource.getURL());
    }

    private SVNRevision getPreviousFromLog(ISVNLogMessage[] log, SVNRevision svnRev) {
        for (int l = log.length - 1; l > 0; --l) {
            if (!log[l].getRevision().equals((Object)svnRev)) continue;
            return log[l - 1].getRevision();
        }
        return null;
    }
}

