/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.cmd;

import java.awt.Component;
import java.text.DateFormat;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.NavPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.ui.NavPropertyPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class NavPropertiesCommand
extends VCSCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.nav-properties";
    NavPropertyPanel _navPropertyPanel;
    SVNRemoteNode _node;
    private static final DateFormat sDateFormat = DateFormat.getDateTimeInstance(0, 0);

    public NavPropertiesCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    protected boolean isAvailableImpl() {
        return SVNUtil.getSVNRemoteNode(this.getContext()) != null;
    }

    protected int doitImpl() {
        this._node = SVNUtil.getSVNRemoteNode(this.getContext());
        this._navPropertyPanel = new NavPropertyPanel();
        JEWTDialog dialog = this.createDialog(this._navPropertyPanel);
        RepositoryNodePropertyWorker workerThread = new RepositoryNodePropertyWorker();
        workerThread.start();
        return WizardLauncher.runDialog((JDialog)dialog) ? 0 : 1;
    }

    protected JEWTDialog createDialog(JPanel panel) {
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)this.createPropertiesTitle());
        int buttonMask = 1;
        dialog.setButtonMask(buttonMask);
        dialog.setResizable(true);
        dialog.setMinimumSize(450, 400);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_svnnavproperties_html");
        return dialog;
    }

    private String createPropertiesTitle() {
        return Resource.get("URL_PROPS_UI_REPOS_TITLE") + this._node.getSVNUrl().getLastPathSegment();
    }

    private class RepositoryNodePropertyWorker
    extends Thread {
        private RepositoryNodePropertyWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNUrl svnUrl = NavPropertiesCommand.this._node.getSVNUrl();
                SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)NavPropertiesCommand.this._node.getParentRepository().getData();
                SVNOperationLogger.getInstance().beginOperation(client, reposInfo);
                final ISVNInfo info = client.getInfo(svnUrl);
                final ISVNProperty[] properties = client.getProperties(svnUrl);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NavPropertiesCommand.this._navPropertyPanel.setRepositoryURLField(info.getUrl().toString());
                        NavPropertiesCommand.this._navPropertyPanel.setLastChangedRevField(info.getLastChangedRevision().toString());
                        NavPropertiesCommand.this._navPropertyPanel.setLastChangedDateField(sDateFormat.format(info.getLastChangedDate()));
                        NavPropertiesCommand.this._navPropertyPanel.setLastCommitAuthorField(info.getLastCommitAuthor());
                        NavPropertiesCommand.this._navPropertyPanel.setLockOwnerField(info.getLockOwner());
                        NavPropertiesCommand.this._navPropertyPanel.setLockCreationDateField(info.getLockCreationDate() == null ? "" : sDateFormat.format(info.getLockCreationDate()));
                        NavPropertiesCommand.this._navPropertyPanel.setLockCommentField(info.getLockComment());
                        NavPropertiesTableModel model = NavPropertiesCommand.this._navPropertyPanel.getTableModel();
                        model.updateProperties(properties, Resource.get("ACTION_VIEWPROPERTIES_ALL_PROP"));
                    }
                });
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
                new VCSExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)e)));
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
    }
}

