/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import oracle.ide.Context;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.jdeveloper.vcs.nav.BaseConnectionProvider;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFile;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesFilterNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesObservable;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorManager;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public final class SVNRepositoryNavigatorProvider
extends BaseConnectionProvider {
    public Node getConnectionListNode() {
        SVNRepositoryNavigatorAPI.getInstance().activate();
        return SVNRepositoryNavigatorManager.getInstance().getRepositoriesNode();
    }

    public String getALMTeamSourceControlType() {
        return "Subversion";
    }

    public Map<String, String> getConnectionCriteria(URL url) {
        SVNRepositoryInfo repos;
        try {
            repos = SVNUtil.getFirstAssociatedRepository(url);
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(SVNRepositoryNavigatorProvider.class.getName()).severe(e.getMessage());
            return Collections.emptyMap();
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(SVNRepositoryNavigatorProvider.class.getName()).severe(e.getMessage());
            return Collections.emptyMap();
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("url", repos.getURL().toString());
        return criteria;
    }

    private final URI createURI(Map<String, String> criteria) {
        return this.createURI(criteria.get("url"));
    }

    private final URI createURI(String spec) {
        if (spec == null) {
            return null;
        }
        try {
            int i = spec.indexOf(58);
            return i >= 0 ? new URI(spec.substring(0, i), spec.substring(i + 1), null) : new URI(spec);
        }
        catch (URISyntaxException urise) {
            Assert.printStackTrace((Throwable)urise);
            return null;
        }
    }

    protected String getCriteriaDirectory(Map<String, String> criteria) {
        URI uri = this.createURI(criteria);
        return uri != null ? uri.getPath() : null;
    }

    protected String getCriteriaHost(Map<String, String> criteria) {
        URI uri = this.createURI(criteria);
        return uri != null ? uri.getHost() : null;
    }

    protected String getCriteriaFullPath(Map<String, String> criteria) {
        URI uri = this.createURI(criteria);
        return uri != null ? uri.getPath() : null;
    }

    protected String getCriteriaMethod(Map<String, String> criteria) {
        URI uri = this.createURI(criteria);
        return uri != null ? uri.getScheme() : null;
    }

    protected ConnectionNode createConnectionNodeSilently(Map<String, String> criteria) {
        URI uri = this.createURI(criteria);
        if (uri == null) {
            return null;
        }
        try {
            String name = criteria.get("name");
            if (name == null) {
                name = uri.toString();
            }
            if (this.getRepositoryNodeByName(name) != null) {
                int i = 2;
                while (true) {
                    String copyName;
                    if (this.getRepositoryNodeByName(copyName = name + " (" + i + ")") == null) {
                        name = copyName;
                        break;
                    }
                    ++i;
                }
            }
            SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(new SVNRepositoryInfo(new SVNUrl(uri.toString()), name, new SVNAuthInfo("", "".toCharArray())));
            return this.getRepositoryNodeByName(name);
        }
        catch (MalformedURLException murle) {
            Assert.printStackTrace((Throwable)murle);
            return null;
        }
        catch (AlreadyExistsException aee) {
            Assert.fail();
            return null;
        }
    }

    private final SVNRepositoryNode getRepositoryNodeByName(String name) {
        Iterator itr = SVNRepositoryNavigatorManager.getInstance().getRepositoriesNode().getChildren();
        while (itr.hasNext()) {
            SVNRepositoryNode node = (SVNRepositoryNode)itr.next();
            SVNRepositoryInfo info = (SVNRepositoryInfo)node.getData();
            if (!info.getAlias().equals(name)) continue;
            return node;
        }
        return null;
    }

    protected boolean createConnection(Map<String, String> criteria, Context context) {
        context.setProperty("PRESET_REPO_URL", (Object)criteria.get("url"));
        String name = criteria.get("name");
        if (name != null) {
            context.setProperty("PRESET_REPO_NAME", (Object)name);
        }
        Wizard connectionWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
        return connectionWizard.invoke(context);
    }

    protected ConnectionListFilterNode createConnectionListFilterNode() {
        return new SVNRepositoriesFilterNode();
    }

    protected Element createConnectionFilterNode(ConnectionNode connectionNode, ConnectionFilter filter) {
        SVNRepositoryNode connectionFilterNode = new SVNRepositoryNode((SVNRepositoryInfo)connectionNode.getData());
        connectionFilterNode.setFilter(filter);
        return connectionFilterNode;
    }

    public Observable getConnectionObservable() {
        return SVNRepositoriesObservable.getObservable();
    }

    public boolean canOpenVersionViewer(Map<String, String> criteria) {
        SVNRepositoryNode repositoryNode = (SVNRepositoryNode)this.findConnectionNode(criteria);
        return repositoryNode != null;
    }

    public void openVersionViewer(Map<String, String> criteria, String path, String revision) throws Exception {
        SVNRepositoryNode repositoryNode = (SVNRepositoryNode)this.findConnectionNode(criteria);
        SVNRepositoryInfo repositoryInfo = (SVNRepositoryInfo)repositoryNode.getData();
        try {
            SVNURL repositoryUrl = SVNURL.parseURIDecoded((String)repositoryNode.getSVNUrl().toString());
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)repositoryUrl);
            SVNAuthInfo authInfo = repositoryInfo.getAuthInfo();
            String s = new String(authInfo.getPassword());
            repository.setAuthenticationManager(SVNWCUtil.createDefaultAuthenticationManager((String)(authInfo != null ? authInfo.getUserName() : ""), (String)(authInfo != null ? s : "")));
            s = null;
            SVNURL repositoryRootUrl = repository.getRepositoryRoot(true);
            SVNUrl absoluteUrl = new SVNUrl(repositoryRootUrl.toDecodedString()).appendPath(path);
            SVNRemoteFile node = new SVNRemoteFile(null, repositoryNode, absoluteUrl, (SVNRevision)new SVNRevision.Number(Long.parseLong(revision)));
            EditorManager.getEditorManager().openDefaultEditorInFrame(new Context((Node)node));
            Exception oe = node.getOpenException();
            if (node.getOpenException() == null) {
                return;
            }
            Throwable oeCause = oe.getCause();
            if (oe instanceof IOException && oeCause instanceof SVNClientException && oeCause.getMessage() != null && oeCause.getMessage().toLowerCase().indexOf("not found") >= 0) {
                throw new VCSException(Resource.get("CANNOT_OPEN_REVISION_TITLE"), MessageFormat.format(Resource.get("COR_PATH_NOT_FOUND"), absoluteUrl.toString(), revision));
            }
            throw new VCSException(Resource.get("CANNOT_OPEN_REVISION_TITLE"), Resource.get("COR_ERROR_ON_OPEN"));
        }
        catch (SVNException svne) {
            throw new VCSDetailException(Resource.get("CANNOT_OPEN_REVISION_TITLE"), Resource.get("COR_SUBVERSION_ERROR"), (Exception)((Object)svne));
        }
        catch (NumberFormatException nfe) {
            throw new VCSException(Resource.get("CANNOT_OPEN_REVISION_TITLE"), MessageFormat.format(Resource.get("COR_INVALID_REVISION"), revision));
        }
    }

    public final void runConnect(Context context) {
        SVNUtil.ensureRepositoryConnection(context);
    }
}

