/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideimpl.vcscore.nav.VersioningNavigatorManager;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNAuthenticationManager;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNNavigatorController;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesObservable;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorManager;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNRepositoryNavigatorAPI {
    public static Object CLIENT_CONTEXT = new Object();
    private static final SVNRepositoryNavigatorAPI sInstance = new SVNRepositoryNavigatorAPI();
    private SVNNavigatorController _controller;
    private SVNRepositoriesNode _repositoriesNode;

    public static final SVNRepositoryNavigatorAPI getInstance() {
        return sInstance;
    }

    public void activate() {
        SVNRepositoryNavigatorManager navMgr = SVNRepositoryNavigatorManager.getInstance();
        this._repositoriesNode = navMgr.getRepositoriesNode();
        Ide.getSettings().getKeyStrokeOptions().solvePostponedMaps();
        this._controller = new SVNNavigatorController();
        IdeAction[] actions = this.getIdeActions();
        for (int i = 0; i < actions.length; ++i) {
            actions[i].addController((Controller)this._controller);
        }
    }

    public void showRepositoryNavigator() {
        Runnable runme = new Runnable(){

            @Override
            public void run() {
                IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
                try {
                    if (showNavigatorAction != null) {
                        showNavigatorAction.performAction();
                    }
                }
                catch (Exception e) {
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runme.run();
        } else {
            SwingUtilities.invokeLater(runme);
        }
    }

    public void createRepositoryConnection(SVNRepositoryInfo reposInfo) throws AlreadyExistsException {
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        reposMgr.add(reposInfo);
        reposMgr.save();
        SVNRepositoryNode reposNode = new SVNRepositoryNode(reposInfo);
        this._repositoriesNode.add((Element)reposNode, true);
        if (this._repositoriesNode.isDirty()) {
            this._repositoriesNode.markDirty(false);
        }
        SVNRepositoriesObservable.getObservable().notifyObservers();
    }

    public SVNRepositoryNode getRepositoryNode(SVNUrl url) {
        Iterator it = this._repositoriesNode.getChildren();
        while (it.hasNext()) {
            SVNRepositoryNode reposNode = (SVNRepositoryNode)it.next();
            SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)reposNode.getData();
            if (!reposInfo.getURL().equals((Object)url)) continue;
            return reposNode;
        }
        return null;
    }

    public void showURLInNavigator(SVNUrl url, Context context) throws IOException {
        SVNRepositoryNode reposNode = this.getReposNodeForUrl(url);
        final ArrayList<SVNRemoteContainer> toOpen = new ArrayList<SVNRemoteContainer>();
        if (reposNode != null) {
            SVNRemoteContainer chNode = this.getChildNodeForUrl(reposNode, url);
            while (chNode != null) {
                toOpen.add(chNode);
                if (url.getParent().equals((Object)chNode.getSVNUrl())) break;
                chNode = this.getChildNodeForUrl(chNode, url);
            }
        }
        if (!toOpen.isEmpty() && context.getView() instanceof NavigatorWindow) {
            ((SVNRemoteContainer)toOpen.get(toOpen.size() - 1)).close();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorWindow vnav = VersioningNavigatorManager.getInstance().getNavigatorWindow();
                    TreeExplorer explorer = vnav.getTreeExplorer();
                    if (explorer != null) {
                        TNode rootTNode = explorer.getRoot();
                        for (int n = 0; n < toOpen.size(); ++n) {
                            TNode explorerNode = explorer.searchTNode((Element)toOpen.get(n), rootTNode);
                            explorer.expand(explorerNode, false, false);
                        }
                    }
                }
            });
        }
    }

    public void removeRepositoryConnection(SVNRepositoryNode reposNode) {
        SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)reposNode.getData();
        SVNAuthenticationManager.getInstance().remove(reposInfo);
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        reposMgr.remove(reposInfo.getAlias());
        reposMgr.save();
        this._repositoriesNode.remove((Element)reposNode, true);
        if (this._repositoriesNode.isDirty()) {
            this._repositoriesNode.markDirty(false);
        }
        SVNRepositoriesObservable.getObservable().notifyObservers();
    }

    public void saveRepositoryConnections() {
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        reposMgr.save();
        SVNRepositoriesObservable.getObservable().notifyObservers();
    }

    public boolean canRefresh(Node targetNode) {
        if (targetNode != null) {
            return targetNode.isOpen();
        }
        return false;
    }

    public boolean canRemove(Node targetNode) {
        if (targetNode != null) {
            return targetNode instanceof SVNRepositoryNode || targetNode instanceof SVNRemoteFolder || targetNode instanceof SVNRemoteFile;
        }
        return false;
    }

    private IdeAction[] getIdeActions() {
        int[] actionIds = new int[]{20, 51, 56, Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection"), Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory")};
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>(10);
        for (int i = 0; i < actionIds.length; ++i) {
            IdeAction action = IdeAction.find((int)actionIds[i]);
            if (action == null) continue;
            actions.add(action);
        }
        return actions.toArray(new IdeAction[actions.size()]);
    }

    private SVNRepositoryNavigatorAPI() {
    }

    private SVNRepositoryNode getReposNodeForUrl(SVNUrl url) {
        Iterator it = this._repositoriesNode.getChildren();
        while (it.hasNext()) {
            SVNRepositoryNode node = (SVNRepositoryNode)it.next();
            SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)node.getData();
            if (!url.toString().startsWith(reposInfo.getURL().toString())) continue;
            return node;
        }
        return null;
    }

    private SVNRemoteContainer getChildNodeForUrl(SVNRemoteContainer reposNode, SVNUrl url) {
        Iterator it = reposNode.getChildren();
        while (it.hasNext()) {
            SVNRemoteNode node = (SVNRemoteNode)it.next();
            if (!node.getNodeKind().equals((Object)SVNNodeKind.DIR) || !url.toString().startsWith(node.getSVNUrl().toString())) continue;
            return (SVNRemoteContainer)node;
        }
        return null;
    }
}

