/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.vcs.svn.nav.SVNNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.util.browser.DefaultBrowsable;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNRemoteFile
extends DefaultBrowsable
implements SVNRemoteNode {
    private final SVNRepositoryNode _parentRepos;
    private SVNRemoteContainer _parent;
    private final SVNUrl _svnUrl;
    private SVNRevision _revision;
    private String _shortLabel = null;

    public SVNRemoteFile(SVNRemoteContainer parent, SVNRepositoryNode parentRepos, SVNUrl svnUrl, SVNRevision revision) {
        this._parentRepos = parentRepos;
        this._svnUrl = svnUrl;
        this.setURL(SVNNavURLFileSystemHelper.toNavigatorUrl(svnUrl, revision));
        this._revision = revision;
        this._parent = parent;
    }

    @Override
    public SVNRemoteContainer getParent() {
        return this._parent;
    }

    @Override
    public SVNRepositoryNode getParentRepository() {
        return this._parentRepos;
    }

    @Override
    public SVNUrl getSVNUrl() {
        return this._svnUrl;
    }

    @Override
    public SVNNodeKind getNodeKind() {
        return SVNNodeKind.FILE;
    }

    public String getToolTipText() {
        return this._svnUrl.toString();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        if (this._shortLabel == null) {
            String[] paths = this._svnUrl.getPathSegments();
            if (paths.length > 0) {
                StringBuffer labelBuffer = new StringBuffer(paths[paths.length - 1]);
                labelBuffer.append(' ');
                labelBuffer.append('[');
                labelBuffer.append(this.getRevision());
                labelBuffer.append(']');
                this._shortLabel = labelBuffer.toString();
            } else {
                this._shortLabel = "";
            }
        }
        return this._shortLabel;
    }

    private String getRevision() {
        return this._revision.toString();
    }

    public Object getData() {
        return this.getSVNUrl();
    }

    public void writeFileContents(OutputStream outputStream) throws IOException {
        final WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                wc.show(1000);
            }
        });
        try {
            VCSStreamUtils.pipeStreamData((InputStream)URLFileSystem.openInputStream((URL)this.getURL()), (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(wc){
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$wc = waitCursor;
                }

                @Override
                public void run() {
                    this.val$wc.hide();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }
}

