/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.EventQueue;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorWindow;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdeveloper.vcs.nav.ConnectionNodeDecorator;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.cmd.DeleteConnectionCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.DeleteRemoteResourceCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.EditConnectionCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.NewConnectionCommand;
import oracle.jdevimpl.vcs.svn.op.SVNOperationNewRemoteDir;
import oracle.jdevimpl.vcs.svn.op.SVNOperationVersionTree;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNNavigatorController
implements Controller {
    public boolean handleEvent(IdeAction action, Context ctx) {
        if (ctx == null) {
            return false;
        }
        Element[] selection = ctx.getSelection();
        if (SVNUtil.isRepositoryNavigatorView(ctx.getView()) && selection.length > 0) {
            ConnectionNode connectionNode;
            if (action.getCommandId() == 51) {
                SVNRemoteNode[] remoteNodes;
                for (SVNRemoteNode elem : remoteNodes = SVNUtil.getSVNRemoteNodes(ctx)) {
                    Context newctx = new Context(ctx);
                    newctx.setNode((Node)elem);
                    RevertNodeCommand.reload((Context)newctx, (boolean)false);
                    this.refreshNavigator(newctx);
                }
                return remoteNodes.length > 0;
            }
            if (selection.length == 1 && selection[0] instanceof ConnectionNodeDecorator && (connectionNode = ((ConnectionNodeDecorator)ctx.getElement()).getConnectionNode()) != null) {
                ctx = new Context(ctx);
                ctx.setNode((Node)connectionNode);
                ctx.setSelection(new Element[]{(Element)connectionNode});
            }
            selection = ctx.getSelection();
            if (action.getCommandId() == 20) {
                if (selection[0] instanceof SVNRepositoryNode) {
                    this.invokeCommand(ctx, new DeleteConnectionCommand());
                    return true;
                }
                if (selection[0] instanceof SVNRemoteNode) {
                    this.invokeCommand(ctx, new DeleteRemoteResourceCommand());
                    return true;
                }
            }
            if (action.getCommandId() == 56 && selection.length == 1 && selection[0] instanceof SVNRepositoryNode) {
                this.invokeCommand(ctx, new EditConnectionCommand());
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection").intValue() && selection.length == 1 && selection[0] instanceof SVNRepositoryNode) {
                this.invokeCommand(ctx, new NewConnectionCommand());
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory").intValue() && selection.length == 1 && selection[0] instanceof SVNRepositoryNode) {
                this.invokeCommand(ctx, (Command)new SVNOperationNewRemoteDir());
                return true;
            }
            if (action.getCommandId() == Ide.findOrCreateCmdID((String)SVNOperationVersionTree.COMMAND_ID) && selection.length == 1 && (selection[0] instanceof SVNRemoteFolder || selection[0] instanceof SVNRemoteFile)) {
                this.invokeCommand(ctx, (Command)new SVNOperationVersionTree());
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context ctx) {
        if (ctx == null) {
            return false;
        }
        SVNRepositoryNavigatorAPI navApi = SVNRepositoryNavigatorAPI.getInstance();
        Element[] selection = ctx.getSelection();
        if (SVNUtil.isRepositoryNavigatorView(ctx.getView())) {
            ConnectionNode connectionNode;
            if (action.getCommandId() == 51) {
                SVNRemoteNode[] remoteNodes = SVNUtil.getSVNRemoteNodes(ctx);
                if (remoteNodes.length > 0) {
                    action.setEnabled(true);
                    return true;
                }
                return false;
            }
            if (action.getCommandId() == 20) {
                for (Element elem : selection) {
                    if (elem == null) continue;
                    if (elem instanceof Node) {
                        if (navApi.canRemove((Node)elem)) {
                            action.setEnabled(true);
                            return true;
                        }
                        if (elem instanceof SVNRepositoriesNode) {
                            action.setEnabled(false);
                            return true;
                        }
                    }
                    if (!(elem instanceof ConnectionNodeDecorator)) continue;
                    action.setEnabled(false);
                    return true;
                }
            }
            if (selection.length == 1 && selection[0] instanceof ConnectionNodeDecorator && (connectionNode = ((ConnectionNodeDecorator)ctx.getElement()).getConnectionNode()) != null) {
                ctx = new Context(ctx);
                ctx.setNode((Node)connectionNode);
                ctx.setSelection(new Element[]{(Element)connectionNode});
            }
            selection = ctx.getSelection();
            if (action.getCommandId() == 56 && selection.length == 1 && selection[0] instanceof SVNRepositoryNode) {
                action.setEnabled(true);
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection").intValue()) {
                if (selection.length == 1 && selection[0] instanceof SVNRepositoriesNode) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (action.getCommandId() == Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory").intValue()) {
                if (selection.length == 1 && selection[0] instanceof SVNRemoteContainer) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (action.getCommandId() == Ide.findOrCreateCmdID((String)SVNOperationVersionTree.COMMAND_ID)) {
                if (selection.length == 1 && (selection[0] instanceof SVNRemoteFolder || selection[0] instanceof SVNRemoteFile)) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    private void invokeCommand(Context ctx, Command command) {
        try {
            command.setContext(ctx);
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
        }
    }

    private void refreshNavigator(final Context newctx) {
        if (newctx.getView() instanceof NavigatorWindow) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeExplorer explorer = ((NavigatorWindow)newctx.getView()).getTreeExplorer();
                    TNode nodeT = explorer.searchTNode((Element)newctx.getNode(), explorer.getRoot());
                    explorer.expand(nodeT, false, true);
                }
            });
        }
    }
}

