/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.migration;

import java.io.File;
import java.io.IOException;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.util.FileCopyUtil;
import oracle.jdevimpl.vcs.svn.repos.SVNConnectionFileConstansts;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class SVNConnectionsMigrator
extends XMLMigrator
implements SVNConnectionFileConstansts {
    private static final int SVN_CONNECTIONS = 0;

    public SVNConnectionsMigrator() {
        super(new int[]{0});
    }

    protected String getFileName() {
        return "repositories.xml";
    }

    protected String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "svn-repositories";
    }

    public String getDescription(int category) {
        return Resource.get("SVN_CONNECTIONS_DESCRIPTION");
    }

    public String[] migrate(File sourceDir, File destDir) {
        File srcFile = this.getSourceFile(sourceDir, destDir);
        File dstFile = this.getDestFile(sourceDir, destDir);
        try {
            FileCopyUtil.copyFile((File)srcFile, (File)dstFile);
        }
        catch (IOException e) {
            String[] error = new String[]{e.getMessage()};
            return error;
        }
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        File file;
        return this.isValidCategory(category) && sourceDir != null && sourceDir.exists() && (file = this.getSourceFile(sourceDir, null)) != null && file.exists() && file.canRead();
    }

    protected File getSourceFile(File sourceDir, File destDir) {
        return super.getSourceFile(this.getActualSourceDir(sourceDir), destDir);
    }

    protected File getDestFile(File sourceDir, File destDir) {
        return super.getDestFile(sourceDir, destDir);
    }

    private final File getActualSourceDir(File sourceDir) {
        File extensionSettingsDir = new File(sourceDir, "o.jdeveloper.subversion");
        return extensionSettingsDir.exists() ? extensionSettingsDir : sourceDir;
    }
}

