/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class MergeOperation
extends Thread {
    private int _mergeType = 0;
    private SVNMergeWizardModel _model;
    private boolean _dryrun;

    public MergeOperation(SVNMergeWizardModel model, boolean dryrun) {
        this._model = model;
        this._dryrun = dryrun;
    }

    @Override
    public void run() {
        this._mergeType = this._model.getMergeType();
        switch (this._mergeType) {
            case 0: {
                this.doRangeMerge();
                break;
            }
            case 2: {
                this.doTreeMerge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRangeMerge() {
        SVNDiffClient client = null;
        try {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNURL());
            client = SVNUtil.getDiffClient(repoInfo);
            SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, repoInfo);
            ArrayList<SVNRevisionRange> range = new ArrayList<SVNRevisionRange>();
            for (SVNRevisionRange fromRange : this._model.getFromRevisionRanges()) {
                range.add(fromRange);
            }
            client.doMerge(this._model.getFromSVNURL(), SVNRevision.HEAD, range, this._model.getLocalPath(), SVNUtil.depth(this._model.getDepth()), !this._model.isIgnoreAncestry(), this._model.isForce(), this._dryrun, this._model.isRecordOnly());
        }
        catch (SVNException e) {
            new SVNExceptionHandler().handleException((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)e)));
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            this.updateCache(SVNOperationLogger.getInstance().getChangeSet());
            SVNOperationLogger.getInstance().successFinish(this.getOperation());
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private void doTreeMerge() {
        SVNDiffClient client = null;
        try {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNURL());
            client = SVNUtil.getDiffClient(repoInfo);
            SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, repoInfo);
            client.doMerge(this._model.getFromSVNURL(), this._model.getFromRevision(), this._model.getToSVNUrl(), this._model.getToRevision(), this._model.getLocalPath(), SVNUtil.depth(this._model.getDepth()), !this._model.isIgnoreAncestry(), this._model.isForce(), this._dryrun, this._model.isRecordOnly());
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
            new SVNExceptionHandler().handleException((Exception)SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)e)));
        }
        finally {
            this.updateCache(SVNOperationLogger.getInstance().getChangeSet());
            SVNOperationLogger.getInstance().successFinish(this.getOperation());
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private void updateCache(Collection<File> changeSet) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        URL[] processed = SVNUtil.toURLs(changeSet.toArray(new File[changeSet.size()]));
        StatusCache statusCache = profile.getPolicyStatusCache();
        if (statusCache != null) {
            statusCache.clear(processed);
        }
        SVNURLInfoCache svnurlInfoCache = SVNURLInfoCache.getInstance();
        svnurlInfoCache.clear(processed);
        VCSBufferUtils.reloadBuffer((URL[])processed);
    }

    private String getOperation() {
        return Resource.get("OP_MERGE");
    }
}

