/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.commithistory;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSDetailException;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdevimpl.vcs.svn.SVNExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.SVNOperationExport;
import oracle.jdevimpl.vcs.svn.op.ui.ExportFromWCPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ExportPathListener;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SVNCommitVersionExport
extends SVNOperationExport {
    public static String COMMAND_ID = "oracle.jdeveloper.vcs.svn.commitexport";

    public SVNCommitVersionExport() {
        super(COMMAND_ID);
    }

    @Override
    protected int doitImpl() throws Exception {
        Context context = this.getContext();
        URL rootUrl = (URL)context.getProperty("commit-svn-root");
        URL directory = (URL)context.getProperty("commit-svn-dir");
        String revisionId = (String)context.getProperty("commit-version-id");
        return this.exportRevision(rootUrl, directory, revisionId);
    }

    private int exportRevision(URL rootUrl, URL directory, String revisionId) {
        URL srcUrl = directory == null ? rootUrl : directory;
        final ExportFromWCPanel panel = new ExportFromWCPanel(srcUrl, revisionId);
        final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComp(), (String)Resource.get("EXPORT_COMMIT_TITLE"));
        dialog.setOKButtonEnabled(false);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(Resource.get("EXPORT_COMMIT_DIALOG_HEADER_DESC_URL"));
        dialog.setDialogHeader((Component)header);
        panel.addExportPathListener(new ExportPathListener(){

            @Override
            public void exportPathSelected(String newPath) {
                dialog.setOKButtonEnabled(newPath != null && newPath.length() > 0);
            }
        });
        dialog.addVetoableChangeListener((VetoableChangeListener)new SVNOperationExport.ExportPathValidator(){

            @Override
            protected URL getExportPath() {
                return panel.getExportPath();
            }

            @Override
            protected JEWTDialog getParentDialog() {
                return dialog;
            }
        });
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            this.executeExportCommit(srcUrl, revisionId, panel.getExportPath());
            return 0;
        }
        return 1;
    }

    private void executeExportCommit(final URL srcUrl, final String revisionId, final URL url) {
        RequestProcessor processor = new RequestProcessor("Subversion Export", 1);
        processor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SVNUpdateClient client = null;
                ProgressHandle handle = ProgressHandle.createHandle((String)Resource.get("EXPORT_COMMIT_PROGRESS"));
                handle.start();
                try {
                    SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(srcUrl);
                    client = SVNUtil.getUpdateClient(repos);
                    SVNOperationLogger.getInstance().beginOperation((SVNBasicClient)client, repos);
                    SVNRevision rev = SVNRevision.create((long)Long.parseLong(revisionId));
                    client.doExport(new File(srcUrl.getPath()), new File(url.getPath()), rev, rev, null, true, SVNDepth.INFINITY);
                }
                catch (Exception e) {
                    VCSDetailException de = new VCSDetailException(Resource.get("EXPORT_COMMIT_ERROR_TITLE"), Resource.format("EXPORT_COMMIT_ERROR", URLFileSystem.getPlatformPathName((URL)srcUrl), revisionId), (Exception)SVNExceptionWrapper.wrapSVNClientException(e));
                    new SVNExceptionHandler().handleException((Exception)de);
                    e.printStackTrace();
                }
                finally {
                    if (client != null) {
                        SVNOperationLogger.getInstance().endOperation();
                    }
                    handle.finish();
                }
            }
        });
    }
}

