/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.client.AbstractSVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNRAInfo;

public final class SVNCLIClient
extends AbstractSVNClient {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNCLIClient.class.getName());
    private String _svnVersion;
    private SVNRAInfo _raInfo;

    @Override
    public String getSVNVersion() {
        if (this._svnVersion == null) {
            this.queryVersionAndRAInfo();
        }
        return this._svnVersion;
    }

    @Override
    public SVNRAInfo getRAInfo() {
        if (this._raInfo == null) {
            this.queryVersionAndRAInfo();
        }
        return this._raInfo;
    }

    @Override
    protected String getAdapterType() {
        return "commandline";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryVersionAndRAInfo() {
        Process p = null;
        BufferedReader r = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"svn", "--version"});
            r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            HashMap raMods = new HashMap(10);
            FastStringBuffer buff = new FastStringBuffer(20);
            String line = null;
            while ((line = r.readLine()) != null) {
                int i;
                if (line.indexOf("svn, version") >= 0) {
                    line = line.substring(line.indexOf("version") + 7).trim();
                    buff.setLength(0);
                    for (i = 0; i < line.length() && !Character.isWhitespace(line.charAt(i)); ++i) {
                        buff.append(line.charAt(i));
                    }
                    this._svnVersion = buff.toString();
                }
                if (line.indexOf("handles") < 0) continue;
                line = line.substring(line.indexOf("handles") + 7).trim();
                buff.setLength(0);
                for (i = 0; i < line.length() && !Character.isWhitespace(line.charAt(i)); ++i) {
                    if (line.charAt(i) == '\'') continue;
                    buff.append(line.charAt(i));
                }
                raMods.put(buff.toString().toLowerCase(), null);
            }
            this._raInfo = new SVNRAInfo(raMods.containsKey("http"), raMods.containsKey("https"), raMods.containsKey("file"), raMods.containsKey("svn"), raMods.containsKey("svn"));
            this.closeQuietly(r);
            this.closeQuietly(p);
        }
        catch (IOException ioe) {
            try {
                sLogger.log(Level.WARNING, "unable to query cli for version and ra info", ioe);
                this._svnVersion = null;
                this._raInfo = new SVNRAInfo(true, true, true, true, true);
                this.closeQuietly(r);
                this.closeQuietly(p);
            }
            catch (Throwable throwable) {
                this.closeQuietly(r);
                this.closeQuietly(p);
                throw throwable;
            }
        }
    }

    private void closeQuietly(BufferedReader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException ioe) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).severe(ioe.getMessage());
            }
        }
    }

    private void closeQuietly(Process p) {
        if (p != null) {
            p.destroy();
        }
    }
}

