/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.adapter.svnkit;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.adapter.OISVNClientAdapter;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.PropertyData;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.RevisionRange;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapter;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class OSvnKitClientAdapter
extends SvnKitClientAdapter
implements OISVNClientAdapter {
    static Logger log = SVNProfile.getQualifiedLogger("SVNKit");
    private SoftReference<Map<Pair<String, SVNRevision>, ISVNProperty[]>> _reference;

    public OSvnKitClientAdapter() {
        SVNDebugLog.setDefaultLog((ISVNDebugLog)new ISVNDebugLogImpl());
    }

    @Override
    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision) throws SVNClientException {
        String target = url.toString();
        ISVNProperty[] props = this.getPropFromReference(target, revision);
        if (props == null) {
            props = this.getProperties(target, revision);
            this.setPropReference(revision, target, props);
        }
        return props;
    }

    @Override
    public ISVNProperty[] getProperties(File file, SVNRevision revision) throws SVNClientException {
        String target = file.toString();
        ISVNProperty[] props = this.getPropFromReference(target, revision);
        if (props == null) {
            props = this.getProperties(target, revision);
            this.setPropReference(revision, target, props);
        }
        return props;
    }

    public ISVNProperty[] getProperties(String target, SVNRevision revision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir();
            PropertyData[] propertiesData = this.svnClient.properties(target, JhlConverter.convert((SVNRevision)revision));
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            JhlPropertyData[] svnProperties = new JhlPropertyData[propertiesData.length];
            for (int i = 0; i < propertiesData.length; ++i) {
                svnProperties[i] = JhlPropertyData.newForUrl((PropertyData)propertiesData[i]);
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException((Throwable)e);
        }
    }

    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = OSvnKitClientAdapter.fileToSVNPath((File)localPath, (boolean)false);
            String commandLine = "merge";
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            commandLine = commandLine + this.depthCommandLine(depth);
            if (force) {
                commandLine = commandLine + " --force";
            }
            if (ignoreAncestry) {
                commandLine = commandLine + " --ignore-ancestry";
            }
            RevisionRange[] range = JhlConverter.convert((SVNRevisionRange[])revisions);
            for (int i = 0; i < revisions.length; ++i) {
                commandLine = commandLine + " " + this.toMergeString(revisions[i]);
            }
            commandLine = commandLine + " " + url.toString();
            commandLine = commandLine + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert((SVNRevision)pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.merge(url.toString(), peg, range, target, force, depth, ignoreAncestry, dryRun, recordOnly);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    private String depthCommandLine(int depth) {
        switch (depth) {
            case 0: {
                return " --depth=empty";
            }
            case 1: {
                return " --depth=files";
            }
            case 2: {
                return " --depth=immediates";
            }
            case 3: {
                return " --depth=infinity";
            }
        }
        return "";
    }

    private String toMergeString(SVNRevisionRange svnRevisionRange) {
        long toRev;
        SVNRevision from = svnRevisionRange.getFromRevision();
        SVNRevision to = svnRevisionRange.getToRevision();
        long fromRev = SVNRevisionRange.getRevisionAsLong((SVNRevision)from);
        if (fromRev + 1L == (toRev = SVNRevisionRange.getRevisionAsLong((SVNRevision)to).longValue())) {
            return "-c " + toRev;
        }
        return "-r " + from.toString() + ":" + to.toString();
    }

    public void mergeReintegrate(SVNUrl path, SVNRevision pegRevision, File localPath, boolean force, boolean dryRun) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = OSvnKitClientAdapter.fileToSVNPath((File)localPath, (boolean)false);
            String commandLine = "merge --reintegrate";
            if (dryRun) {
                commandLine = commandLine + " --dry-run";
            }
            if (force) {
                commandLine = commandLine + " --force";
            }
            commandLine = commandLine + " " + path + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert((SVNRevision)pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.mergeReintegrate(path.toString(), peg, target, dryRun);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    private synchronized ISVNProperty[] getPropFromReference(String path, SVNRevision revision) {
        if (this._reference == null || this._reference.get() == null) {
            return null;
        }
        Map<Pair<String, SVNRevision>, ISVNProperty[]> map = this._reference.get();
        return map.get(new Pair((Object)path, (Object)revision));
    }

    private synchronized void setPropReference(SVNRevision revision, String target, ISVNProperty[] props) {
        if (this._reference == null || this._reference.get() == null) {
            HashMap<Pair, ISVNProperty[]> map = new HashMap<Pair, ISVNProperty[]>();
            map.put(new Pair((Object)target, (Object)revision), props);
            this._reference = new SoftReference(map);
        } else {
            Map<Pair<String, SVNRevision>, ISVNProperty[]> map = this._reference.get();
            map.put((Pair<String, SVNRevision>)new Pair((Object)target, (Object)revision), props);
        }
    }

    private class ISVNDebugLogImpl
    extends SVNDebugLogAdapter {
        private ISVNDebugLogImpl() {
        }

        public void logError(SVNLogType sVNLogType, String string) {
            log.log(Level.SEVERE, string);
        }

        public void logError(SVNLogType sVNLogType, Throwable throwable) {
            log.log(Level.SEVERE, sVNLogType.getName(), throwable);
        }

        public void logSevere(SVNLogType sVNLogType, String string) {
            log.log(Level.SEVERE, string);
        }

        public void logSevere(SVNLogType sVNLogType, Throwable throwable) {
            log.log(Level.SEVERE, sVNLogType.getName(), throwable);
        }

        public void logFine(SVNLogType sVNLogType, Throwable throwable) {
            log.log(Level.FINE, sVNLogType.getName(), throwable);
        }

        public void logFine(SVNLogType sVNLogType, String string) {
            log.log(Level.FINE, string);
        }

        public void logFiner(SVNLogType sVNLogType, Throwable throwable) {
            log.log(Level.FINER, sVNLogType.getName(), throwable);
        }

        public void logFiner(SVNLogType sVNLogType, String string) {
            log.log(Level.FINER, string);
        }

        public void logFinest(SVNLogType sVNLogType, Throwable throwable) {
            log.log(Level.FINEST, sVNLogType.getName(), throwable);
        }

        public void logFinest(SVNLogType sVNLogType, String string) {
            log.log(Level.FINEST, string);
        }

        public void log(SVNLogType sVNLogType, Throwable throwable, Level level) {
            log.log(level, sVNLogType.getName(), throwable);
        }

        public void log(SVNLogType sVNLogType, String string, Level level) {
            log.log(level, string);
        }

        public void log(SVNLogType sVNLogType, String string, byte[] b) {
        }

        public InputStream createLogStream(SVNLogType sVNLogType, InputStream inputStream) {
            return super.createLogStream(sVNLogType, inputStream);
        }

        public OutputStream createLogStream(SVNLogType sVNLogType, OutputStream outputStream) {
            return super.createLogStream(sVNLogType, outputStream);
        }

        public OutputStream createOutputLogStream() {
            return super.createOutputLogStream();
        }

        public OutputStream createInputLogStream() {
            return super.createInputLogStream();
        }

        public void flushStream(Object object) {
        }
    }
}

