/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheStrategy;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;

class SVNURLInfoCacheSimpleStrategy
extends SVNURLInfoCacheStrategy {
    private static final int CACHE_SIZE = 5000;
    private Map<VCSHashURL, SVNURLInfo> _cache = Collections.synchronizedMap(new Maps.CacheMap(5000, Maps.CacheMap.NOT_CANONICAL));

    SVNURLInfoCacheSimpleStrategy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<VCSHashURL, SVNURLInfo> getDirectoryURLInfo(URL url, boolean descend) throws SVNException {
        if (url.getPath().contains(".svn/")) {
            return Collections.emptyMap();
        }
        final LinkedHashMap<VCSHashURL, SVNURLInfo> results = new LinkedHashMap<VCSHashURL, SVNURLInfo>();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            public void handleStatus(SVNStatus status) {
                SVNURLInfo urlInfo = SVNURLInfoCacheSimpleStrategy.this.toURLInfo(status);
                if (status.getKind().equals(SVNNodeKind.DIR)) {
                    results.put(new VCSHashURL(URLFactory.newDirURL((File)status.getFile())), urlInfo);
                } else {
                    results.put(new VCSHashURL(URLFactory.newFileURL((File)status.getFile())), urlInfo);
                }
            }
        };
        ArrayList changelist = new ArrayList();
        Map<VCSHashURL, SVNURLInfo> map = this._cache;
        synchronized (map) {
            try {
                long l = this.getClient().doStatus(SVNUtil.toFile(url), null, descend ? SVNDepth.INFINITY : SVNDepth.FILES, false, true, true, false, handler, changelist);
            }
            catch (SVNException ex) {
                SVNProfile.getQualifiedLogger(SVNURLInfoCacheSimpleStrategy.class.getName()).log(Level.WARNING, "Error on " + url.getPath() + " " + ex.getMessage());
                return Collections.emptyMap();
            }
            this._cache.putAll(results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final SVNURLInfo getURLInfo(URL url) throws SVNException {
        SVNURLInfo urlInfo;
        VCSHashURL hashUrl = new VCSHashURL(url);
        Map<VCSHashURL, SVNURLInfo> map = this._cache;
        synchronized (map) {
            urlInfo = this._cache.get(hashUrl);
            if (urlInfo == null) {
                long time = System.currentTimeMillis();
                SVNStatus status = null;
                try {
                    status = this.getClient().doStatus(SVNUtil.toFile(url), false);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                if (status == null) {
                    return null;
                }
                urlInfo = this.toURLInfo(status);
                this._cache.put(hashUrl, urlInfo);
            }
        }
        return urlInfo;
    }

    @Override
    protected void clear() {
        this._cache.clear();
    }

    @Override
    protected void clear(URL[] urls) {
        this._cache.keySet().removeAll(VCSHashURL.convertFromURLs(Arrays.asList(urls)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear(URLFilter filter) {
        Map<VCSHashURL, SVNURLInfo> map = this._cache;
        synchronized (map) {
            Iterator<VCSHashURL> itr = this._cache.keySet().iterator();
            while (itr.hasNext()) {
                if (!filter.accept(itr.next().getURL())) continue;
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<URL> getUrls(URLFilter filter) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Map<VCSHashURL, SVNURLInfo> map = this._cache;
        synchronized (map) {
            Iterator<VCSHashURL> itr = this._cache.keySet().iterator();
            while (itr.hasNext()) {
                URL url = itr.next().getURL();
                if (!filter.accept(url)) continue;
                urls.add(url);
            }
        }
        return urls;
    }
}

