/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.swing.JPanel;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.ui.SVNPropertiesPanelUI;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public final class SVNPropertiesPanel
extends PropertiesPanel {
    private final URL _url;

    public SVNPropertiesPanel(URL url) {
        this._url = url;
    }

    public Component getComponent() {
        try {
            SVNPropertiesPanelUI ui = new SVNPropertiesPanelUI();
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            boolean isInRepo = this.populateSynchronously(ui, client);
            if (isInRepo) {
                this.populateAsynchronously(ui, client);
            }
            return ui;
        }
        catch (Exception ce) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(ce.getMessage());
            new VCSExceptionHandler().handleException(SVNExceptionWrapper.wrapException(ce));
            return new JPanel();
        }
    }

    private boolean populateSynchronously(SVNPropertiesPanelUI ui, ISVNClientAdapter client) throws SVNException, IOException, SVNClientException {
        SVNURLInfoCache ic = SVNURLInfoCache.getInstance();
        ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(this._url));
        boolean isInRepo = false;
        SVNStatusType st = ic.getTextStatus(this._url);
        ui.setTextStatus(StatusMapping.getVCSStatus(st));
        isInRepo = st != SVNStatusType.STATUS_ADDED;
        ui.setPropertyStatus(StatusMapping.getVCSStatus(ic.getPropStatus(this._url)));
        ui.setRevision(ic.getRevision(this._url));
        ui.setLastChangedRevision(ic.getLastChangedRevision(this._url));
        ui.setLastChangedDate(info.getLastChangedDate());
        ui.setLastCommitAuthor(ic.getLastCommitAuthor(this._url));
        ui.setTextLastChanged(info.getLastDateTextUpdate());
        ui.setPropertiesLastChanged(info.getLastDatePropsUpdate());
        ui.setSchedule(info.getSchedule());
        boolean isCopied = info.isCopied();
        ui.setIsCopied(isCopied);
        if (isCopied) {
            ui.setCopySourceUrl(info.getCopyUrl());
            SVNRevision.Number copyRev = info.getCopyRev();
            ui.setCopySourceRevision(copyRev != null ? copyRev.getNumber() : -1L);
        }
        return isInRepo;
    }

    private void populateAsynchronously(SVNPropertiesPanelUI ui, ISVNClientAdapter client) {
        new ReposPropsThread(ui, client).start();
    }

    static /* synthetic */ URL access$100(SVNPropertiesPanel x0) {
        return x0._url;
    }

    private final class ReposPropsThread
    extends Thread {
        private final SVNPropertiesPanelUI _ui;
        private final ISVNClientAdapter _client;

        private ReposPropsThread(SVNPropertiesPanelUI ui, ISVNClientAdapter client) {
            this._ui = ui;
            this._client = client;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

