/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNVCSException;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tmatesoft.svn.core.SVNException;

public class SVNExceptionWrapper {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNClientInteraction.class.getName());

    public static Exception wrapException(Exception ex) {
        return SVNExceptionWrapper.wrapException(ex, null);
    }

    public static Exception wrapException(Exception ex, Context context) {
        if (ex instanceof SVNClientException) {
            return SVNExceptionWrapper.wrapSVNClientException(ex, context);
        }
        if (ex instanceof SVNException) {
            return SVNExceptionWrapper.wrapSVNException(ex, context);
        }
        return ex;
    }

    public static VCSException wrapSVNClientException(Exception ex) {
        return SVNExceptionWrapper.wrapSVNClientException(ex, null);
    }

    public static VCSException wrapSVNClientException(Exception ex, Context context) {
        String title = Resource.get("EXCEPTION_WRAPPER_TITLE");
        String exceptionHeader = "org.tigris.subversion.javahl.ClientException: ";
        String message = ex.getMessage();
        if (message.startsWith(exceptionHeader)) {
            message = message.substring(exceptionHeader.length());
        }
        message = SVNExceptionWrapper.wrapAuthMsg(message);
        return new SVNVCSException(title, message, context);
    }

    public static String wrapAuthMsg(String message) {
        if (message.indexOf("authentication cancelled") > -1) {
            message = message.replaceFirst("authentication cancelled", Resource.get("EXCEPTION_WRAPPER_AUTH_CANCELED"));
        }
        return message;
    }

    private static VCSException wrapSVNException(Exception ex, Context context) {
        String title = Resource.get("EXCEPTION_WRAPPER_TITLE");
        String message = ex.getMessage();
        return new SVNVCSException(title, message, context);
    }
}

