/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.ui.SSHPrivateKeyPathPanel;
import oracle.jdevimpl.vcs.svn.ui.SSLQueryPanel;
import oracle.jdevimpl.vcs.svn.util.NullPromptListener;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNClientInteraction {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNClientInteraction.class.getName());
    private static final SVNClientInteraction sInstance = new SVNClientInteraction();
    private static final ISVNPromptUserPassword sNullPrompt = new NullPromptListener();
    private ISVNPromptUserPassword _callback;
    private ISVNClientAdapter _client;
    private int _clientCount = 0;

    public static SVNClientInteraction getInstance() {
        return sInstance;
    }

    public synchronized void beginInteraction(ISVNClientAdapter client, SVNRepositoryInfo reposInfo) {
        if (this.isClientInUse()) {
            sLogger.warning("Subversion client is already in use by another thread");
        }
        ++this._clientCount;
        if (this._clientCount == 1) {
            this._client = client;
            this._client.addPasswordCallback(this.getCallback(reposInfo));
            SVNUtil.setAuthInfo(this._client, reposInfo);
        }
    }

    public synchronized void endInteraction() {
        --this._clientCount;
        if (this._clientCount == 0) {
            if (this.isClientInUse()) {
                this._client.addPasswordCallback(sNullPrompt);
                SVNUtil.unsetAuthInfo(this._client);
            }
            this._client = null;
        }
    }

    public boolean isClientInUse() {
        return this._client != null;
    }

    private ISVNPromptUserPassword getCallback(SVNRepositoryInfo reposInfo) {
        this._callback = reposInfo != null && reposInfo.getURL().getProtocol().equals("file") ? new FilesPromptListener() : new PromptListener(reposInfo);
        return this._callback;
    }

    private SVNClientInteraction() {
    }

    private class FilesPromptListener
    implements ISVNPromptUserPassword {
        private FilesPromptListener() {
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return true;
        }

        public String getUsername() {
            return " ";
        }

        public String getPassword() {
            return " ";
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return 0;
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return true;
        }

        public boolean promptUser(String realm, String username, boolean maySave) {
            return true;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public boolean userAllowedSave() {
            return false;
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return false;
        }

        public String getSSHPrivateKeyPath() {
            return null;
        }

        public String getSSHPrivateKeyPassphrase() {
            return null;
        }

        public int getSSHPort() {
            return 0;
        }

        public boolean promptSSL(String realm, boolean maySave) {
            return false;
        }

        public String getSSLClientCertPassword() {
            return null;
        }

        public String getSSLClientCertPath() {
            return null;
        }
    }

    private final class PromptListener
    implements ISVNPromptUserPassword {
        private SVNRepositoryInfo _reposInfo;

        PromptListener(SVNRepositoryInfo reposInfo) {
            this._reposInfo = reposInfo;
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("PromptListener.askYesNo: realm=" + realm + " question=" + question + " yesIsDefault=" + yesIsDefault);
            }
            boolean ans = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)question, (String)Resource.get("AUTHENTICATE_QU_TITLE"), null);
            return ans;
        }

        public String getUsername() {
            sLogger.finest("PromptListener.getUsername");
            return this._reposInfo == null ? null : this._reposInfo.getAuthInfo().getUserName();
        }

        public String getPassword() {
            sLogger.finest("PromptListener.getPassword");
            char[] c = this._reposInfo.getAuthInfo().getPassword();
            String s = new String(c);
            return this._reposInfo == null ? null : s;
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            final SSLQueryPanel queryPanel = new SSLQueryPanel(info);
            if (SwingUtilities.isEventDispatchThread()) {
                WizardLauncher.runDialog((JDialog)this.createSSLQueryDialog(queryPanel));
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            WizardLauncher.runDialog((JDialog)PromptListener.this.createSSLQueryDialog(queryPanel));
                        }
                    });
                }
                catch (InterruptedException ie) {
                    sLogger.info("interrupted while waiting to show ssl query dialog.");
                    return 0;
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getTargetException();
                    sLogger.warning("unexpected error while running ssl query dialog (" + cause.getClass().getName() + "): " + cause.getMessage());
                    return 0;
                }
            }
            return queryPanel.getPolicy();
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            if (this._reposInfo == null && SVNRepositoryManager.getInstance().list().size() == 0) {
                String urlStr;
                Context context = new Context();
                if (realm.length() > 0) {
                    urlStr = realm.substring(realm.indexOf(60) + 1, realm.indexOf(62));
                    urlStr = urlStr.substring(0, urlStr.lastIndexOf(58));
                } else {
                    urlStr = realm;
                }
                context.setProperty("PRESET_NO_TEST", (Object)Boolean.TRUE);
                context.setProperty("PRESET_REPO_URL", (Object)urlStr);
                context.setProperty("PRESET_REPO_NAME", (Object)urlStr);
                context.setProperty("PRESET_REPO_USERNAME", (Object)username);
                SVNUtil.ensureRepositoryConnection(context);
                if (SVNRepositoryManager.getInstance().isEmpty()) {
                    MessageDialog.error((Component)WindowUtils.getActiveWindow(), (Object)Resource.get("INTERACTION_NOREPO_MSG"), (String)Resource.get("INTERACTION_NOREPO_TITLE"), null);
                    return false;
                }
                try {
                    SVNUrl svnurl = new SVNUrl(urlStr);
                    this._reposInfo = SVNUtil.tryGetFirstMatchRepository(svnurl);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.finest("PromptListener.askQuestion realm=" + realm + " question=" + question + " showAnswer=" + showAnswer + " maySave=" + maySave);
            }
            return null;
        }

        public boolean userAllowedSave() {
            sLogger.finest("PromptListener.userAllowedSave");
            return true;
        }

        private JEWTDialog createSSLQueryDialog(SSLQueryPanel queryPanel) {
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)queryPanel, (Component)queryPanel.getDefaultComponent(), (String)Resource.get("UI_SSLQUERY_DIALOG_TITLE"), (int)5);
            HelpSystem.getHelpSystem().registerTopic((JComponent)queryPanel, "f1_svnacceptcertificate_html");
            dialog.setName("SVN-Certificate-Dialog");
            return dialog;
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return false;
        }

        public String getSSHPrivateKeyPath() {
            SSHPrivateKeyPathPanel keyPanel = new SSHPrivateKeyPathPanel();
            if (SwingUtilities.isEventDispatchThread()) {
                WizardLauncher.runDialog((JDialog)this.createSSHPrivateKeyPathDialog(keyPanel));
            }
            return keyPanel.getSSHPrivateKeyPath();
        }

        private JEWTDialog createSSHPrivateKeyPathDialog(SSHPrivateKeyPathPanel keyPanel) {
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)keyPanel, (Component)keyPanel.getDefaultComponent(), (String)Resource.get("NAV_CONNECTION_WIZARD_SSHKEY_DIALOG_TITLE"), (int)5);
            return dialog;
        }

        public String getSSHPrivateKeyPassphrase() {
            final String[] password = new String[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SimpleInputDialog dialog = new SimpleInputDialog(WindowUtils.getActiveWindow()){

                            protected JTextComponent createInputComponent() {
                                return new JPasswordField("", 20);
                            }

                            protected boolean canOk() {
                                return true;
                            }
                        };
                        if (dialog.show(Resource.get("NAV_CONNECTION_WIZARD_SSHKEY_PASSPHRASE_TITLE"), Resource.get("NAV_CONNECTION_WIZARD_SSHKEY_PASSPHRASE"), null)) {
                            password[0] = dialog.getInputValue();
                        }
                    }
                });
            }
            catch (InterruptedException ie) {
                sLogger.info("interrupted while prompting for ssh private key passphrase.");
                return null;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getTargetException();
                sLogger.warning("unexpected error while running prompting for  ssh private key passphrase (" + cause.getClass().getName() + "): " + cause.getMessage());
                return null;
            }
            return null;
        }

        public int getSSHPort() {
            return -1;
        }

        public boolean promptSSL(String string, boolean b) {
            return false;
        }

        public String getSSLClientCertPassword() {
            return null;
        }

        public String getSSLClientCertPath() {
            return null;
        }

        public boolean promptUser(String string, String string1, boolean b) {
            return false;
        }
    }
}

