/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template.flash;

import oracle.dss.util.xdo.common.io.LE;
import oracle.dss.util.xdo.template.flash.SWFReader;

public class Tag {
    private byte[] mData;
    private int mPos;
    private int mType;
    private int mLen;
    private int mHeaderSize;

    public Tag(byte[] data, int pos) {
        this.mData = data;
        this.mPos = pos;
        this.parse();
    }

    private void parse() {
        SWFReader sr = new SWFReader(this.mData, this.mPos);
        int tagHeader = sr.readUI16();
        this.mType = SWFReader.readBits(tagHeader << 16, 0, 9);
        this.mLen = SWFReader.readBits(tagHeader << 16, 10, 15);
        this.mHeaderSize = 2;
        if (this.mLen == 63) {
            this.mLen = sr.readSI32();
            this.mHeaderSize = 6;
        }
    }

    public int getType() {
        return this.mType;
    }

    public int getLength() {
        return this.mLen;
    }

    public int getHeaderSize() {
        return this.mHeaderSize;
    }

    public static byte[] generateHeaderBytes(int type, int len) {
        byte[] header;
        if (len < 63) {
            header = new byte[2];
            int val = type << 6 | len;
            LE.writeUInt16(val, header, 0);
        } else {
            header = new byte[6];
            int val = type << 6 | 0x3F;
            LE.writeUInt16(val, header, 0);
            LE.writeInt32(len, header, 2);
        }
        return header;
    }
}

