/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xdo.template.flash;

public class AS3Int {
    public static byte[] toByteArray(int val) {
        byte[] buf;
        if (val <= 127) {
            buf = new byte[]{(byte)val};
        } else if (val <= 16383) {
            buf = new byte[]{(byte)(val & 0x7F | 0x80), (byte)(val >> 7)};
        } else if (val <= 0x1FFFFF) {
            buf = new byte[]{(byte)(val & 0x7F | 0x80), (byte)(val >> 7 | 0x80), (byte)(val >> 14)};
        } else if (val <= 0xFFFFFFF) {
            buf = new byte[]{(byte)(val & 0x7F | 0x80), (byte)(val >> 7 | 0x80), (byte)(val >> 14 | 0x80), (byte)(val >> 21)};
        } else {
            buf = new byte[5];
            buf[0] = (byte)(val & 0x7F | 0x80);
            buf[1] = (byte)(val >> 7 | 0x80);
            buf[2] = (byte)(val >> 14 | 0x80);
            buf[2] = (byte)(val >> 21 | 0x80);
            buf[3] = (byte)(val >> 28);
        }
        return buf;
    }

    public static int toInt(byte[] buf) {
        return AS3Int.toInt(buf, 0);
    }

    public static int toInt(byte[] buf, int startPos) {
        int val = 0;
        for (int pos = 0; pos < buf.length - startPos; ++pos) {
            int b = buf[startPos + pos] & 0xFF;
            if (b < 128) {
                val |= b << 7 * pos;
                break;
            }
            val |= (b & 0x7F) << 7 * pos;
        }
        return val;
    }

    public static int size(byte[] buf, int startPos) {
        int b;
        int pos = 0;
        for (pos = 0; pos < buf.length - startPos && (b = buf[startPos + pos] & 0xFF) >= 128; ++pos) {
        }
        return pos + 1;
    }
}

