/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.Cube;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.LayerMetadataCacheKey;
import oracle.dss.util.transform.MemberCacheKey;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MemberMetadataCacheKey;
import oracle.dss.util.transform.Page;
import oracle.dss.util.transform.QDRCache;
import oracle.dss.util.transform.QDRCacheKey;
import oracle.dss.util.transform.QDRCacheKeyPool;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.ResultTable;
import oracle.dss.util.transform.SliceInsertInfo;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.UpdateableDataAccess;
import oracle.dss.util.transform.hPosDataCacheKey;
import oracle.dss.util.transform.hPosMetadataCacheKey;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public class TabularDataAccess
implements DataAccess,
UpdateableDataAccess,
Cloneable {
    private boolean m_initialized = false;
    protected Cube m_cube = null;
    protected transient Hashtable<hPosDataCacheKey, Object> m_dataCache = new Hashtable();
    protected transient Hashtable<MemberCacheKey, Object> m_memberCache = new Hashtable();
    protected transient Hashtable<MemberMetadataCacheKey, Object> m_memberMetadataCache = new Hashtable();
    protected transient Hashtable<hPosMetadataCacheKey, Object> m_hPosMetadataCache = new Hashtable();
    protected transient Hashtable<LayerMetadataCacheKey, Object> m_layerMetadataCache = new Hashtable();
    protected transient QDRCache m_qdrCache = new QDRCache();
    protected transient Hashtable<QDRCacheKey, DataCellInterface> m_qdrDataCache = new Hashtable();
    protected ArrayList<QDRLite> m_realQDRs = new ArrayList();
    protected ResultTable m_rt = null;
    protected DataDirector m_dd = null;
    protected Page m_currenthPos = new Page();
    protected Vector m_dataItems = new Vector();
    protected boolean m_checkedLayerCollisions = false;
    protected boolean m_anyCollisions = false;
    protected QDRCacheKeyPool m_qdrKeyPool = null;
    protected boolean m_caching = true;
    protected boolean m_clone = false;
    protected String[][] m_cachedLayout = null;
    protected String m_cachedDataLayer = null;
    protected MemberInterface[] m_cachedDataItems = null;
    protected DataCellInterface m_nullDataCellInterface = new DataCellInterface(){

        @Override
        public Object getData(String type) {
            return Cube.m_nullMarker;
        }

        @Override
        public boolean setData(Object value, String type) {
            return false;
        }
    };

    public TabularDataAccess(ResultTable rt) throws TransformException {
        this.init(rt);
    }

    public boolean isOutline(int edge) {
        return this.m_cube != null && this.m_cube.isOutline(edge);
    }

    protected void clearCaches(boolean clearMemberCache, boolean clearQDRCache) {
        this.m_dataCache.clear();
        if (clearMemberCache) {
            this.m_memberCache.clear();
        }
        this.m_memberMetadataCache = new Hashtable();
        this.m_hPosMetadataCache.clear();
        this.m_layerMetadataCache.clear();
        if (clearQDRCache) {
            this.m_qdrCache.clear();
        }
        this.m_qdrDataCache.clear();
        this.m_realQDRs.clear();
    }

    protected void initCaches() {
        this.m_qdrKeyPool = new QDRCacheKeyPool(10);
    }

    private boolean _hasLayer(String[][] layout, int edge, int layer, String layerName) {
        if (layout != null && layerName != null) {
            for (int e = 0; e < layout.length; ++e) {
                if (layout[e] == null) continue;
                for (int l = 0; l < layout[e].length; ++l) {
                    if (edge == e && l == layer || !layerName.equals(layout[e][l])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCollisions() {
        if (this.m_checkedLayerCollisions) {
            return this.m_anyCollisions;
        }
        this.m_checkedLayerCollisions = true;
        String[][] layout = this.getLayout();
        if (layout != null) {
            for (int e = 0; e < layout.length; ++e) {
                if (layout[e] == null) continue;
                for (int l = 0; l < layout[e].length; ++l) {
                    if (!this._hasLayer(layout, e, l, layout[e][l])) continue;
                    this.m_anyCollisions = true;
                    return this.m_anyCollisions;
                }
            }
        }
        return this.m_anyCollisions;
    }

    public boolean isLocalStorage() {
        if (this.getResultTable() != null) {
            return this.getResultTable().isLocalStorage();
        }
        return false;
    }

    public ResultTable getResultTable() {
        return this.m_rt;
    }

    protected BaseProjection getProjection() {
        if (this.m_rt != null) {
            return this.m_rt.getProjection();
        }
        return null;
    }

    protected synchronized void init(ResultTable rt) throws TransformException {
        if (this.m_initialized) {
            return;
        }
        if (this.m_rt != null && this.m_rt.getDataTable() != null || rt == null) {
            return;
        }
        this.m_initialized = true;
        try {
            this.m_rt = (ResultTable)rt.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new TransformException(e.getMessage(), e);
        }
        this.m_dataItems.removeAllElements();
        MemberInterface[] dataItems = this.getDataItems();
        if (dataItems != null) {
            for (int i = 0; i < dataItems.length; ++i) {
                this.m_dataItems.add(dataItems[i].getValue());
            }
        }
    }

    protected TabularDataAccess() throws TransformException {
        this(null);
    }

    protected TabularDataAccess copy(TabularDataAccess newDA) throws CloneNotSupportedException, TransformException {
        if (this.m_rt != null) {
            newDA.m_rt = (ResultTable)this.m_rt.clone();
        }
        newDA.init(newDA.m_rt);
        return this._copy(newDA);
    }

    private TabularDataAccess _copy(TabularDataAccess newDA) throws CloneNotSupportedException {
        newDA.m_currenthPos = (Page)this.m_currenthPos.clone();
        if (this.m_cube != null) {
            newDA.m_cube = (Cube)this.m_cube.clone(this.m_caching);
        }
        newDA.m_dataCache = (Hashtable)this.m_dataCache.clone();
        newDA.m_memberCache = (Hashtable)this.m_memberCache.clone();
        newDA.m_memberMetadataCache = (Hashtable)this.m_memberMetadataCache.clone();
        newDA.m_hPosMetadataCache = (Hashtable)this.m_hPosMetadataCache.clone();
        newDA.m_layerMetadataCache = (Hashtable)this.m_layerMetadataCache.clone();
        newDA.m_checkedLayerCollisions = this.m_checkedLayerCollisions;
        newDA.m_anyCollisions = this.m_anyCollisions;
        newDA.m_caching = this.m_caching;
        if (this.m_cachedLayout != null) {
            newDA.m_cachedLayout = (String[][])this.m_cachedLayout.clone();
        }
        if (this.m_cachedDataLayer != null) {
            newDA.m_cachedDataLayer = this.m_cachedDataLayer;
        }
        if (this.m_cachedDataItems != null) {
            newDA.m_cachedDataItems = (MemberInterface[])this.m_cachedDataItems.clone();
        }
        newDA.m_qdrCache = (QDRCache)this.m_qdrCache.clone();
        newDA.m_qdrDataCache = (Hashtable)this.m_qdrDataCache.clone();
        newDA.m_realQDRs = (ArrayList)this.m_realQDRs.clone();
        if (this.m_dataItems != null) {
            newDA.m_dataItems = (Vector)this.m_dataItems.clone();
        }
        return newDA;
    }

    public Object clone() throws CloneNotSupportedException {
        TabularDataAccess newDA = (TabularDataAccess)super.clone();
        if (this.m_caching) {
            try {
                int edgeCount = this.getEdgeCount();
                for (int e = 0; e < edgeCount; ++e) {
                    int layerCount = this.getLayerCount(e);
                    for (int l = 0; l < layerCount; ++l) {
                        this.getLayerMetadata(e, l, "layerName");
                    }
                }
            }
            catch (Exception e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
            newDA.m_clone = true;
        }
        newDA = this._copy(newDA);
        return newDA;
    }

    public void setDataDirector(DataDirector dd) {
        this.m_dd = dd;
    }

    protected void _storeQDRDataCache(QDRCacheKey qdrCacheKey, DataCellInterface dataCellInt) {
        if (qdrCacheKey == null) {
            return;
        }
        if (dataCellInt == null) {
            this.m_qdrDataCache.put((QDRCacheKey)qdrCacheKey.clone(), this.m_nullDataCellInterface);
        } else {
            this.m_qdrDataCache.put((QDRCacheKey)qdrCacheKey.clone(), dataCellInt);
        }
        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
    }

    protected void _storeQDRCache(QDRCacheKey qdrCacheKey, String type, Object metadata) {
        if (qdrCacheKey == null) {
            return;
        }
        if (metadata == null) {
            this.m_qdrCache.put((QDRCacheKey)qdrCacheKey.clone(), type, Cube.m_nullMarker);
        } else {
            this.m_qdrCache.put((QDRCacheKey)qdrCacheKey.clone(), type, metadata);
        }
        this.m_qdrKeyPool.returnCacheKeyToPool(qdrCacheKey);
    }

    private void _clearQDRKey(QDRLite location) {
        QDRCacheKey key = this.m_qdrKeyPool.getCacheKeyFromPool(location);
        this.m_qdrCache.put(key, null, Cube.m_nullMarker);
        this.m_qdrDataCache.put(key, this.m_nullDataCellInterface);
        this.m_qdrKeyPool.returnCacheKeyToPool(key);
    }

    @Override
    public synchronized void delete(QDRInterface[] location) {
        if (location == null || location.length == 0) {
            return;
        }
        QDRLite[] qdrs = this._stringifyQDRs(location);
        String[][] layout = this.getLayout();
        for (int i = 0; i < qdrs.length; ++i) {
            if (this.m_realQDRs.remove(qdrs[i])) {
                this._clearQDRKey(qdrs[i]);
            }
            QDRLite currLocation = null;
            try {
                currLocation = (QDRLite)qdrs[i].clone();
            }
            catch (CloneNotSupportedException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
            for (int e = 0; e < layout.length; ++e) {
                QDRLite maximalDeleteQDR = null;
                QDRLite currQDR = this._getEdgeQDRs(currLocation, e);
                if (layout[e] == null) continue;
                for (int l = layout[e].length - 1; l >= 0 && !this._hasSubset(currQDR); --l) {
                    try {
                        maximalDeleteQDR = (QDRLite)currQDR.clone();
                        this.clearQDRCache(new QDRLite[]{currQDR});
                    }
                    catch (CloneNotSupportedException ex) {
                        throw new TransformRuntimeException(ex.getMessage(), ex);
                    }
                    currQDR.removeDimMemberPair(layout[e][l]);
                }
                if (maximalDeleteQDR == null) continue;
                try {
                    this.m_cube.delete(new QDRLite[]{maximalDeleteQDR}, this.getCurrentPage());
                    this.clearQDRCache(new QDRLite[]{qdrs[i]});
                    continue;
                }
                catch (TransformException ex) {
                    throw new TransformRuntimeException(ex.getMessage(), ex);
                }
            }
        }
        this.clearPositionalCaches();
    }

    private void clearPositionalCaches() {
        this.m_dataCache.clear();
        this.m_memberMetadataCache.clear();
        this.m_hPosMetadataCache.clear();
    }

    private boolean _hasSubset(QDRLite qdr) {
        Iterator<QDRLite> qdrs = this.m_realQDRs.iterator();
        QDRLite realQDR = null;
        while (qdrs.hasNext()) {
            realQDR = qdrs.next();
            if (!realQDR.isSubsetOf(qdr)) continue;
            return true;
        }
        return false;
    }

    protected void clearQDRCache(QDRLite[] location) {
        QDRCacheKey key = null;
        for (int i = 0; i < location.length; ++i) {
            key = this.m_qdrKeyPool.getCacheKeyFromPool(location[i]);
            this.m_qdrCache.remove(key);
            this.m_qdrKeyPool.returnCacheKeyToPool(key);
        }
    }

    private QDRLite _getEdgeQDRs(QDRLite qdr, int edge) {
        String[][] layout = this.getLayout();
        if (layout == null || layout.length <= edge || layout[edge] == null) {
            return null;
        }
        QDRLite qdrTemp = null;
        qdrTemp = this._getMemberQDR(qdr, layout, edge, layout[edge].length - 1);
        if (qdrTemp != null && !qdrTemp.isEmpty()) {
            return qdrTemp;
        }
        return null;
    }

    private QDRLite _getMemberQDR(QDRLite location, String[][] layout, int edge, int layer) {
        QDRLite qdr = new QDRLite();
        String member = null;
        for (int l = 0; l <= layer; ++l) {
            member = (String)location.getDimMember(layout[edge][l]);
            if (member == null) continue;
            qdr.addDimMemberPair(layout[edge][l], member);
        }
        return qdr;
    }

    @Override
    public void insert(SliceInsertInfo[] slices) {
        if (slices == null) {
            return;
        }
        Map<QDRInterface, DataCellInterface> dataMap = null;
        QDRLite dataQDR = null;
        try {
            String dataLayer = this.getDataLayer();
            MemberInterface[] dataMemberInterfaces = this.getDataItems();
            for (int i = 0; i < slices.length; ++i) {
                dataQDR = this._sliceToInsertQDR(slices[i]);
                if (dataQDR == null) continue;
                this.m_cube.insert(slices[i], dataLayer, dataMemberInterfaces, this.getCurrentPage());
                dataMap = slices[i].getData();
                QDRLite tempQDR = null;
                QDRLite[] qdrs = null;
                if (dataMap == null) continue;
                HashMap<QDRLite, DataCellInterface> newDataMap = new HashMap<QDRLite, DataCellInterface>();
                QDRInterface[] oldQDRs = dataMap.keySet().toArray(new QDRInterface[0]);
                qdrs = new QDRLite[oldQDRs.length];
                DataCellInterface dci = null;
                for (int q = 0; q < oldQDRs.length; ++q) {
                    qdrs[q] = this._stringifyQDRs(new QDRInterface[]{oldQDRs[q]})[0];
                    dci = dataMap.get(oldQDRs[q]);
                    newDataMap.put(qdrs[q], dci);
                }
                tempQDR = (QDRLite)dataQDR.clone();
                if (qdrs == null) continue;
                QDRCacheKey qdrCacheKey = null;
                for (int q = 0; q < qdrs.length; ++q) {
                    Iterator<String> dims = qdrs[q].getColumns().iterator();
                    String dim = null;
                    while (dims.hasNext()) {
                        dim = dims.next();
                        tempQDR.addDimMemberPair(dim, qdrs[q].getDimMember(dim));
                    }
                    qdrCacheKey = this.m_qdrKeyPool.getCacheKeyFromPool((QDRLite)tempQDR.clone());
                    this._storeQDRDataCache(qdrCacheKey, (DataCellInterface)newDataMap.get(qdrs[q]));
                    this.m_realQDRs.add((QDRLite)tempQDR.clone());
                }
            }
        }
        catch (Exception e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        this.clearPositionalCaches();
    }

    private QDRLite _sliceToInsertQDR(SliceInsertInfo sii) throws TransformException {
        if (sii == null || sii.getSliceToInsert() == null) {
            return null;
        }
        Map<String, MemberInterface> sliceToInsert = sii.getSliceToInsert();
        String[] layers = TransformUtils.getLayersFromSliceToInsert(sliceToInsert);
        QDRLite qdr = new QDRLite();
        boolean haveMeas = false;
        for (int i = 0; i < layers.length; ++i) {
            qdr.addDimMemberPair(layers[i], sliceToInsert.get(layers[i]).getValue());
        }
        return qdr;
    }

    @Override
    public synchronized void setMetadataValues(QDRInterface[] locations, String[] layer, Map<String, Object>[] metadata) {
    }

    @Override
    public synchronized void setValues(QDRInterface[] locations, Map<String, Object>[] values) {
        if (locations == null || locations.length == 0) {
            return;
        }
    }

    private QDRLite[] _stringifyQDRs(QDRInterface[] location) {
        if (location == null) {
            return null;
        }
        QDRLite[] lites = new QDRLite[location.length];
        for (int i = 0; i < lites.length; ++i) {
            lites[i] = new QDRLite(location[i]);
        }
        return this._stringifyQDRs(lites);
    }

    private QDRLite[] _stringifyQDRs(QDRLite[] location) {
        if (location == null) {
            return null;
        }
        QDRLite[] retQDR = new QDRLite[location.length];
        for (int i = 0; i < location.length; ++i) {
            retQDR[i] = new QDRLite();
            Iterator<String> dims = location[i].getColumns().iterator();
            String dim = null;
            Object data = null;
            while (dims.hasNext()) {
                dim = dims.next();
                data = location[i].getDimMember(dim);
                retQDR[i].addDimMemberPair(dim, data != null ? data.toString() : null);
            }
        }
        return retQDR;
    }

    @Override
    public synchronized void invalidate(QDRInterface[] location) {
        if (location == null || location.length == 0) {
            return;
        }
        QDRLite[] qdrs = this._stringifyQDRs(location);
        try {
            this.m_cube.invalidate(qdrs, this.getCurrentPage());
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        this.clearCaches(this.isLocalStorage(), true);
    }

    @Override
    public synchronized int getEdgeCount() {
        String[][] layout = this.getLayout();
        int count = layout != null ? layout.length : 0;
        return count > 3 ? count : 3;
    }

    protected MemberInterface[] getDataItems() {
        if (this.m_cachedDataItems == null) {
            this.m_cachedDataItems = this.m_rt.getProjection().getDataItems();
        }
        return this.m_cachedDataItems;
    }

    protected String getDataLayer() throws TransformException {
        if (this.m_cachedDataLayer == null) {
            this.m_cachedDataLayer = this.m_rt.getProjection().getDataLayer() != null ? this.m_rt.getProjection().getDataLayer().getValue() : null;
        }
        return this.m_cachedDataLayer;
    }

    protected String[][] getLayout() {
        if (this.m_cachedLayout == null) {
            this.m_cachedLayout = this.m_rt.getProjection().getLayout();
        }
        return this.m_cachedLayout;
    }

    protected int getEdgeTreeCount() {
        return this.m_cube.getEdgeCount();
    }

    protected EdgeTree getEdgeTree(int edge, long slice, boolean checked) throws EdgeOutOfRangeException, TransformException {
        this.checkEdgeRange(edge);
        if (this.m_cube != null) {
            return this.m_cube.getEdgeTree(edge, this.getCurrentPage());
        }
        return null;
    }

    @Override
    public synchronized int[] getEdgeCurrentHPos(int edge) throws EdgeOutOfRangeException {
        try {
            return TransformUtils.getIntFromLongArray(this.getEdgeCurrentHPosLong(edge));
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    protected String[] getEdgeCurrentHPosObj(int edge) throws EdgeOutOfRangeException {
        if (this.m_currenthPos != null) {
            return this.m_currenthPos.getPage(edge);
        }
        return null;
    }

    protected Page getCurrentPage() {
        return this.m_currenthPos;
    }

    protected long[] _getLastHPos(int edge) throws EdgeOutOfRangeException, TransformException {
        EdgeTree et = this.getEdgeTree(edge, this.getEdgeExtent(edge), true);
        if (et != null) {
            return et.getLastLeafNode().getHPos();
        }
        return null;
    }

    protected long[] _getFirstHPos(int edge) throws EdgeOutOfRangeException, TransformException {
        EdgeTree et = this.getEdgeTree(edge, 0L, true);
        if (et != null) {
            return et.getFirstLeafNode().getHPos();
        }
        return null;
    }

    protected long[] getEdgeCurrentHPosLong(int edge) throws EdgeOutOfRangeException, TransformException {
        if (edge < 2) {
            return null;
        }
        String[] currHPos = this.getEdgeCurrentHPosObj(edge);
        EdgeTree et = this.getEdgeTree(edge, -1L, true);
        if (et == null) {
            return null;
        }
        if (currHPos == null) {
            long[] hPos = TransformUtils.getLongFromIntArray(this.getFirstHPos(edge));
            this.m_currenthPos.setPage(edge, et.getHPosValues(hPos));
            return hPos;
        }
        EdgeTreeNode[] node = et.findNode(currHPos, false);
        if (node != null && node.length > 0 && node[0] != null) {
            return node[0].getHPos();
        }
        return null;
    }

    @Override
    public boolean getEdgeSymmetric(int edge) throws EdgeOutOfRangeException {
        return false;
    }

    public synchronized long _getEdgeExtentLong(int edge) throws EdgeOutOfRangeException {
        switch (edge) {
            case 0: {
                String[][] layout = this.getLayout();
                if (layout != null && layout.length > edge && layout[edge] != null) {
                    return layout[edge].length;
                }
                return 0L;
            }
            case 1: {
                return this.m_rt.getDataTable().getRowCount();
            }
        }
        try {
            return this.getEdgeTree(edge, -1L, true).getExtent();
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    public synchronized void setCurrentPosition(int edge, long pos) throws TransformException {
        Object[] currVals = null;
        try {
            Object[] newVals;
            currVals = this.getEdgeCurrentHPosObj(edge);
            EdgeTree et = this.getEdgeTree(edge, pos, true);
            if (et == null) {
                return;
            }
            if (pos >= et.getExtent()) {
                pos = 0L;
            }
            if (!Utility.compareArrays(newVals = et.getSliceValues(pos), currVals)) {
                this.m_currenthPos.setPage(edge, (String[])newVals);
            }
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
    }

    public synchronized void setCurrentPosition(int edge, int[] hPos) throws EdgeOutOfRangeException, TransformException {
        long slice = this.getSliceFromHPos(edge, hPos);
        this.setCurrentPosition(edge, (int)slice);
    }

    public synchronized boolean isAsymmetric(int edge) throws EdgeOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                return et.isAsymmetric();
            }
            return false;
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
    }

    public synchronized long getSliceFromHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, TransformException {
        EdgeTree et = this.getEdgeTree(edge, -1L, true);
        if (et != null && hPos != null) {
            try {
                long[] hPosLong = TransformUtils.getLongFromIntArray(hPos);
                EdgeTreeNode node = et.getNode(hPosLong, hPosLong.length, hPosLong.length > 0 ? (long)hPos[hPos.length - 1] : 0L);
                return node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1L);
            }
            catch (TransformException e) {
                throw new EdgeOutOfRangeException(e.getMessage(), e);
            }
        }
        return -1L;
    }

    @Override
    public synchronized int getEdgeExtent(int edge) throws EdgeOutOfRangeException {
        return (int)this._getEdgeExtentLong(edge);
    }

    @Override
    public synchronized Object getValue(int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        String id = this.getColumnIDFromLayout(col);
        if (this.m_dataItems.contains(id)) {
            try {
                return this.m_rt.getDataTable().getCell((long)row, id).getData(TransformUtils.convertDataMap(type));
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        String mappedType = type;
        if (type.equals("dataValue")) {
            mappedType = "value";
        }
        if (type.equals("dataIsTotal")) {
            return false;
        }
        try {
            if (mappedType.equals("value")) {
                MemberInterface membInt = this.m_rt.getDataTable().getMember((long)row, id);
                if (membInt != null) {
                    return membInt.getValue();
                }
                return null;
            }
            return this.m_rt.getDataTable().getMember((long)row, id).getMetadata(TransformUtils.convertMetadataMap(mappedType));
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
    }

    private String getColumnIDFromLayout(int column) throws ColumnOutOfRangeException {
        try {
            return this.getIDFromLayout(0, column);
        }
        catch (LayerOutOfRangeException e) {
            throw new ColumnOutOfRangeException(e.getMessage(), e);
        }
    }

    private String getIDFromLayout(int edge, int layer) throws LayerOutOfRangeException {
        return this.getLayout()[edge][layer];
    }

    protected Object getMemberMetadata(EdgeTreeNode node, String type) throws TransformException {
        if (node != null) {
            if (type.equals("isAgg")) {
                return node.isAggregateNodeType();
            }
            if (type.equals("value")) {
                return node.getMember().getValue();
            }
            return node.getMember().getMetadata(TransformUtils.convertMetadataMap(type));
        }
        return null;
    }

    @Override
    public synchronized boolean setValue(Object data, int row, int col, String type) throws RowOutOfRangeException, ColumnOutOfRangeException {
        return false;
    }

    @Override
    public synchronized int getEdgeCurrentSlice(int edge) throws EdgeOutOfRangeException {
        if (edge < 2) {
            return -1;
        }
        try {
            return (int)this.getSliceFromHPos(edge, this.getEdgeCurrentHPos(edge));
        }
        catch (TransformException e) {
            Logger.getLogger("oracle.dss.util.transform").logp(Level.SEVERE, this.getClass().getName(), "getEdgeCurrentSlice", e.getMessage(), e);
            return -1;
        }
    }

    protected void checkEdgeRange(int edge) throws EdgeOutOfRangeException {
        if (edge < 0 || edge >= this.getEdgeCount()) {
            throw new EdgeOutOfRangeException(edge, this.getEdgeCount());
        }
    }

    protected void checkLayerRange(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        this.checkEdgeRange(edge);
        if (layer < 0 || layer >= this.getLayerCount(edge)) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount(edge));
        }
    }

    protected LayerInterface getLayerInfo(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return this.m_rt.getProjection().getLayer(this.getLayerName(edge, layer));
    }

    protected String getLayerName(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        this.checkLayerRange(edge, layer);
        return this.getLayout()[edge][layer];
    }

    @Override
    public synchronized int getLayerCount(int edge) throws EdgeOutOfRangeException {
        String[][] layout = this.getLayout();
        if (layout != null && layout.length > edge && layout[edge] != null) {
            return layout[edge].length;
        }
        return 0;
    }

    @Override
    public synchronized Object getSliceLabel(int edge, int slice, String type) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        if (type.equals("shortName") || type.equals("label") || type.equals("mediumName") || type.equals("displayName") || type.equals("value")) {
            String label = "";
            int max = this.getLayerCount(edge);
            for (int i = 0; i < max; i += this.getMemberDepth(edge, i, slice)) {
                try {
                    label = label + this.getMemberMetadata(edge, i, slice, type) + " ";
                    continue;
                }
                catch (LayerOutOfRangeException e) {
                    throw new SliceOutOfRangeException(e.getMessage(), e);
                }
            }
            return label.trim();
        }
        return null;
    }

    @Override
    public synchronized int getSliceMemberCount(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, slice, true);
            if (et != null) {
                return et.getDepth(-1, slice);
            }
        }
        catch (TransformException e) {
            throw new SliceOutOfRangeException(e.getMessage(), e);
        }
        return 1;
    }

    @Override
    public synchronized int getSliceOutlineLayer(int edge, int slice) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    @Override
    public synchronized int getMemberDepth(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    @Override
    public synchronized int getMemberStartLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return layer;
    }

    @Override
    public synchronized int getMemberLogicalLayer(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return layer;
    }

    @Override
    public synchronized Object getLayerMetadata(int edge, int layer, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return this.getIDFromLayout(edge, layer);
    }

    @Override
    public synchronized int getMemberExtent(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    @Override
    public synchronized int getMemberStartSlice(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return slice;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int layer, int slice, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        switch (edge) {
            case 0: {
                try {
                    String id = this.getLayout()[edge][layer];
                    MemberInterface member = null;
                    MemberInterface[] members = this.getDataItems();
                    int index = this.m_dataItems.indexOf(id);
                    if (index != -1) {
                        member = members[index];
                    }
                    if (member != null) {
                        if (type.equals("value")) {
                            return member.getValue();
                        }
                        return member.getMetadata(TransformUtils.convertMetadataMap(type));
                    }
                    String mappedType = type;
                    if (type.equals("label")) {
                        mappedType = "layerLabel";
                    }
                    if (mappedType.equals("layerName")) {
                        return this.m_rt.getProjection().getLayer(id).getValue();
                    }
                    return this.m_rt.getProjection().getLayer(id).getMetadata(TransformUtils.convertLayerMetadataMap(mappedType));
                }
                catch (TransformException e) {
                    throw new TransformRuntimeException(e.getMessage(), e);
                }
            }
            case 1: {
                if (type.equals("drillState")) {
                    return new Integer(0);
                }
                return new Integer(layer);
            }
        }
        return null;
    }

    @Override
    public synchronized QDR getValueQDR(int row, int column, int flags) throws RowOutOfRangeException, ColumnOutOfRangeException {
        return null;
    }

    @Override
    public synchronized QDR getSliceQDR(int edge, int slice, int flags) throws EdgeOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public synchronized QDR getMemberQDR(int edge, int layer, int slice, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public synchronized QDR getMemberQDR(int edge, int[] hPos, int memberLayer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public synchronized QDR getLayerQDR(int edge, int layer, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    @Override
    public synchronized int getMemberSiblingCount(int edge, int[] hPos, int memberLayer) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 2) {
            return 0;
        }
        return 0;
    }

    @Override
    public synchronized Object getMemberMetadata(int edge, int[] hPos, int memberLayer, int hIndex, String type) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 2) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized int[] getMemberHPos(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 2) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized int[] getFirstHPos(int edge) throws EdgeOutOfRangeException {
        try {
            if (edge < 2) {
                return TransformUtils.getIntFromLongArray(this._getFirstHPos(edge));
            }
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized int[] getLastHPos(int edge) throws EdgeOutOfRangeException {
        try {
            if (edge < 2) {
                return TransformUtils.getIntFromLongArray(this._getLastHPos(edge));
            }
        }
        catch (TransformException e) {
            throw new EdgeOutOfRangeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public synchronized int[] getPrevHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 2) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized int[] getNextHPos(int edge, int[] hPos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (edge < 2) {
            return null;
        }
        return null;
    }

    @Override
    public synchronized int[] getSlicesFromQDR(QDRInterface qdr, int[] startSlice, int[] endSlice) {
        return null;
    }

    @Override
    public synchronized int findMember(int edge, int[] hPos, int memberLayer, String s, String type, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return -1;
    }

    @Override
    public int[] findMembers(int edge, int[] hPos, int memberLayer, String s, String type, int flags) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public synchronized void release() {
        this.m_initialized = false;
        if (this.m_cube != null) {
            this.m_cube.release();
        }
        this.m_cube = null;
        if (this.m_memberCache != null) {
            this.m_memberCache.clear();
        }
        this.m_memberCache = null;
        if (this.m_dataCache != null) {
            this.m_dataCache.clear();
        }
        this.m_dataCache = null;
        if (this.m_memberMetadataCache != null) {
            this.m_memberMetadataCache.clear();
        }
        this.m_memberMetadataCache = null;
        if (this.m_hPosMetadataCache != null) {
            this.m_hPosMetadataCache.clear();
        }
        this.m_hPosMetadataCache = null;
        if (this.m_layerMetadataCache != null) {
            this.m_layerMetadataCache.clear();
        }
        this.m_layerMetadataCache = null;
        try {
            if (this.m_rt != null) {
                this.m_rt.close();
            }
        }
        catch (TransformException e) {
            Logger.getLogger("oracle.dss.util.transform").logp(Level.SEVERE, this.getClass().getName(), "release", e.getMessage(), e);
        }
        this.m_rt = null;
        this.m_dd = null;
        this.m_currenthPos = new Page();
        this.m_currenthPos = null;
        this.m_dataItems = null;
        this.m_qdrKeyPool = null;
    }

    @Override
    public synchronized void startGroupEdit() {
    }

    @Override
    public synchronized void endGroupEdit() {
    }

    @Override
    public synchronized boolean submitChanges() {
        return false;
    }

    @Override
    public synchronized boolean undoEdit() {
        return false;
    }

    @Override
    public synchronized boolean redoEdit() {
        return false;
    }

    @Override
    public synchronized boolean dropChanges() {
        return false;
    }

    @Override
    public synchronized void setAutoSubmit(boolean bValue) {
    }

    @Override
    public synchronized boolean isAutoSubmit() {
        return false;
    }

    @Override
    public synchronized List getUniqueMemberMetadata(int edge, int layer, String[] types, int start, int count) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public synchronized List getUniqueMemberMetadata(String layerName, String[] types, int start, int count) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public synchronized List getCorrespondingMemberMetadata(int edge, int layer, String[] values, String[] types, boolean inDataAccess) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    @Override
    public synchronized List getCorrespondingMemberMetadata(String layerName, String[] values, String[] types, boolean inDataAccess) throws LayerOutOfRangeException {
        return null;
    }

    @Override
    public synchronized boolean allSlicesFetched(int edge) throws EdgeOutOfRangeException {
        return true;
    }

    @Override
    public synchronized boolean isFetched(int[] startSlice, int[] endSlice, int flag) throws SliceOutOfRangeException {
        return true;
    }

    @Override
    public synchronized boolean forceFetch(int[] startSlice, int[] endSlice, int flag) throws SliceOutOfRangeException {
        return true;
    }

    @Override
    public synchronized boolean isMemberExtentComplete(int edge, int layer, int slice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        return true;
    }

    @Override
    public synchronized Vector getQDRoverrideCollection() {
        return null;
    }
}

