/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseNode;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTreeBasedCubicDataAccess;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.Filter;
import oracle.dss.util.transform.InsertInfo;
import oracle.dss.util.transform.LayerAndMember;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.MemberWrapper;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.Row;
import oracle.dss.util.transform.SliceInsertInfo;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;
import oracle.dss.util.transform.total.AggLocation;
import oracle.dss.util.transform.total.TotalMember;
import oracle.dss.util.transform.total.TotalRow;
import oracle.javatools.annotations.Concealed;

@Deprecated
public abstract class EdgeTree
implements Cloneable {
    @Concealed
    protected BaseNode[] m_layers = null;
    @Concealed
    protected EdgeTreeNode m_root = null;
    @Concealed
    protected boolean m_locked = false;
    @Concealed
    protected int m_edge = -1;
    @Concealed
    protected boolean m_noCollapseLeaves = false;
    @Concealed
    protected String[][] m_layout = null;
    @Concealed
    protected boolean m_isOutline = false;
    protected EdgeTreeBasedCubicDataAccess m_da = null;
    @Concealed
    protected BaseProjection m_projection = null;
    @Concealed
    protected String m_measDim = null;
    @Concealed
    protected String[] m_measList = null;
    @Concealed
    protected long m_extent = -1L;
    private List<MemberWrapper> m_nullList = new ArrayList<MemberWrapper>();
    private List<String> m_sliceValues = new ArrayList<String>();
    private List<TreeNodeWrapperMemberInterface> m_sliceMemberVals = new ArrayList<TreeNodeWrapperMemberInterface>();
    private List<String> m_sliceMemberLayers = new ArrayList<String>();

    @Concealed
    public EdgeTree(BaseNode[] nodes, int edge, BaseProjection projection, String measDim, String[] measList, boolean noCollapseLeaves, EdgeTreeBasedCubicDataAccess da, long extent) {
        this.m_projection = projection;
        this.m_da = da;
        this.m_layers = nodes;
        this.m_edge = edge;
        this.m_extent = extent;
        this.m_layout = projection.getLayout();
        this.m_noCollapseLeaves = noCollapseLeaves;
        this.m_root = this.getRootEdgeTreeNode(this.m_extent);
        this.m_measDim = measDim;
        this.m_measList = measList;
    }

    public EdgeTreeBasedCubicDataAccess getDataAccess() {
        return this.m_da;
    }

    protected EdgeTreeNode getRootEdgeTreeNode(long extent) {
        return new EdgeTreeNode(this);
    }

    public Object clone(boolean caching) throws CloneNotSupportedException {
        EdgeTree et = (EdgeTree)super.clone();
        if (this.m_layers != null) {
            et.m_layers = new BaseNode[this.m_layers.length];
            for (int i = 0; i < this.m_layers.length; ++i) {
                if (this.m_layers[i] == null) continue;
                et.m_layers[i] = (BaseNode)this.m_layers[i].clone();
            }
        }
        et.m_root = (EdgeTreeNode)this.m_root.clone(et, null, caching);
        if (this.m_layout != null) {
            et.m_layout = (String[][])this.m_layout.clone();
        }
        et.m_da = this.m_da;
        et.m_measDim = this.m_measDim;
        et.m_measList = this.m_measList;
        return et;
    }

    protected void clearNodes() throws TransformException {
        if (this.m_root != null) {
            this.m_root.release();
        }
        this.m_root = this.getRootEdgeTreeNode(this.m_extent);
        this.unlock();
    }

    public void release() {
        this.m_layers = null;
        if (this.m_root != null) {
            this.m_root.release();
        }
        this.m_root = null;
        this.m_layout = null;
    }

    @Concealed
    protected boolean isNoCollapseLeaves() {
        return this.m_noCollapseLeaves;
    }

    @Concealed
    protected void setOutline(boolean outline) {
        this.m_isOutline = outline;
    }

    @Concealed
    protected boolean isOutline() {
        return this.m_isOutline;
    }

    private MemberInterface _getMember(String layer, String[] layers, Map<String, MemberInterface> sliceToInsert) {
        for (int i = 0; i < layers.length; ++i) {
            if (!layer.equals(layers[i])) continue;
            return sliceToInsert.get(layers[i]);
        }
        return null;
    }

    private QDR _getQDRToInsert(Map<String, MemberInterface> sliceToInsert, String[] layers, String dataLayer) throws TransformException {
        QDR qdrToInsert = new QDR();
        for (int i = 0; i < layers.length; ++i) {
            qdrToInsert.addDimMemberPair(layers[i], sliceToInsert.get(layers[i]).getValue());
        }
        return qdrToInsert;
    }

    private boolean _hasMeasure(Set<QDRInterface> qdrs, String dataLayer, String meas) {
        QDRMember currMeas = null;
        for (QDRInterface qdr : qdrs) {
            currMeas = qdr.getDimMember(dataLayer);
            if (currMeas == null || !meas.equals(currMeas.getData())) continue;
            return true;
        }
        return false;
    }

    private MemberInterface _getDataMemberInterface(MemberInterface[] dataMemberInterfaces, String value) throws TransformException {
        if (dataMemberInterfaces != null) {
            for (int i = 0; i < dataMemberInterfaces.length; ++i) {
                if (!value.equals(dataMemberInterfaces[i].getValue())) continue;
                return dataMemberInterfaces[i];
            }
        }
        return null;
    }

    public boolean insert(SliceInsertInfo sliceInsertInfo, String dataLayer, MemberInterface[] dataMemberInterfaces) throws TransformException {
        Map<String, MemberInterface> sliceToInsert = sliceInsertInfo.getSliceToInsert();
        String[] layers = TransformUtils.getLayersFromSliceToInsert(sliceToInsert);
        boolean bhaveMeas = false;
        for (int i = 0; i < layers.length; ++i) {
            if (bhaveMeas || !layers[i].equals(dataLayer)) continue;
            bhaveMeas = true;
        }
        Map[] sliceInsertArray = null;
        if (!bhaveMeas) {
            Map<QDRInterface, DataCellInterface> dataMap = sliceInsertInfo.getData();
            if (dataMap != null) {
                Set<QDRInterface> keySet = dataMap.keySet();
                if (dataMemberInterfaces == null) {
                    sliceInsertArray = new Map[keySet.size()];
                    QDRInterface[] qdrs = keySet.toArray(new QDRInterface[0]);
                    for (int i = 0; i < sliceInsertArray.length; ++i) {
                        sliceInsertArray[i] = new HashMap<String, MemberInterface>(sliceToInsert);
                        QDRMember qdrMem = qdrs[i].getDimMember(dataLayer);
                        String val = (String)(qdrMem != null ? qdrMem.getData() : null);
                        MemberInterface dmi = this._getDataMemberInterface(dataMemberInterfaces, val);
                        if (dmi == null) continue;
                        sliceInsertArray[i].put(dataLayer, dmi);
                    }
                } else {
                    ArrayList<HashMap<String, MemberInterface>> sliceInsertList = new ArrayList<HashMap<String, MemberInterface>>();
                    boolean before = sliceInsertInfo.isBefore();
                    for (int i = 0; i < dataMemberInterfaces.length; ++i) {
                        if (!this._hasMeasure(keySet, dataLayer, dataMemberInterfaces[i].getValue())) continue;
                        HashMap<String, MemberInterface> newQDR = new HashMap<String, MemberInterface>(sliceToInsert);
                        if (before) {
                            sliceInsertList.add(newQDR);
                        } else {
                            sliceInsertList.add(0, newQDR);
                        }
                        if (dataMemberInterfaces[i] == null) continue;
                        newQDR.put(dataLayer, dataMemberInterfaces[i]);
                    }
                    sliceInsertArray = sliceInsertList.toArray(new Map[0]);
                    if (sliceInsertArray.length > 0) {
                        layers = TransformUtils.getLayersFromSliceToInsert(sliceInsertArray[0]);
                    }
                }
            }
        } else {
            sliceInsertArray = new Map[]{sliceToInsert};
        }
        boolean bAdded = false;
        block3: for (int i = 0; i < sliceInsertArray.length; ++i) {
            QDR qdrToInsert = this._getQDRToInsert(sliceInsertArray[i], layers, dataLayer);
            EdgeTreeNode currNode = this.m_root;
            QDRMember member = null;
            EdgeTreeNode prevNode = currNode;
            for (int layer = 0; layer < this.m_layers.length; ++layer) {
                member = qdrToInsert.getDimMember(this.m_layers[layer].getName());
                if (member == null) {
                    if (layer <= 0) continue block3;
                    this._insert(prevNode, layer - 1, layers, sliceInsertInfo, sliceInsertArray[i], false);
                    bAdded = true;
                    continue block3;
                }
                Object data = member.getData();
                prevNode = currNode;
                if ((currNode = currNode.findNonAggregateChild(data != null ? data.toString() : null)) != null) continue;
                currNode = this._insert(prevNode, layer, layers, sliceInsertInfo, sliceInsertArray[i], false);
                bAdded = true;
            }
        }
        return bAdded;
    }

    private EdgeTreeNode _insert(EdgeTreeNode prevNode, int layer, String[] layers, SliceInsertInfo sliceInsertInfo, Map<String, MemberInterface> sliceToInsert, boolean alwaysAdd) throws TransformException {
        QDRMember insertMember;
        String layerName = this.m_layers[layer].getName();
        QDRMember qDRMember = insertMember = sliceInsertInfo.getInsertLocation() != null ? sliceInsertInfo.getInsertLocation().getDimMember(layerName) : null;
        String insertLocation = insertMember != null ? (insertMember.getData() != null ? insertMember.getData().toString() : null) : null;
        boolean before = sliceInsertInfo.isBefore();
        if (insertLocation == null) {
            if (!before) {
                EdgeTreeNode firstNode = prevNode.getFirstChild();
                insertLocation = firstNode != null ? firstNode.getMember().getValue() : null;
                before = true;
            } else {
                EdgeTreeNode lastNode = prevNode.getLastChild();
                insertLocation = lastNode != null ? lastNode.getMember().getValue() : null;
                before = false;
            }
        }
        EdgeTreeNode newNode = this.getEdgeTreeNode(false, prevNode, this._getMember(layerName, layers, sliceToInsert), null, layerName);
        prevNode.addChild(newNode, null, insertLocation, before, alwaysAdd, false, null);
        prevNode.clearSpan();
        newNode.clearStarts();
        prevNode.clearStarts();
        return newNode;
    }

    protected abstract EdgeTreeNode getEdgeTreeNode(boolean var1, EdgeTreeNode var2, MemberInterface var3, TreeNode var4, String var5) throws TransformException;

    public void delete(QDRLite qdr) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        String member = null;
        for (int layer = 0; layer < this.m_layers.length && (member = (String)qdr.getDimMember(this.m_layers[layer].getName())) != null; ++layer) {
            if ((currNode = currNode.findNonAggregateChild(member)) != null) continue;
            return;
        }
        if (currNode != null) {
            currNode.delete();
        }
    }

    public void invalidate(QDRLite qdr) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        String member = null;
        for (int layer = 0; layer < this.m_layers.length; ++layer) {
            member = (String)qdr.getDimMember(this.m_layers[layer].getName());
            if (member == null) {
                if (this.invalidate(currNode)) {
                    currNode.clearSpan();
                    currNode.clearStarts();
                }
                return;
            }
            if ((currNode = currNode.findNonAggregateChild(member)) != null) continue;
            return;
        }
    }

    private boolean invalidate(EdgeTreeNode node) throws TransformException {
        if (node.isRoot()) {
            return false;
        }
        node.invalidate();
        return true;
    }

    public boolean containsColumn(String col) {
        if (this.m_layers == null) {
            return false;
        }
        if (col == null) {
            return true;
        }
        return this.getLayer(col) != -1;
    }

    protected int getLayer(String layerName) {
        if (this.m_layers == null) {
            return -1;
        }
        for (int i = 0; i < this.m_layers.length; ++i) {
            if (!this.m_layers[i].getName().equals(layerName)) continue;
            return i;
        }
        return -1;
    }

    public void unlock() throws TransformException {
        this.m_locked = false;
        if (this.m_root != null) {
            this.m_root.unlock();
        }
    }

    public int getEdge() {
        return this.m_edge;
    }

    public int getLayerCount() {
        return this.m_layers == null ? 0 : this.m_layers.length;
    }

    protected void checkLayerRange(int layer) throws LayerOutOfRangeException {
        if (layer < 0 || layer >= this.getLayerCount()) {
            throw new LayerOutOfRangeException(layer, this.getLayerCount());
        }
    }

    public boolean unlock(String insertCol) throws TransformException {
        if (insertCol == null) {
            this.unlock();
            return true;
        }
        if (this.containsColumn(insertCol)) {
            this.unlock();
            return true;
        }
        return false;
    }

    public void lock() {
        this.m_locked = true;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public boolean isAsymmetric() throws TransformException {
        return this.m_root.isAsymmetric();
    }

    public long getExtent() throws TransformException {
        return this.m_root.getSpan();
    }

    public EdgeTreeNode getRoot() {
        return this.m_root;
    }

    public EdgeTreeNode[] findNode(String[] values, boolean treatNullAsAll) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        ArrayList<EdgeTreeNode> retNodes = new ArrayList<EdgeTreeNode>();
        this._findNode(currNode, values, 0, treatNullAsAll, retNodes);
        return retNodes.toArray(new EdgeTreeNode[0]);
    }

    private EdgeTreeNode _findNode(EdgeTreeNode currNode, String[] values, int layer, boolean treatNullAsAll, List<EdgeTreeNode> retNodes) throws TransformException {
        if (values.length <= layer) {
            retNodes.add(currNode);
            return currNode;
        }
        EdgeTreeNode[] nodes = currNode.findAllChildren(values[layer], treatNullAsAll);
        if (nodes == null) {
            return null;
        }
        ArrayList retVal = new ArrayList();
        EdgeTreeNode currChild = null;
        for (int i = 0; i < nodes.length; ++i) {
            if (layer + 1 < values.length) {
                currChild = this._findNode(nodes[i], values, layer + 1, treatNullAsAll, retNodes);
                if (currChild == null) continue;
                return currChild;
            }
            retNodes.add(nodes[i]);
        }
        return null;
    }

    public String[] getHPosValues(long[] hPos) throws TransformException {
        if (hPos == null) {
            return null;
        }
        String[] retVal = new String[hPos.length];
        EdgeTreeNode currNode = this.m_root;
        for (int i = 0; i < hPos.length && (currNode = currNode.getChild(hPos[i])) != null; ++i) {
            retVal[i] = currNode.getMember() != null ? currNode.getMember().getValue() : null;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSliceValues(long slice) throws TransformException {
        String[] retVal = null;
        List<String> list = this.m_sliceValues;
        synchronized (list) {
            this.m_sliceValues.clear();
            EdgeTreeNode currNode = this.m_root;
            while (currNode != null) {
                if ((currNode = currNode.findChild(slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES)) == null) continue;
                this.m_sliceValues.add(currNode.getMember().getValue());
            }
            retVal = this.m_sliceValues.toArray(new String[0]);
        }
        return retVal;
    }

    public boolean hasSlice(EdgeTreeNode node, long slice) throws TransformException {
        if (node == null) {
            return this.m_root.findChild(slice, EdgeTreeNode.GetSlice.GET_NO_SLICES) != null;
        }
        return node.findChild(slice, EdgeTreeNode.GetSlice.GET_NO_SLICES) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerAndMember getHPosMembers(long[] hPos) throws TransformException {
        if (hPos == null) {
            return null;
        }
        LayerAndMember retVal = null;
        List<TreeNodeWrapperMemberInterface> list = this.m_sliceMemberVals;
        synchronized (list) {
            this.m_sliceMemberVals.clear();
            this.m_sliceMemberLayers.clear();
            EdgeTreeNode currNode = this.m_root;
            for (int i = 0; i < hPos.length; ++i) {
                if (hPos[i] <= -1L) continue;
                if ((currNode = currNode.getChild(hPos[i])) == null) break;
                this.m_sliceMemberVals.add(currNode.getMember());
                this.m_sliceMemberLayers.add(currNode.getLayerName());
            }
            retVal = new LayerAndMember(this.m_sliceMemberLayers.toArray(new String[0]), this._getMemberArray(this.m_sliceMemberVals));
        }
        return retVal;
    }

    public MemberInterface[] getMembers(long slice) throws SliceOutOfRangeException, TransformException {
        int layerCount = this.getLayerCount();
        MemberInterface[] retVal = new MemberInterface[layerCount];
        EdgeTreeNode currNode = null;
        EdgeTreeNode prevNode = null;
        for (int l = 0; l < layerCount; ++l) {
            currNode = this.getNode(l, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
            if (currNode == prevNode) {
                return retVal;
            }
            retVal[l] = currNode.getMember();
            prevNode = currNode;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerAndMember getSliceMembers(long slice) throws SliceOutOfRangeException, TransformException {
        LayerAndMember retVal = null;
        List<TreeNodeWrapperMemberInterface> list = this.m_sliceMemberVals;
        synchronized (list) {
            this.m_sliceMemberVals.clear();
            this.m_sliceMemberLayers.clear();
            int layerCount = this.getLayerCount();
            EdgeTreeNode currNode = null;
            EdgeTreeNode prevNode = null;
            for (int l = 0; l < layerCount; ++l) {
                currNode = this.getNode(l, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
                if (currNode != prevNode) {
                    this.m_sliceMemberLayers.add(currNode.getLayerName());
                    this.m_sliceMemberVals.add(currNode.getMember());
                }
                prevNode = currNode;
            }
            retVal = new LayerAndMember(this.m_sliceMemberLayers.toArray(new String[0]), this._getMemberArray(this.m_sliceMemberVals));
        }
        return retVal;
    }

    private TreeNodeWrapperMemberInterface[] _getMemberArray(List<TreeNodeWrapperMemberInterface> members) {
        int size = members.size();
        TreeNodeWrapperMemberInterface[] retVal = new TreeNodeWrapperMemberInterface[size];
        for (int i = 0; i < size; ++i) {
            retVal[i] = members.get(i);
        }
        return retVal;
    }

    public int getDepth(int layer, long slice) throws TransformException {
        EdgeTreeNode node = this.m_root;
        int depth = 0;
        for (int physLayer = 0; node != null && (layer == -1 || layer != -1 && physLayer < layer); ++physLayer) {
            if ((node = node.findChild(slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES)) == null || node.getMember() == null) continue;
            ++depth;
        }
        return depth;
    }

    public long getSpan(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
        if (node != null) {
            return node.getSpan();
        }
        return 0L;
    }

    public long getStart(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
        if (node != null) {
            return node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1L);
        }
        return slice;
    }

    public EdgeTreeNode getNode(long[] hPos, int memberLayer, long hIndex) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        EdgeTreeNode temp = null;
        for (int i = 0; i <= memberLayer; ++i) {
            temp = currNode.getChild(i == memberLayer || hPos == null ? hIndex : hPos[i]);
            if (temp == null) {
                return currNode;
            }
            currNode = temp;
        }
        return currNode;
    }

    public EdgeTreeNode getNode(int layer, long slice, EdgeTreeNode.GetSlice get) throws TransformException, SliceOutOfRangeException {
        if (slice < 0L || slice >= this.getExtent()) {
            throw new SliceOutOfRangeException((int)slice, (int)this.getExtent());
        }
        EdgeTreeNode node = this.m_root;
        EdgeTreeNode lastNonNullNode = this.m_root;
        int l = 0;
        while (l <= layer && node != null) {
            lastNonNullNode = node;
            node = node.findChild(slice, get);
            if (l == layer) {
                ++l;
                continue;
            }
            l += this._getNodeSize(node);
        }
        if (node == null) {
            return lastNonNullNode.isRoot() ? null : lastNonNullNode;
        }
        while (node != null && node != this.m_root && node.getMember() == null) {
            node = node.getParent();
        }
        return node;
    }

    public int getLowestLayer(long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(this.getLayerCount() - 1, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
        return this.getLayer(node.getLayerName());
    }

    public EdgeTreeNode getFirstLeafNode() throws TransformException {
        EdgeTreeNode node = this.m_root;
        while (!node.isLeaf()) {
            node = node.getFirstChild();
        }
        return node;
    }

    public EdgeTreeNode getLastLeafNode() throws TransformException {
        EdgeTreeNode node = this.m_root;
        while (!node.isLeaf()) {
            node = node.getLastChild();
        }
        return node;
    }

    public EdgeTreeNode getPreviousLeafNode(long[] hPos) throws TransformException {
        EdgeTreeNode thisNode = this.getNode(hPos, hPos.length - 1, hPos[hPos.length - 1]);
        do {
            if (thisNode.getPosition() <= 0L || thisNode.getParent() == null) continue;
            return thisNode.getParent().getChild(thisNode.getPosition() - 1L).getLastLeaf();
        } while ((thisNode = thisNode.getParent()) != null);
        return null;
    }

    public EdgeTreeNode getNextLeafNode(long[] hPos) throws TransformException {
        EdgeTreeNode thisNode = this.getNode(hPos, hPos.length - 1, hPos[hPos.length - 1]);
        do {
            if (thisNode.getParent() == null || thisNode.getPosition() >= thisNode.getParent().getChildCount() - 1L) continue;
            EdgeTreeNode child = thisNode.getParent().getChild(thisNode.getPosition() + 1L);
            return child != null ? child.getFirstLeaf() : null;
        } while ((thisNode = thisNode.getParent()) != null);
        return null;
    }

    public int getStartLayer(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode node = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_TO_SLICE);
        return this.getLayer(node.getLayerName());
    }

    public int getNodeSize(int layer, long slice) throws TransformException, SliceOutOfRangeException {
        EdgeTreeNode thisNode = this.getNode(layer, slice, EdgeTreeNode.GetSlice.GET_ALL_SLICES);
        return this._getNodeSize(thisNode);
    }

    private int _getNodeSize(EdgeTreeNode thisNode) throws TransformException {
        int layerNum = this.getLayer(thisNode.getLayerName());
        EdgeTreeNode firstChild = thisNode.getFirstChild();
        if (firstChild == null) {
            return this.getLayerCount() - layerNum;
        }
        int nextLayer = this.getLayer(firstChild.getLayerName());
        return nextLayer - layerNum;
    }

    @Concealed
    public RowInfo[] addRow(Row rowData, String[] actualTableNodes, InsertInfo insertInfo, boolean alwaysAdd, boolean keepNulls, LayerSortInfo[] sortInfo) throws TransformException {
        EdgeTreeNode currNode = this.m_root;
        EdgeTreeNode temp = null;
        String layerName = null;
        if (this.m_layers == null) {
            return null;
        }
        boolean inserting = false;
        if (actualTableNodes == null) {
            return null;
        }
        MemberWrapper[] newNodeValues = new MemberWrapper[actualTableNodes.length];
        String dimName = null;
        boolean isInsertingTotalMember = false;
        TreeNodeWrapperMemberInterface member = null;
        for (int layer = 0; layer < actualTableNodes.length; ++layer) {
            member = null;
            layerName = actualTableNodes[layer];
            dimName = this.m_layers[layer].getName();
            if (layerName.equals(this.m_measDim) && !alwaysAdd) {
                int measCount = this.m_measList != null ? this.m_measList.length : 0;
                RowInfo[] retRowInfo = new RowInfo[measCount];
                MemberWrapper[][] measMembers = new MemberWrapper[measCount][];
                EdgeTreeNode subCurrent = null;
                for (int m = 0; m < measCount; ++m) {
                    isInsertingTotalMember = false;
                    member = null;
                    measMembers[m] = new MemberWrapper[newNodeValues.length];
                    System.arraycopy(newNodeValues, 0, measMembers[m], 0, newNodeValues.length);
                    inserting = false;
                    AddNodeStruct anstr = this._findAndAddNode(rowData, this.m_measList[m], dimName, currNode, true, inserting, insertInfo, alwaysAdd, layer == 0, keepNulls, this.m_measList[m], sortInfo);
                    subCurrent = anstr.m_node;
                    if (subCurrent == null) {
                        if (insertInfo == null && anstr.m_continue) continue;
                        return null;
                    }
                    measMembers[m][layer] = new MemberWrapper(subCurrent.getMember());
                    for (int l = layer + 1; l < actualTableNodes.length; ++l) {
                        member = null;
                        layerName = actualTableNodes[l];
                        if (!isInsertingTotalMember) {
                            isInsertingTotalMember = rowData.getMember(layerName) instanceof TotalMember ? !((TotalMember)rowData.getMember(layerName)).isReplacement() : false;
                            inserting = false;
                            anstr = this._findAndAddNode(rowData, layerName, this.m_layers[l].getName(), subCurrent, false, inserting, insertInfo, alwaysAdd, layer == 0, keepNulls, this.m_measList[m], sortInfo);
                            temp = anstr.m_node;
                            if (temp == null) {
                                if (insertInfo == null && anstr.m_continue) continue;
                                return null;
                            }
                            subCurrent = temp;
                            member = subCurrent.getMember();
                        } else if (!(rowData.getMember(layerName) instanceof TotalMember)) {
                            member = new TreeNodeWrapperMemberInterface(rowData.getMember(layerName));
                        }
                        if (member == null) continue;
                        measMembers[m][l] = new MemberWrapper(member);
                    }
                    retRowInfo[m] = new RowInfo(this._removeNulls(measMembers[m]), measMembers[m], this.m_measList[m]);
                }
                return retRowInfo;
            }
            if (!isInsertingTotalMember) {
                isInsertingTotalMember = rowData != null && rowData.getMember(layerName) instanceof TotalMember ? !((TotalMember)rowData.getMember(layerName)).isReplacement() : false;
                inserting = false;
                AddNodeStruct anstr = this._findAndAddNode(rowData, layerName, dimName, currNode, false, inserting, insertInfo, alwaysAdd, layer == 0, keepNulls, null, sortInfo);
                temp = anstr.m_node;
                if (temp == null) {
                    if (insertInfo == null && anstr.m_continue) continue;
                    return null;
                }
                currNode = temp;
                member = currNode.getMember();
            } else if (!(rowData.getMember(layerName) instanceof TotalMember)) {
                member = new TreeNodeWrapperMemberInterface(rowData.getMember(layerName));
            }
            if (member == null) continue;
            newNodeValues[layer] = new MemberWrapper(member);
        }
        if (this.m_layers.length == 0) {
            return null;
        }
        return new RowInfo[]{new RowInfo(this._removeNulls(newNodeValues), newNodeValues, null)};
    }

    private MemberWrapper[] _removeNulls(MemberWrapper[] newNodeValues) {
        if (newNodeValues != null && newNodeValues.length > 0) {
            this.m_nullList.clear();
            for (int i = 0; i < newNodeValues.length; ++i) {
                if (newNodeValues[i] == null) continue;
                this.m_nullList.add(newNodeValues[i]);
            }
            int size = this.m_nullList.size();
            if (newNodeValues.length != size) {
                newNodeValues = new MemberWrapper[size];
                for (int i = 0; i < newNodeValues.length; ++i) {
                    newNodeValues[i] = this.m_nullList.get(i);
                }
            }
        }
        return newNodeValues;
    }

    private AddNodeStruct _findAndAddNode(Row rowData, String colName, String dimName, EdgeTreeNode currNode, boolean isMeasure, boolean inserting, InsertInfo insertInfo, boolean alwaysAdd, boolean outerLayer, boolean keepNulls, Object currMeas, LayerSortInfo[] sortInfo) throws TransformException {
        QDRMember qdrmember;
        QDRInterface qdr;
        Object actualColumn = null;
        String insertLocationValue = null;
        boolean above = false;
        if (inserting) {
            colName = actualColumn;
        }
        MemberInterface member = null;
        if (isMeasure) {
            MemberInterface[] dataItems = this.m_projection.getDataItems();
            for (int i = 0; i < dataItems.length; ++i) {
                if (!colName.equals(dataItems[i].getValue())) continue;
                member = dataItems[i];
                break;
            }
        } else {
            MemberInterface memberInterface = member = rowData != null ? rowData.getMember(colName) : null;
        }
        if (member == null) {
            return new AddNodeStruct(null, false);
        }
        EdgeTreeNode childNode = null;
        if (inserting) {
            childNode = currNode.findChild(insertLocationValue);
        } else {
            String currValue = member.getValue();
            if (currValue == null && outerLayer && !keepNulls) {
                return new AddNodeStruct(null, false);
            }
            if (!alwaysAdd) {
                childNode = currNode.findChild(currValue);
            }
        }
        if (!inserting && insertInfo != null && (qdr = insertInfo.getQDR()) != null && (qdrmember = qdr.getDimMember(dimName)) != null && qdrmember.getData() != null && !qdrmember.getData().equals(childNode != null ? childNode.getMember().getValue() : null)) {
            return new AddNodeStruct(null, false);
        }
        if (childNode == null || inserting) {
            boolean replace = false;
            if (member instanceof TotalMember && !inserting) {
                if (this._replaceWithTotal((TotalRow)rowData, colName, currMeas)) {
                    replace = true;
                } else {
                    above = ((TotalRow)rowData).getAggLocation() == AggLocation.BEFORE;
                }
            }
            childNode = currNode.addChild(this.getEdgeTreeNode(false, currNode, member, null, dimName), null, inserting ? insertLocationValue : null, above, alwaysAdd, replace, this.getSortInfo(sortInfo, dimName));
        }
        return new AddNodeStruct(childNode, true);
    }

    private LayerSortInfo getSortInfo(LayerSortInfo[] sortInfo, String dimName) {
        if (sortInfo == null || dimName == null || this.m_layout == null) {
            return null;
        }
        for (int i = 0; i < sortInfo.length; ++i) {
            int edge = sortInfo[i].getEdge();
            int layer = sortInfo[i].getLayer();
            if (edge < 0 || layer < 0 || edge >= this.m_layout.length || this.m_layout[edge] == null || this.m_layout[edge].length <= layer || !dimName.equals(this.m_layout[edge][layer])) continue;
            return sortInfo[i];
        }
        return null;
    }

    private boolean _replaceWithTotal(TotalRow row, String column, Object currMeas) throws TransformException {
        Filter[] filters = row.getAggFilter(column);
        if (filters == null) {
            return false;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null || !filters[i].filter(row, this.m_measDim, currMeas)) continue;
            return false;
        }
        return true;
    }

    @Concealed
    public class RowInfo {
        protected MemberWrapper[] m_values = null;
        protected MemberWrapper[] m_fullValues = null;
        protected String m_measure = null;

        public RowInfo(MemberWrapper[] values, MemberWrapper[] fullValues, String measure) {
            this.m_values = values;
            this.m_fullValues = fullValues;
            this.m_measure = measure;
        }

        public MemberWrapper[] getValues() {
            return this.m_values;
        }

        public MemberWrapper[] getFullValues() {
            return this.m_fullValues;
        }

        public String[] getStringValues() {
            String[] retVal = new String[this.m_values.length];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = this.m_values[i].getValue();
            }
            return retVal;
        }

        public Object getValue(int i) {
            return this.getValues()[i];
        }

        public String getMeasure() {
            return this.m_measure;
        }

        public boolean hasMeasure() {
            return this.m_measure != null;
        }
    }

    protected class AddNodeStruct {
        protected EdgeTreeNode m_node = null;
        protected boolean m_continue = true;

        public AddNodeStruct(EdgeTreeNode node, boolean bContinue) {
            this.m_node = node;
            this.m_continue = bContinue;
        }
    }
}

