/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.Hashtable;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDRInterface;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.transform.BaseNode;
import oracle.dss.util.transform.BaseProjection;
import oracle.dss.util.transform.CommonTreeProjection;
import oracle.dss.util.transform.CubicDataAccess;
import oracle.dss.util.transform.DataCellInterface;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.LayerInterface;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.QDRLite;
import oracle.dss.util.transform.StackPack;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TransformUtils;
import oracle.dss.util.transform.TreeBasedEdgeTree;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeProjection;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public abstract class CommonTreeBasedCubicDataAccess
extends CubicDataAccess {
    protected Hashtable<String, int[]> m_layerEdge = new Hashtable();
    protected Hashtable<Integer, EdgeTreeNode> m_repeatSubtrees = null;
    protected Hashtable<Integer, Boolean> m_firstEdgeBreak = new Hashtable();

    public CommonTreeBasedCubicDataAccess() throws TransformException {
        super(null);
    }

    protected CommonTreeBasedCubicDataAccess(boolean qdrCaching) throws TransformException {
        super(null, qdrCaching);
    }

    @Override
    public synchronized void release() {
        this.m_layerEdge.clear();
        this.m_layerEdge = null;
        super.release();
    }

    @Override
    protected QDRLite generateQDR() throws TransformException {
        LayerInterface li = this.getDataLayerInterface();
        return new QDRLite(li != null ? li.getValue() : null);
    }

    protected abstract LayerInterface getDataLayerInterface();

    @Override
    protected String getDataLayer() throws TransformException {
        if (this.m_cachedDataLayer == null) {
            this.m_cachedDataLayer = this.getProjection().getDataLayer() == null ? null : this.getProjection().getDataLayer().getValue();
        }
        return this.m_cachedDataLayer;
    }

    @Override
    protected MemberInterface[] getDataItems() {
        if (this.m_cachedDataItems == null) {
            this.m_cachedDataItems = this.getProjection().getDataItems();
        }
        return this.m_cachedDataItems;
    }

    @Override
    protected String[][] getLayout() {
        if (this.m_cachedLayout == null) {
            this.m_cachedLayout = this.getProjection().getLayout();
        }
        return this.m_cachedLayout;
    }

    public synchronized void insert(TreeNode[] nodes) throws TransformException {
    }

    protected BaseNode[] _getLayers(int edge) {
        String[][] layout = this.getLayout();
        if (layout != null && layout.length > edge && layout[edge] != null) {
            BaseNode[] nodes = new BaseNode[layout[edge].length];
            for (int i = 0; i < layout[edge].length; ++i) {
                nodes[i] = new BaseNode(layout[edge][i]);
            }
            return nodes;
        }
        return null;
    }

    protected int getEdgeForLayer(TreeNode node) throws TransformException {
        int[] retVal = this._getLayerAndEdge(node);
        if (retVal != null) {
            return retVal[0];
        }
        return -1;
    }

    @Override
    protected abstract BaseProjection getProjection();

    private int[] _getLayerAndEdge(TreeNode node) throws TransformException {
        LayerInterface layer = node.getLayer();
        if (layer == null) {
            return null;
        }
        String layerName = layer.getValue();
        if (layerName == null) {
            return null;
        }
        int[] info = this.m_layerEdge.get(layerName);
        if (info != null) {
            return info;
        }
        String[][] layout = this.getLayout();
        int[] val = TransformUtils.getLayerAndEdge(layerName, layout);
        try {
            if (val != null) {
                this.m_layerEdge.put(layerName, val);
            }
        }
        catch (NullPointerException e) {
            throw new TransformException(e.getMessage(), e);
        }
        return val;
    }

    private boolean testStopBuild(int edge, long getToSlice, EdgeTreeNode node) throws TransformException {
        if (getToSlice == -1L) {
            return false;
        }
        return this.notAtSlice(node, edge, getToSlice);
    }

    protected void buildTree(TreeNode node, StackPack stacks, int edge, long getToSlice, EdgeTreeNode childrenCompleteNode, boolean[] alwaysAdd) throws TransformException {
        if (stacks.getStack().isEmpty()) {
            stacks.getStack().add(node.getFirstChild());
            stacks.getLastNodeStack().add(node);
            stacks.getParentStack().add(null);
            stacks.getIsSiblingNodeStack().add(false);
        }
        TreeNode t = null;
        EdgeTreeNode myParent = null;
        TreeNode lastNode = null;
        EdgeTreeNode etn = null;
        TreeNode nextSibling = null;
        boolean isSiblingNode = false;
        int index = -1;
        ProcessReturn pr = null;
        while (!stacks.getStack().isEmpty() && !this.testStopBuild(edge, getToSlice, childrenCompleteNode)) {
            index = stacks.getStack().size() - 1;
            t = stacks.getStack().get(index);
            lastNode = stacks.getLastNodeStack().get(index);
            myParent = stacks.getParentStack().get(index);
            isSiblingNode = stacks.getIsSiblingNodeStack().get(index);
            stacks.getStack().remove(index);
            stacks.getLastNodeStack().remove(index);
            stacks.getParentStack().remove(index);
            stacks.getIsSiblingNodeStack().remove(index);
            pr = this.process(t, lastNode, myParent, alwaysAdd);
            etn = pr.m_node;
            if (t != null && pr.m_continue) {
                nextSibling = t.getNextSibling();
                stacks.getStack().add(nextSibling);
                stacks.getLastNodeStack().add(null);
                stacks.getParentStack().add(myParent);
                stacks.getIsSiblingNodeStack().add(true);
            }
            if (t == null || !pr.m_continue) continue;
            stacks.getStack().add(t.getFirstChild());
            stacks.getLastNodeStack().add(t);
            stacks.getParentStack().add(etn);
            stacks.getIsSiblingNodeStack().add(false);
        }
    }

    private ProcessReturn process(TreeNode node, TreeNode lastNode, EdgeTreeNode myParent, boolean[] alwaysAdd) throws TransformException {
        if (node == null) {
            if (this.m_caching && lastNode != null) {
                QDRLite currQDR = new QDRLite();
                for (TreeNode currNode = lastNode; currNode != null; currNode = currNode.getParent()) {
                    if (currNode.getLayer() == null || currNode.getMember() == null || currNode.getLayer().getValue() == null || currNode.getMember().getValue() == null) continue;
                    currQDR.addDimMemberPair(currNode.getLayer().getValue(), currNode.getMember().getValue());
                }
                this.m_realQDRs.add(currQDR);
            }
            return new ProcessReturn(null, true);
        }
        TreeBasedEdgeTree et = this.getEdgeTree(node, -1L, false);
        if (myParent != null && et.getEdge() != myParent.getEdge()) {
            myParent = null;
        }
        myParent = myParent == null ? et.getRoot() : myParent;
        boolean storeTree = false;
        int edge = et.getEdge();
        int lastNodeEdge = lastNode != null ? this.getEdgeForLayer(lastNode) : edge;
        EdgeTreeNode newTreeNode = null;
        boolean repeats = this.repeats(edge, lastNodeEdge);
        boolean isFirstEdgeBreak = this.isFirstEdgeBreak(edge);
        if (repeats) {
            EdgeTreeNode repeatSubtree;
            if (isFirstEdgeBreak) {
                this.m_firstEdgeBreak.put(edge, false);
            }
            EdgeTreeNode edgeTreeNode = repeatSubtree = this.m_repeatSubtrees != null ? this.m_repeatSubtrees.get(edge) : null;
            if (repeatSubtree == null) {
                storeTree = true;
                newTreeNode = et.addNode(node, myParent, null, TransformUtils.alwaysAdd(alwaysAdd, edge), null);
                this._storeTree(storeTree, edge, myParent);
            } else {
                newTreeNode = repeatSubtree;
            }
        } else {
            newTreeNode = et.addNode(node, myParent, null, TransformUtils.alwaysAdd(alwaysAdd, edge), null);
        }
        return new ProcessReturn(newTreeNode, isFirstEdgeBreak ? true : !repeats);
    }

    private boolean isFirstEdgeBreak(int edge) {
        Boolean isFirst = this.m_firstEdgeBreak.get(edge);
        if (isFirst instanceof Boolean) {
            return isFirst;
        }
        return true;
    }

    private void _storeTree(boolean storeTree, int edge, EdgeTreeNode treeNode) {
        if (storeTree) {
            if (this.m_repeatSubtrees == null) {
                this.m_repeatSubtrees = new Hashtable();
            }
            this.m_repeatSubtrees.put(edge, treeNode);
        }
    }

    private boolean repeats(int edge, int lastNodeEdge) {
        BaseProjection proj = this.getProjection();
        if (lastNodeEdge == -1) {
            return false;
        }
        if (proj instanceof TreeProjection) {
            return edge != lastNodeEdge && ((TreeProjection)proj).repeats(edge);
        }
        return false;
    }

    private boolean notAtSlice(EdgeTreeNode node, int edge, long slice) throws TransformException {
        if (edge == -1 || slice == -1L) {
            return false;
        }
        try {
            EdgeTree et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                return et.hasSlice(node, slice);
            }
        }
        catch (EdgeOutOfRangeException e) {
            throw new TransformException(e.getMessage(), e);
        }
        return false;
    }

    protected abstract TreeBasedEdgeTree getEdgeTree(TreeNode var1, long var2, boolean var4) throws TransformException;

    @Override
    public synchronized int getLayerCount(int edge) throws EdgeOutOfRangeException {
        try {
            EdgeTree et = this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                return et.getLayerCount();
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return 0;
    }

    @Override
    public synchronized int getEdgeCount() {
        int count = this.getEdgeTreeCount();
        return count > 3 ? count : 3;
    }

    @Override
    protected LayerInterface getLayerInfo(int edge, int layer) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        try {
            TreeBasedEdgeTree et = (TreeBasedEdgeTree)this.getEdgeTree(edge, -1L, true);
            if (et != null) {
                return et.getLayerInfo(layer);
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        catch (SliceOutOfRangeException ex) {
            throw new TransformRuntimeException(ex.getMessage(), ex);
        }
        return null;
    }

    private class ProcessReturn {
        public EdgeTreeNode m_node = null;
        public boolean m_continue = true;

        public ProcessReturn(EdgeTreeNode node, boolean cont) {
            this.m_node = node;
            this.m_continue = cont;
        }
    }

    protected class TreeNodeImpl
    implements TreeNode {
        protected MemberInterface m_memberInt = null;
        protected LayerInterface m_layerInt = null;
        protected TreeNode m_sibling = null;
        protected TreeNode m_parent = null;

        public TreeNodeImpl(MemberInterface memberInt, LayerInterface layerInt, TreeNode parent) {
            this.m_memberInt = memberInt;
            this.m_layerInt = layerInt;
            this.m_parent = parent;
        }

        public void setSibling(TreeNode sibling) {
            this.m_sibling = sibling;
        }

        @Override
        public MemberInterface getMember() {
            return this.m_memberInt;
        }

        @Override
        public LayerInterface getLayer() {
            return this.m_layerInt;
        }

        @Override
        public TreeNode getFirstChild() {
            return null;
        }

        @Override
        public TreeNode getNextSibling() {
            return this.m_sibling;
        }

        @Override
        public TreeNode getParent() {
            return this.m_parent;
        }
    }

    protected class ImpliedMeasureTreeNode
    implements TreeNode {
        protected TreeNode m_node = null;
        protected TreeNode m_child = null;
        protected ImpliedMeasureTreeNode m_sibling = null;
        protected ImpliedMeasureTreeNode m_parent = null;
        protected ImpliedMeasureCommonTreeProjection m_proj = null;

        public ImpliedMeasureTreeNode(TreeNode node, ImpliedMeasureCommonTreeProjection proj) {
            this.m_node = node;
            this.m_proj = proj;
        }

        @Override
        public MemberInterface getMember() {
            return this.m_node.getMember();
        }

        @Override
        public LayerInterface getLayer() {
            return this.m_node.getLayer();
        }

        private TreeNode getMeasureChildren(TreeNode parent) {
            MemberInterface[] dataItems = this.m_proj.getDataItems();
            TreeNodeImpl retNode = null;
            TreeNodeImpl lastNode = null;
            TreeNodeImpl currNode = null;
            for (int i = 0; i < dataItems.length; ++i) {
                currNode = new TreeNodeImpl(dataItems[i], this.m_proj.getDataLayer(), parent);
                if (lastNode == null) {
                    retNode = currNode;
                } else {
                    lastNode.setSibling(currNode);
                }
                lastNode = currNode;
            }
            return retNode;
        }

        @Override
        public TreeNode getFirstChild() {
            if (this.m_child == null) {
                this.m_child = this.m_node.getFirstChild() == null ? this.getMeasureChildren(this.m_node) : new ImpliedMeasureTreeNode(this.m_node.getFirstChild(), this.m_proj);
            }
            return this.m_child;
        }

        @Override
        public TreeNode getNextSibling() {
            if (this.m_sibling == null && this.m_node.getNextSibling() != null) {
                this.m_sibling = new ImpliedMeasureTreeNode(this.m_node.getNextSibling(), this.m_proj);
            }
            return this.m_sibling;
        }

        @Override
        public TreeNode getParent() {
            if (this.m_parent == null && this.m_node.getParent() != null) {
                this.m_parent = new ImpliedMeasureTreeNode(this.m_node.getParent(), this.m_proj);
            }
            return this.m_parent;
        }
    }

    protected abstract class ImpliedMeasureCommonTreeProjection
    implements CommonTreeProjection {
        protected CommonTreeProjection m_proj = null;
        protected ImpliedMeasureTreeNode m_node = null;
        protected String[][] m_layout = null;
        protected int m_impliedMeasureEdge = -1;

        public ImpliedMeasureCommonTreeProjection(CommonTreeProjection proj) {
            this.m_proj = proj;
        }

        protected int getLastLayerEdge(String[][] layout, LayerInterface layerInt) throws TransformException {
            if (layerInt == null) {
                return -1;
            }
            for (int e = 0; e < layout.length; ++e) {
                if (layout[e] == null || !layout[e][layout[e].length - 1].equals(layerInt.getValue())) continue;
                return e;
            }
            return -1;
        }

        protected int walkTree(String[][] layout, TreeNode currNode) throws TransformException {
            if (currNode == null) {
                return -1;
            }
            int retLayerEdge = this.getLastLayerEdge(layout, currNode.getLayer());
            if (retLayerEdge > -1 && currNode.getFirstChild() == null) {
                return retLayerEdge;
            }
            retLayerEdge = this.walkTree(layout, currNode.getFirstChild());
            if (retLayerEdge == -1) {
                retLayerEdge = this.walkTree(layout, currNode.getNextSibling());
            }
            return retLayerEdge;
        }

        protected int getLength(String[][] str, int e) {
            if (str.length <= e || str[e] == null) {
                return 0;
            }
            return str[e].length;
        }

        protected abstract int findBottom() throws TransformException;

        protected abstract int getNewLength(String[][] var1);

        @Override
        public String[][] getLayout() {
            if (this.m_layout == null) {
                try {
                    int bottomLayerEdge = this.findBottom();
                    String[][] origLayout = this.m_proj.getLayout();
                    if (bottomLayerEdge == -1) {
                        this.m_layout = origLayout;
                    } else {
                        String[][] newLayout = new String[this.getNewLength(origLayout)][];
                        for (int e = 0; e < newLayout.length; ++e) {
                            if (e == bottomLayerEdge) {
                                newLayout[e] = new String[this.getLength(origLayout, e) + 1];
                                newLayout[e][newLayout[e].length - 1] = this.m_proj.getDataLayer().getValue();
                                this.m_impliedMeasureEdge = e;
                            } else {
                                newLayout[e] = new String[this.getLength(origLayout, e)];
                            }
                            for (int l = 0; l < this.getLength(origLayout, e); ++l) {
                                newLayout[e][l] = origLayout[e][l];
                            }
                        }
                        this.m_layout = newLayout;
                    }
                }
                catch (TransformException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return this.m_layout;
        }

        @Override
        public LayerInterface getDataLayer() {
            return this.m_proj.getDataLayer();
        }

        @Override
        public MemberInterface[] getDataItems() {
            return this.m_proj.getDataItems();
        }

        public DataCellInterface getData(QDRInterface qdr) {
            return this.m_proj.getData(qdr);
        }
    }
}

