/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class LocaleDealer {
    private String[] MonthAbbr = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] WeekDayInFull = new String[]{null, null, null, null, null, null, null};
    private String[] WeekDayInAbbr = new String[]{null, null, null, null, null, null, null};
    private String[] MonthNameInFull = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] AmPmUpperCase = new String[]{null, null};
    private String[] AmPmLowerCase = new String[]{null, null};
    private String[] AmPmUpperCaseWithPeriods = new String[]{null, null};
    private String[] AmPmLowerCaseWithPeriods = new String[]{null, null};
    private String[] ErasUpperCase = new String[]{null, null};
    private String[] ErasLowerCase = new String[]{null, null};
    private String[] ErasUpperCaseWithPeriods = new String[]{null, null};
    private String[] ErasLowerCaseWithPeriods = new String[]{null, null};
    private Locale theLocale = Locale.getDefault();
    private int weekDayFullMax = 0;
    private int weekDayAbbrMax = 0;
    private int monthFullMax = 0;
    private int monthAbbrMax = 0;
    private char m_groupingSeparator = (char)44;
    private ResourceBundle m_bundle = null;
    private static final String UTIL_BUNDLE = "oracle.dss.util.resource.UtilBundle";

    public LocaleDealer(Locale loc) {
        this.theLocale = loc;
        this._updateResourceBundle();
        this.fillWeekDays();
        this.fillMonth();
        this._fillAmPm();
        this._fillEras();
        this._fillGroupingSeparator();
    }

    public LocaleDealer() {
        this._updateResourceBundle();
        this.fillWeekDays();
        this.fillMonth();
        this._fillAmPm();
        this._fillEras();
        this._fillGroupingSeparator();
    }

    public String[] getWeekDayName(boolean inAbbreviation) {
        if (inAbbreviation) {
            return this.WeekDayInAbbr;
        }
        return this.WeekDayInFull;
    }

    public String[] getMonthName(boolean inAbbreviation) {
        if (inAbbreviation) {
            return this.MonthAbbr;
        }
        return this.MonthNameInFull;
    }

    String[] getAmPm(boolean lowerCase, boolean withPeriods) {
        if (lowerCase) {
            if (withPeriods) {
                return this.AmPmLowerCaseWithPeriods;
            }
            return this.AmPmLowerCase;
        }
        if (withPeriods) {
            return this.AmPmUpperCaseWithPeriods;
        }
        return this.AmPmUpperCase;
    }

    String[] getEras(boolean lowerCase, boolean withPeriods) {
        if (lowerCase) {
            if (withPeriods) {
                return this.ErasLowerCaseWithPeriods;
            }
            return this.ErasLowerCase;
        }
        if (withPeriods) {
            return this.ErasUpperCaseWithPeriods;
        }
        return this.ErasUpperCase;
    }

    char getGroupingSeparator() {
        return this.m_groupingSeparator;
    }

    private void fillWeekDays() {
        SimpleDateFormat fFull = new SimpleDateFormat("EEEE", this.theLocale);
        SimpleDateFormat fAbbr = new SimpleDateFormat("EEE", this.theLocale);
        boolean bForceGregCal = this.theLocale.getLanguage().compareTo("th") == 0 && this.theLocale.getCountry().compareTo("TH") == 0;
        GregorianCalendar cal = new GregorianCalendar(this.theLocale);
        if (bForceGregCal) {
            fFull.setCalendar(cal);
            fAbbr.setCalendar(cal);
        }
        for (int i = 0; i < 7; ++i) {
            cal = new GregorianCalendar(this.theLocale);
            cal.set(1998, 10, i + 1);
            Date theDate = cal.getTime();
            this.WeekDayInFull[i] = fFull.format(theDate);
            if (this.WeekDayInFull[i].length() > this.weekDayFullMax) {
                this.weekDayFullMax = this.WeekDayInFull[i].length();
            }
            this.WeekDayInAbbr[i] = fAbbr.format(theDate);
            if (this.WeekDayInAbbr[i].length() <= this.weekDayAbbrMax) continue;
            this.weekDayAbbrMax = this.WeekDayInAbbr[i].length();
        }
        this.adjustLength(this.WeekDayInFull, this.weekDayFullMax, 7);
        this.adjustLength(this.WeekDayInAbbr, this.weekDayAbbrMax, 7);
    }

    private void fillMonth() {
        boolean bForceGregCal;
        SimpleDateFormat fFull = new SimpleDateFormat("MMMM", this.theLocale);
        SimpleDateFormat fAbbr = new SimpleDateFormat("MMM", this.theLocale);
        GregorianCalendar cal = new GregorianCalendar(this.theLocale);
        boolean bl = bForceGregCal = this.theLocale.getLanguage().compareTo("th") == 0 && this.theLocale.getCountry().compareTo("TH") == 0;
        if (bForceGregCal) {
            fFull.setCalendar(cal);
            fAbbr.setCalendar(cal);
        }
        for (int i = 0; i < 12; ++i) {
            cal = new GregorianCalendar(1999, i, 1);
            Date theDate = cal.getTime();
            this.MonthNameInFull[i] = fFull.format(theDate);
            String language = "";
            if (this.theLocale != null) {
                language = this.theLocale.getLanguage();
            }
            if (language.equals("zh")) {
                this.MonthNameInFull[i] = Integer.toString(i + 1) + this.MonthNameInFull[i].substring(this.MonthNameInFull[i].length() - 1);
            }
            if (this.MonthNameInFull[i].length() > this.monthFullMax) {
                this.monthFullMax = this.MonthNameInFull[i].length();
            }
            this.MonthAbbr[i] = fAbbr.format(theDate);
            if (language.equals("zh")) {
                this.MonthAbbr[i] = Integer.toString(i + 1) + this.MonthAbbr[i].substring(this.MonthAbbr[i].length() - 1);
            }
            if (this.MonthAbbr[i].length() <= this.monthAbbrMax) continue;
            this.monthAbbrMax = this.MonthAbbr[i].length();
        }
        this.adjustLength(this.MonthNameInFull, this.monthFullMax, 12);
        this.adjustLength(this.MonthAbbr, this.monthAbbrMax, 12);
    }

    private void _fillAmPm() {
        this.AmPmUpperCase = new String[2];
        this.AmPmUpperCaseWithPeriods = new String[2];
        this.AmPmLowerCase = new String[2];
        this.AmPmLowerCaseWithPeriods = new String[2];
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.theLocale);
        String[] ampmString = dateFormatSymbols.getAmPmStrings();
        this.AmPmUpperCase[0] = ampmString[0];
        this.AmPmUpperCase[1] = ampmString[1];
        this.AmPmLowerCase[0] = ampmString[0].toLowerCase(this.theLocale);
        this.AmPmLowerCase[1] = ampmString[1].toLowerCase(this.theLocale);
        if (this.m_bundle != null) {
            this.AmPmUpperCaseWithPeriods[0] = this.m_bundle.getString("A.M.");
            this.AmPmUpperCaseWithPeriods[1] = this.m_bundle.getString("P.M.");
            this.AmPmLowerCaseWithPeriods[0] = this.m_bundle.getString("a.m.");
            this.AmPmLowerCaseWithPeriods[1] = this.m_bundle.getString("p.m.");
        } else {
            this.AmPmUpperCaseWithPeriods[0] = "A.M.";
            this.AmPmUpperCaseWithPeriods[1] = "P.M.";
            this.AmPmLowerCaseWithPeriods[0] = "a.m.";
            this.AmPmLowerCaseWithPeriods[1] = "p.m.";
        }
    }

    private void _fillEras() {
        this.ErasUpperCase = new String[2];
        this.ErasUpperCaseWithPeriods = new String[2];
        this.ErasLowerCase = new String[2];
        this.ErasLowerCaseWithPeriods = new String[2];
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.theLocale);
        String[] eraString = dateFormatSymbols.getEras();
        this.ErasUpperCase[0] = eraString[0];
        this.ErasUpperCase[1] = eraString[1];
        this.ErasLowerCase[0] = eraString[0].toLowerCase(this.theLocale);
        this.ErasLowerCase[1] = eraString[1].toLowerCase(this.theLocale);
        if (this.m_bundle != null) {
            this.ErasUpperCaseWithPeriods[0] = this.m_bundle.getString("B.C.");
            this.ErasUpperCaseWithPeriods[1] = this.m_bundle.getString("A.D.");
            this.ErasLowerCaseWithPeriods[0] = this.m_bundle.getString("b.c.");
            this.ErasLowerCaseWithPeriods[1] = this.m_bundle.getString("a.d.");
        } else {
            this.ErasUpperCaseWithPeriods[0] = "B.C.";
            this.ErasUpperCaseWithPeriods[1] = "A.D.";
            this.ErasLowerCaseWithPeriods[0] = "b.c.";
            this.ErasLowerCaseWithPeriods[1] = "a.d.";
        }
    }

    private void _fillGroupingSeparator() {
        DecimalFormatSymbols dfs = null;
        dfs = this.theLocale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(this.theLocale);
        this.m_groupingSeparator = dfs.getGroupingSeparator();
    }

    private void adjustLength(String[] arr, int maxLen, int arrLen) {
        for (int i = 0; i < arrLen; ++i) {
            int theLen = arr[i].length();
            if (theLen >= maxLen) continue;
            int diff = maxLen - theLen;
            for (int j = 0; j < diff; ++j) {
                int n = i;
                arr[n] = arr[n] + " ";
            }
        }
    }

    private void _updateResourceBundle() {
        try {
            this.m_bundle = this.theLocale != null ? ResourceBundle.getBundle(UTIL_BUNDLE, this.theLocale) : ResourceBundle.getBundle(UTIL_BUNDLE);
        }
        catch (MissingResourceException e) {
            this.m_bundle = null;
        }
    }
}

