/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.dss.util.Collection;
import oracle.dss.util.UpdatableBag;

public class UpdatableBagImpl
implements UpdatableBag {
    protected Vector m_objects = null;
    protected int m_initialCapacity;
    protected int m_capacityIncrement;

    public UpdatableBagImpl() {
        this.m_initialCapacity = -1;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector();
    }

    public UpdatableBagImpl(int initialCapacity) {
        this.m_initialCapacity = initialCapacity;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector(this.m_initialCapacity);
    }

    public UpdatableBagImpl(int initialCapacity, int capacityIncrement) {
        this.m_initialCapacity = initialCapacity;
        this.m_capacityIncrement = capacityIncrement;
        this.m_objects = new Vector(this.m_initialCapacity, this.m_capacityIncrement);
    }

    @Override
    public Collection duplicate() {
        Collection c = null;
        try {
            c = (Collection)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object c = super.clone();
        ((UpdatableBagImpl)c).m_objects = (Vector)this.m_objects.clone();
        return c;
    }

    @Override
    public int size() {
        return this.m_objects.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_objects.isEmpty();
    }

    @Override
    public boolean includes(Object element) {
        return this.m_objects.contains(element);
    }

    @Override
    public Enumeration elements() {
        return this.m_objects.elements();
    }

    @Override
    public void clear() {
        this.m_objects.removeAllElements();
    }

    @Override
    public void add(Object element) {
        this.m_objects.addElement(element);
    }

    @Override
    public void addIfAbsent(Object element) {
        if (this.m_objects.contains(element)) {
            this.m_objects.addElement(element);
        }
    }

    @Override
    public void removeOneOf(Object element) {
        this.m_objects.removeElement(element);
    }

    @Override
    public void exclude(Object element) {
        while (this.m_objects.contains(element)) {
            this.m_objects.removeElement(element);
        }
    }

    @Override
    public Object take() throws NoSuchElementException {
        Object o = this.m_objects.firstElement();
        this.m_objects.removeElementAt(0);
        return o;
    }

    @Override
    public void addElements(Enumeration e) {
        while (e.hasMoreElements()) {
            this.add(e.nextElement());
        }
    }

    @Override
    public void removeElements(Enumeration e) {
        while (e.hasMoreElements()) {
            this.removeOneOf(e.nextElement());
        }
    }

    public static void main(String[] argv) {
        UpdatableBagImpl c = new UpdatableBagImpl();
        c.add(new Object());
        c.add(new Object());
        System.out.println(c.size());
        Enumeration e = c.elements();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
    }
}

