/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dss.util.MemberContext;
import oracle.dss.util.Utility;

public class RuleMemberContext
implements MemberContext {
    protected int m_dimIndex;
    protected String m_dimension;
    protected List m_members;

    public RuleMemberContext() {
    }

    public RuleMemberContext(String dimension) {
        this.m_dimension = dimension;
        this.m_members = new ArrayList();
    }

    @Override
    public String getDimID() {
        return this.m_dimension;
    }

    public void setDimIndex(int dimIndex) {
        this.m_dimIndex = dimIndex;
    }

    @Override
    public int getDimIndex() {
        return this.m_dimIndex;
    }

    @Override
    public String getMemberID(int memberIndex) {
        return (String)this.m_members.get(memberIndex);
    }

    @Override
    public int getMemberCount() {
        return this.m_members.size();
    }

    @Override
    public int getMemberIndex(String member) {
        for (int i = 0; i < this.m_members.size(); ++i) {
            String entry = (String)this.m_members.get(i);
            if (!entry.equals(member)) continue;
            return i;
        }
        this.m_members.add(member);
        return this.m_members.size() - 1;
    }

    public static int addDimensionMembers(List dimMembers, String dimString) {
        RuleMemberContext dimension = new RuleMemberContext(dimString);
        for (int i = 0; i < dimMembers.size(); ++i) {
            MemberContext entry = (MemberContext)dimMembers.get(i);
            if (!entry.equals(dimension)) continue;
            return i;
        }
        int dimIndex = dimMembers.size();
        dimMembers.add(dimension);
        dimension.setDimIndex(dimIndex);
        return dimIndex;
    }

    @Override
    public boolean equals(MemberContext member) {
        return Utility.compareObj(member.getDimID(), this.getDimID());
    }

    public boolean equals(Object o) {
        if (o instanceof RuleMemberContext) {
            RuleMemberContext entry = (RuleMemberContext)o;
            return Utility.compareObj(entry.getDimID(), this.getDimID());
        }
        return false;
    }

    public void setStateString(String dimensionMembers, boolean isCheckpoint) {
        String strMembers = Utility.unescapeStateString(dimensionMembers, ESCAPE_CHARS, null, '-');
        int separator = strMembers.indexOf(DIMENSION_SEPARATOR_S);
        if (separator == -1) {
            return;
        }
        this.m_dimension = strMembers.substring(0, separator);
        strMembers = strMembers.substring(separator + 1);
        this.m_members = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(strMembers, MEMBER_SEPARATOR_S);
        while (tokenizer.hasMoreTokens()) {
            this.m_members.add(tokenizer.nextToken());
        }
    }

    public String getStateString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Utility.escapeStateString(this.getDimID(), ESCAPE_CHARS, null, '-'));
        String separator = DIMENSION_SEPARATOR_S;
        for (int i = 0; i < this.m_members.size(); ++i) {
            buffer.append(separator);
            separator = MEMBER_SEPARATOR_S;
            buffer.append(Utility.escapeStateString((String)this.m_members.get(i), ESCAPE_CHARS, null, '-'));
        }
        return buffer.toString();
    }

    public static List deserializeDimMembersContext(String dimMemberPairs) {
        ArrayList<RuleMemberContext> list = new ArrayList<RuleMemberContext>();
        if (dimMemberPairs != null && dimMemberPairs.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(dimMemberPairs, ENTRY_SEPARATOR_S);
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                RuleMemberContext context = new RuleMemberContext();
                context.setDimIndex(list.size());
                list.add(context);
                context.setStateString(entry, false);
            }
        }
        return list;
    }

    public static String serializeDimMembersContext(List dimMembers) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < dimMembers.size(); ++i) {
            Object entry = dimMembers.get(i);
            if (!(entry instanceof RuleMemberContext)) continue;
            buffer.append(((RuleMemberContext)entry).getStateString());
            if (i >= dimMembers.size() - 1) continue;
            buffer.append(ENTRY_SEPARATOR_S);
        }
        return buffer.toString();
    }
}

