/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DefaultMetadataPrinter;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.MetadataPrinter;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;

public class DumpContext {
    public static void dumpMetadata(PrintWriter pw, DataAccess da, int edge, MetadataMap map) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpMetadata(pw, da, edge, map, new DefaultMetadataPrinter());
    }

    public static void dumpResults(PrintWriter pw, DataAccess da, MetadataMap map) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpResults(pw, da, map, new DefaultMetadataPrinter());
    }

    public static void dumpCurrentIndex(PrintWriter pw, DataAccess da, int edge, int index, MetadataMap map) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCurrentIndex(pw, da, edge, index, map, new DefaultMetadataPrinter());
    }

    public static void dumpEdgeCursor(PrintWriter pw, DataAccess da, int edge) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpEdgeCursor(pw, da, edge, new DefaultMetadataPrinter());
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, String dataType) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, dataType, new DefaultMetadataPrinter());
    }

    public static void dumpEdge(PrintWriter pw, DataAccess da, int edge) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpEdge(pw, da, edge, new DefaultMetadataPrinter());
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, new DefaultMetadataPrinter());
    }

    public static void dumpResults(PrintWriter pw, DataAccess da, MetadataMap map, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpResults(pw, da, map, "value", mp);
    }

    public static void dumpResults(PrintWriter pw, DataAccess da, MetadataMap map, String type, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, "dataValue", type, mp);
        DumpContext.dumpMetadata(pw, da, 2, map, mp);
    }

    public static void dumpMetadata(PrintWriter pw, DataAccess da, int edge, MetadataMap map, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (da != null) {
            String[] types = (String[])Utility.copyVectorToArray(map);
            int dimcount = da.getLayerCount(edge);
            for (int dim = 0; dim < dimcount; ++dim) {
                pw.println(mp.getMetadataName(DumpContext._getString(da.getLayerMetadata(edge, dim, "layerName")), mp.getDimensionType()));
                int[] dimArray = new int[dim + 1];
                int count = da.getMemberSiblingCount(edge, dimArray, dim);
                for (int value = 0; value < count; ++value) {
                    for (int type = 0; type < types.length - 1; ++type) {
                        pw.print(mp.getMetadataName(DumpContext._getString(da.getMemberMetadata(edge, dimArray, dim, value, types[type])), mp.getValueType()) + ",");
                    }
                    String obj = mp.getMetadataName(DumpContext._getString(da.getMemberMetadata(edge, dimArray, dim, value, types[types.length - 1])), mp.getValueType());
                    if (obj != null) {
                        pw.println(obj.toString());
                        continue;
                    }
                    pw.println();
                }
                pw.println();
            }
        }
    }

    public static void dumpEdge(PrintWriter pw, DataAccess da, int edge, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        pw.println("------------DataAccess edge member contents start-----------");
        int layerCount = da.getLayerCount(edge);
        for (int i = 0; i < layerCount; ++i) {
            pw.print(mp.getMetadataName(DumpContext._getString(da.getLayerMetadata(edge, i, "layerName")), mp.getDimensionType()) + ",");
        }
        pw.println();
        pw.println();
        int[] depthIndex = da.getFirstHPos(edge);
        do {
            if (depthIndex == null) continue;
            for (int i = 0; i < depthIndex.length; ++i) {
                if (depthIndex[i] != -1) {
                    pw.print(mp.getMetadataName(DumpContext._getString(da.getMemberMetadata(edge, depthIndex, i, depthIndex[i], "value")), mp.getValueType()));
                }
                pw.print(",");
            }
            depthIndex = da.getNextHPos(edge, depthIndex);
            pw.println();
        } while (depthIndex != null);
        pw.println();
        pw.println();
        pw.println("------------DataAccess edge member contents end-----------");
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, String dataType, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, dataType, "value", mp);
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, String dataType, String metadataType, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        pw.println("---------------DataAccess cursor start---------------");
        if (da != null) {
            pw.println("Page values:");
            DumpContext.dumpCurrentIndex(pw, da, 2, da.getEdgeCurrentSlice(2), new MetadataMap(new String[]{"value"}), mp);
            pw.println();
            pw.println("Column header:");
            int edge = 0;
            DumpContext.dumpEdgeCursor(pw, da, edge, da.getEdgeExtent(edge), metadataType, mp);
            pw.println();
            pw.println("Row header:");
            edge = 1;
            DumpContext.dumpEdgeCursor(pw, da, edge, da.getEdgeExtent(edge), metadataType, mp);
            pw.println();
            Object val = null;
            int rowExtent = da.getEdgeExtent(1);
            for (int row = 0; row < rowExtent; ++row) {
                int colExtent = da.getEdgeExtent(0);
                for (int column = 0; column < colExtent; ++column) {
                    val = da.getValue(row, column, dataType);
                    try {
                        Class bvfhClass = Utility.loadClass("oracle.dss.util.format.BaseViewFormatHandle");
                        if (bvfhClass.isInstance(val)) {
                            Method m = bvfhClass.getMethod("getBaseViewFormat", null);
                            val = m.invoke(val, null);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (val != null && !mp.outputAsNA(val)) {
                        pw.print(val.toString() + ",");
                        continue;
                    }
                    pw.print("NA,");
                }
                pw.println();
            }
        }
        pw.println("----------------DataAccess cursor end----------------");
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, "dataValue");
    }

    public static void dumpCursor(PrintWriter pw, DataAccess da, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCursor(pw, da, "dataValue", mp);
    }

    public static void dumpEdgeCursor(PrintWriter pw, DataAccess da, int edge, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        DumpContext.dumpEdgeCursor(pw, da, edge, da.getEdgeExtent(edge), "value", mp);
    }

    public static void dumpEdgeCursor(PrintWriter pw, DataAccess da, int edge, int count, String type, MetadataPrinter mp) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (pw != null) {
            pw.println("------------DataAccess edge metadata start-----------");
        }
        if (da != null) {
            Object obj = null;
            int dimCount = da.getLayerCount(edge);
            for (int depth = 0; depth < dimCount; ++depth) {
                obj = da.getLayerMetadata(edge, depth, "layerName");
                if (pw != null) {
                    pw.println(mp.getMetadataName(DumpContext._getString(obj), mp.getDimensionType()));
                }
                for (int index = 0; index < count; index += DumpContext._calcSpan(da, edge, depth, index)) {
                    int start2;
                    int start1;
                    if (depth > 0 && index > 0 && (start1 = da.getMemberStartSlice(edge, depth - 1, index)) == (start2 = da.getMemberStartSlice(edge, depth, index)) && pw != null) {
                        pw.print(" | ");
                    }
                    if (da.getMemberStartLayer(edge, depth, index) == depth) {
                        obj = da.getMemberMetadata(edge, depth, index, type);
                        if (pw == null) continue;
                        pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()) + ",");
                        continue;
                    }
                    if (pw == null) continue;
                    pw.print("----- ");
                }
                if (pw == null) continue;
                pw.println();
            }
        }
        if (pw != null) {
            pw.println("-------------DataAccess edge metadata end------------");
        }
    }

    public static void dumpCurrentIndex(PrintWriter pw, DataAccess da, int edge, int index, MetadataMap map, MetadataPrinter mp) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (da != null) {
            Object obj = null;
            int pageDimCount = da.getLayerCount(edge);
            if (pageDimCount == 0) {
                return;
            }
            if (da.getEdgeCurrentSlice(edge) >= da.getEdgeExtent(edge)) {
                return;
            }
            int[] context = da.getMemberHPos(edge, pageDimCount - 1, da.getEdgeCurrentSlice(edge));
            for (int page = 0; page < pageDimCount; ++page) {
                obj = da.getLayerMetadata(edge, page, "layerName");
                if (pw != null) {
                    pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getDimensionType()) + ": ");
                }
                if (context == null) {
                    if (pw == null) continue;
                    pw.println();
                    continue;
                }
                obj = da.getMemberMetadata(edge, context, page, context[page], map.getTypeAt(0));
                if (pw == null) continue;
                pw.println(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()));
            }
        }
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, da.getEdgeExtent(0), da.getEdgeExtent(1), "value", mp);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, "value", mp);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, MetadataPrinter mp) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, type, mp, null);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, MetadataPrinter mp, DecimalFormat df) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, type, false, mp, df);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, boolean outline, MetadataPrinter mp, DecimalFormat df) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        DumpContext.dumpCrosstabResults(pw, da, colBound, rowBound, type, "dataValue", outline, mp, df);
    }

    public static void dumpCrosstabResults(PrintWriter pw, DataAccess da, int colBound, int rowBound, String type, String dataType, boolean outline, MetadataPrinter mp, DecimalFormat df) throws ColumnOutOfRangeException, RowOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (pw != null) {
            pw.println("---------------DataAccess crosstab body start---------------");
        }
        if (da != null) {
            if (pw != null) {
                pw.println("Page values:");
            }
            DumpContext.dumpCurrentIndex(pw, da, 2, da.getEdgeCurrentSlice(2), new MetadataMap(new String[]{type}), mp);
            if (pw != null) {
                pw.println();
            }
            if (pw != null) {
                pw.println("Column header:");
            }
            int edge = 0;
            DumpContext.dumpEdgeCursor(pw, da, edge, colBound, type, mp);
            if (pw != null) {
                pw.println();
            }
            Object val = null;
            Object obj = null;
            int rowExtent = rowBound;
            for (int row = 0; row < rowExtent; ++row) {
                int layers = da.getLayerCount(1);
                for (int depth = 0; depth < layers; ++depth) {
                    if (outline) {
                        int startLayer = da.getSliceOutlineLayer(1, row);
                        if (startLayer == depth) {
                            obj = da.getMemberMetadata(1, depth, row, type);
                            if (pw == null) break;
                            pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()) + " | ");
                            break;
                        }
                        if (pw == null) continue;
                        pw.print("     ");
                        continue;
                    }
                    if (da.getMemberStartLayer(1, depth, row) == depth) {
                        obj = da.getMemberMetadata(1, depth, row, type);
                        if (pw == null) continue;
                        pw.print(mp.getMetadataName(DumpContext._getString(obj), mp.getValueType()) + " | ");
                        continue;
                    }
                    if (pw == null) continue;
                    pw.print("----- ");
                }
                int colExtent = colBound;
                for (int column = 0; column < colExtent; ++column) {
                    val = da.getValue(row, column, dataType);
                    if (val != null && !mp.outputAsNA(val)) {
                        if (df != null && val instanceof Number) {
                            if (pw == null) continue;
                            pw.print(df.format(val) + ",");
                            continue;
                        }
                        if (pw == null) continue;
                        pw.print(val.toString() + ",");
                        continue;
                    }
                    if (pw == null) continue;
                    pw.print("NA,");
                }
                if (pw == null) continue;
                pw.println();
            }
        }
        if (pw != null) {
            pw.println("----------------DataAccess crosstab body end----------------");
        }
    }

    private static int _calcSpan(DataAccess da, int edge, int depth, int index) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        if (depth == da.getLayerCount(edge) - 1) {
            return 1;
        }
        return da.getMemberExtent(edge, depth, index);
    }

    private static String _getString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }
}

