/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules.discriminator;

import oracle.dss.rules.discriminator.DiscriminatorXML;

public abstract class ValueDiscriminator
implements DiscriminatorXML {
    private static final long serialVersionUID = 1L;
    protected int m_relOperator = 0;
    public static final int EQ = 0;
    public static final int LT = 1;
    public static final int LE = 2;
    public static final int GT = 3;
    public static final int GE = 4;
    public static final int NE = 5;
    protected static final String a_relOperator = "relOp";
    protected static final String eq = "EQ";
    protected static final String le = "LE";
    protected static final String lt = "LT";
    protected static final String ge = "GE";
    protected static final String gt = "GT";
    protected static final String ne = "NE";
    protected static final String s_relOperator = "r";

    public ValueDiscriminator() {
    }

    public ValueDiscriminator(int relOp) {
        this.m_relOperator = relOp;
    }

    @Override
    public abstract Object clone();

    public int getRelOperator() {
        return this.m_relOperator;
    }

    public void setRelOperator(int relOp) {
        if (relOp < 0 || relOp > 5) {
            return;
        }
        this.m_relOperator = relOp;
    }

    protected int convertRelOperatorToInt(String rel) {
        if (rel.equals(eq)) {
            return 0;
        }
        if (rel.equals(lt)) {
            return 1;
        }
        if (rel.equals(le)) {
            return 2;
        }
        if (rel.equals(gt)) {
            return 3;
        }
        if (rel.equals(ge)) {
            return 4;
        }
        if (rel.equals(ne)) {
            return 5;
        }
        return 0;
    }

    protected String convertRelOperatorToString(int rel) {
        String str = eq;
        switch (rel) {
            case 0: {
                str = eq;
                break;
            }
            case 1: {
                str = lt;
                break;
            }
            case 2: {
                str = le;
                break;
            }
            case 3: {
                str = gt;
                break;
            }
            case 4: {
                str = ge;
                break;
            }
            case 5: {
                str = ne;
            }
        }
        return str;
    }
}

