/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.rules;

import java.util.Hashtable;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.MergeableXML;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleContext;
import oracle.dss.rules.discriminator.ComponentTypeDiscriminator;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.DateValueDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.DiscriminatorXML;
import oracle.dss.rules.discriminator.NumberValueDiscriminator;
import oracle.dss.rules.discriminator.PositionDiscriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.rules.discriminator.StringValueDiscriminator;
import oracle.dss.rules.discriminator.TotalsDiscriminator;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DiscriminatorRule
extends Rule {
    private static final long serialVersionUID = 1L;
    private Discriminator m_discriminator;
    public static final String a_type = "type";
    private long d_id = -1L;
    protected Hashtable m_context = null;
    protected static final String NAME_DISCRULE = "DiscRule";
    private static final String NAME_ID = "id";
    private static final String NAME_DISC = "Disc";
    private static final String NAME_MERGEABLE = "Mergeable";
    private static final String NAME_VIEWSTYLE = "ViewStyle";
    private static final String NAME_VIEWFORMAT = "ViewFormat";
    private static final String NAME_GRAPHSTYLE = "GraphStyle";
    private static final String viewStylePath = "oracle.dss.dataView.managers.ViewStyle";
    private static final String viewFormatPath = "oracle.dss.dataView.managers.ViewFormat";
    private static final String graphStylePath = "oracle.dss.graph.managers.GraphStyle";

    public DiscriminatorRule() {
        super(null);
        this.m_discriminator = null;
    }

    public DiscriminatorRule(Discriminator discriminator, Mergeable mergeable) {
        super(mergeable);
        this.m_discriminator = (Discriminator)(discriminator != null ? discriminator.clone() : discriminator);
    }

    @Override
    public Object clone() {
        DiscriminatorRule rule = new DiscriminatorRule(this.m_discriminator, this.m_mergeable);
        rule.setID(this.getID());
        return rule;
    }

    @Override
    public boolean applies(RuleContext context, Mergeable target) {
        if (this.m_discriminator == null) {
            return false;
        }
        return this.m_discriminator.applies(context);
    }

    public Discriminator getDiscriminator() {
        return this.m_discriminator;
    }

    public void setDiscriminator(Discriminator discriminator) {
        this.m_discriminator = (Discriminator)(discriminator != null ? discriminator.clone() : discriminator);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DiscriminatorRule)) {
            return false;
        }
        DiscriminatorRule rule = (DiscriminatorRule)o;
        if (this.m_discriminator == null ? rule.getDiscriminator() != null : !this.m_discriminator.equals(rule.getDiscriminator())) {
            return false;
        }
        return !(this.m_mergeable == null ? rule.getFixedMergeable() != null : !this.m_mergeable.equals(rule.getFixedMergeable()));
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
        if (this.getDiscriminator() instanceof QDRDiscriminator) {
            ((QDRDiscriminator)this.getDiscriminator()).setContext(this.m_context);
        } else if (this.getDiscriminator() instanceof CompositeDiscriminator) {
            ((CompositeDiscriminator)this.getDiscriminator()).setContext(this.m_context);
        }
    }

    public boolean setXML(ObjectNode node, ComponentTypeConverter converter, String version, int reset) {
        String undefinedRulePath;
        boolean result;
        ObjectNode XML = node;
        ObjectNode XML1 = null;
        PropertyNode idNode = node.getProperty(NAME_ID);
        if (idNode != null) {
            this.setID(idNode.getValueAsLong());
        }
        if ((XML1 = node.getPropertyValueAsObjectNode(NAME_DISC, true)) == null) {
            return true;
        }
        PropertyNode tempNode = XML1.getProperty("CompTypeDisc");
        if (tempNode != null) {
            this.setDiscriminator(new ComponentTypeDiscriminator(converter.convertComponentTypeToInteger(tempNode.getValueAsString())));
        } else {
            ObjectNode discriminator = XML1.getPropertyValueAsObjectNode();
            if (discriminator != null) {
                if (discriminator.getName().equals("ComposDisc")) {
                    CompositeDiscriminator cDisc = new CompositeDiscriminator();
                    if (this.m_context != null) {
                        cDisc.setContext(this.m_context);
                    }
                    boolean result2 = cDisc.setXML(discriminator, converter, version, reset);
                    this.setDiscriminator(cDisc);
                } else if (discriminator.getName().equals("NumValDisc")) {
                    NumberValueDiscriminator nvd = new NumberValueDiscriminator();
                    boolean result3 = nvd.setXML(discriminator, converter, version, reset);
                    this.setDiscriminator(nvd);
                } else if (discriminator.getName().equals("DateValDisc")) {
                    DateValueDiscriminator dvd = new DateValueDiscriminator();
                    boolean result4 = dvd.setXML(discriminator, converter, version, reset);
                    this.setDiscriminator(dvd);
                } else if (discriminator.getName().equals("PosDisc")) {
                    PositionDiscriminator pd = new PositionDiscriminator();
                    boolean result5 = pd.setXML(discriminator, converter, version, reset);
                    this.setDiscriminator(pd);
                } else if (discriminator.getName().equals("QDRDisc")) {
                    QDRDiscriminator qdrd = new QDRDiscriminator();
                    if (this.m_context != null) {
                        qdrd.setContext(this.m_context);
                    }
                    boolean result6 = qdrd.setXML(discriminator, converter, version, reset);
                    this.setDiscriminator(qdrd);
                } else if (discriminator.getName().equals("StrValDisc")) {
                    StringValueDiscriminator svd = new StringValueDiscriminator();
                    boolean result7 = svd.setXML(XML1, converter, version, reset);
                    this.setDiscriminator(svd);
                } else if (discriminator.getName().equals("TotDisc")) {
                    TotalsDiscriminator td = new TotalsDiscriminator();
                    boolean result8 = td.setXML(discriminator, converter, version, reset);
                    this.setDiscriminator(td);
                } else {
                    PropertyNode pNode = discriminator.getProperty(a_type);
                    if (pNode == null) {
                        return true;
                    }
                    String undefinedDiscriminatorPath = pNode.getValueAsString();
                    try {
                        Class<?> undefinedDiscriminatorClass = Class.forName(undefinedDiscriminatorPath);
                        DiscriminatorXML undefinedDiscriminator = (DiscriminatorXML)undefinedDiscriminatorClass.newInstance();
                        result = undefinedDiscriminator.setXML(discriminator, converter, version, reset);
                        this.setDiscriminator(undefinedDiscriminator);
                    }
                    catch (Exception exception) {
                        return true;
                    }
                }
            }
        }
        XML1 = node.getPropertyValueAsObjectNode(NAME_MERGEABLE, true);
        if (XML1 == null) {
            return true;
        }
        ObjectNode mergeableNode = XML1.getPropertyValueAsObjectNode();
        PropertyNode pNode = mergeableNode.getProperty(a_type);
        if (mergeableNode.getName().equals(NAME_VIEWSTYLE)) {
            undefinedRulePath = viewStylePath;
        } else if (mergeableNode.getName().equals(NAME_VIEWFORMAT)) {
            undefinedRulePath = viewFormatPath;
        } else if (mergeableNode.getName().equals(NAME_GRAPHSTYLE)) {
            undefinedRulePath = graphStylePath;
        } else if (pNode != null) {
            undefinedRulePath = pNode.getValueAsString();
        } else {
            return true;
        }
        try {
            Class<?> undefinedRuleClass = Class.forName(undefinedRulePath);
            MergeableXML mergeable = (MergeableXML)undefinedRuleClass.newInstance();
            result = mergeable.setXML(mergeableNode, version, reset);
            this.setFixedMergeable(mergeable);
        }
        catch (Exception exception) {
            return true;
        }
        return true;
    }

    @Override
    public ObjectNode getXML(boolean allProperties, ComponentTypeConverter dataview) {
        ObjectNode XML2;
        ObjectNode node = new ObjectNode(NAME_DISCRULE);
        if (allProperties || this.d_id != this.getID()) {
            node.addProperty(NAME_ID, this.getID());
        }
        ObjectNode nodeDiscriminator = new ObjectNode(NAME_DISC);
        if (this.getDiscriminator() instanceof DiscriminatorXML) {
            if (this.getDiscriminator() instanceof ComponentTypeDiscriminator) {
                String componentType = null;
                componentType = dataview.convertComponentTypeToString(((ComponentTypeDiscriminator)this.getDiscriminator()).getComponentType());
                nodeDiscriminator.addProperty("CompTypeDisc", componentType, false);
                node.addProperty(nodeDiscriminator);
            } else {
                ObjectNode XML;
                if (this.m_context != null) {
                    if (this.getDiscriminator() instanceof QDRDiscriminator) {
                        ((QDRDiscriminator)this.getDiscriminator()).setContext(this.m_context);
                    } else if (this.getDiscriminator() instanceof CompositeDiscriminator) {
                        ((CompositeDiscriminator)this.getDiscriminator()).setContext(this.m_context);
                    }
                }
                if ((XML = ((DiscriminatorXML)this.getDiscriminator()).getXML(allProperties, dataview, true)) != null) {
                    nodeDiscriminator.addProperty(XML);
                    node.addProperty(nodeDiscriminator);
                }
            }
        }
        ObjectNode nodeMergeable = new ObjectNode(NAME_MERGEABLE);
        if (this.getFixedMergeable() instanceof MergeableXML && (XML2 = ((MergeableXML)this.getFixedMergeable()).getXML(allProperties, true)) != null) {
            nodeMergeable.addProperty(XML2);
            node.addProperty(nodeMergeable);
        }
        return node;
    }
}

