/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.total;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.MemberInterfaceAbstractImpl;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adf.model.dvt.util.transform.total.AggLocation;
import oracle.adf.model.dvt.util.transform.total.AggType;
import oracle.adfinternal.model.dvt.util.transform.ProjectionInfo;
import oracle.adfinternal.model.dvt.util.transform.QDRLite;
import oracle.adfinternal.model.dvt.util.transform.Row;
import oracle.adfinternal.model.dvt.util.transform.total.AggColumn;
import oracle.adfinternal.model.dvt.util.transform.total.AggMethod;
import oracle.adfinternal.model.dvt.util.transform.total.AggPosition;
import oracle.adfinternal.model.dvt.util.transform.total.AggSpec;
import oracle.adfinternal.model.dvt.util.transform.total.AggWhat;
import oracle.adfinternal.model.dvt.util.transform.total.TotalMember;
import oracle.adfinternal.model.dvt.util.transform.total.TotalPlacement;
import oracle.adfinternal.model.dvt.util.transform.total.TotalRow;
import oracle.javatools.annotations.Concealed;

@Concealed
public class AggBuckets {
    private final AggSpec[] m_aggs;
    private final LinkedHashMap<QDRLite, TotalRow>[] m_buckets;
    private final ProjectionInfo m_projInfo;

    public AggBuckets(AggSpec[] aggs, ProjectionInfo pi) {
        this.m_projInfo = pi;
        this.m_aggs = this.translateAggsToAggColumns(aggs);
        this.m_buckets = new LinkedHashMap[this.m_aggs.length];
    }

    private AggBuckets(AggSpec[] aggs, ProjectionInfo pi, LinkedHashMap<QDRLite, TotalRow>[] buckets) {
        this.m_projInfo = pi;
        this.m_aggs = this.translateAggsToAggColumns(aggs);
        this.m_buckets = buckets;
    }

    public List<Row> integrateAggregations(List<Row> rowList) {
        TotalPlacement[] tp = this.getTotalPlacements();
        if (tp != null) {
            int replacePlacement = this.getReplacementPlacement(tp);
            if (replacePlacement > -1) {
                return tp[replacePlacement].getTotalRows();
            }
            for (int placement = 0; placement < tp.length; ++placement) {
                if (tp[placement] == null) continue;
                rowList.addAll(tp[placement].getTotalRows());
            }
        }
        return rowList;
    }

    private int getReplacementPlacement(TotalPlacement[] tp) {
        if (tp == null || tp.length > 1) {
            return -1;
        }
        for (int i = 0; i < tp.length; ++i) {
            if (tp[i] == null || tp[i].getAggLocation() != AggLocation.REPLACE) continue;
            return i;
        }
        return -1;
    }

    private AggSpec[] translateAggsToAggColumns(AggSpec[] aggSpec) {
        if (aggSpec == null) {
            return null;
        }
        ArrayList<AggSpec> retSpec = new ArrayList<AggSpec>();
        AggWhat[] whatToAgg = null;
        String[][] layout = this.m_projInfo.getLayout();
        for (int i = 0; i < aggSpec.length; ++i) {
            if (aggSpec[i] == null || (whatToAgg = aggSpec[i].getColumnsToAggregate()) == null || whatToAgg.length <= 0) continue;
            AggMethod[] methods = aggSpec[i].getAggMethods();
            Map[] types = new Map[methods.length];
            for (int k = 0; k < types.length; ++k) {
                types[k] = methods[k].getAggTypeMap();
            }
            if (whatToAgg[0] instanceof AggColumn) {
                AggWhat[] aggCols = new AggWhat[whatToAgg.length];
                for (int j = 0; j < whatToAgg.length; ++j) {
                    String col = ((AggColumn)whatToAgg[j]).getColumn();
                    aggCols[j] = new AggColumn(col, new AggPositionMemberInterfaceImpl(whatToAgg[j].getMemberInterface(), col, types), ((AggColumn)whatToAgg[j]).getShowAggComponentFilters());
                }
                retSpec.add(new AggSpec(aggCols, aggSpec[i].getOptions(), aggSpec[i].getAggMethods()));
                continue;
            }
            if (!(whatToAgg[0] instanceof AggPosition)) continue;
            ArrayList<AggColumn> colList = new ArrayList<AggColumn>();
            AggPosition aggPos = (AggPosition)whatToAgg[0];
            int edge = aggPos.getEdge();
            int layer = aggPos.getLayer();
            if (layout == null || edge <= -1 || layer <= -1 || edge >= layout.length || layout[edge] == null || layer >= layout[edge].length) continue;
            for (int l = layer; l < layout[edge].length; ++l) {
                colList.add(new AggColumn(layout[edge][l], new AggPositionMemberInterfaceImpl(aggPos.getMemberInterface(), layout[edge][l], types)));
            }
            AggWhat[] cols = colList.toArray(new AggColumn[0]);
            retSpec.add(new AggSpec(cols, aggSpec[i].getOptions(), aggSpec[i].getAggMethods()));
        }
        return retSpec.toArray(new AggSpec[0]);
    }

    public String[] getAggColumns() {
        Vector<String> colRet = new Vector<String>();
        if (this.m_aggs != null) {
            for (int i = 0; i < this.m_aggs.length; ++i) {
                AggWhat[] cols;
                if (this.m_aggs[i] == null || (cols = this.m_aggs[i].getColumnsToAggregate()) == null) continue;
                for (int j = 0; j < cols.length; ++j) {
                    String col;
                    if (!(cols[j] instanceof AggColumn) || (col = ((AggColumn)cols[j]).getColumn()) == null || colRet.indexOf(col) != -1) continue;
                    colRet.addElement(col);
                }
            }
        }
        return colRet.toArray(new String[0]);
    }

    public void release() {
        int i;
        if (this.m_aggs != null) {
            for (i = 0; i < this.m_aggs.length; ++i) {
                if (this.m_aggs[i] == null) continue;
                this.m_aggs[i].release();
            }
        }
        if (this.m_buckets != null) {
            for (i = 0; i < this.m_buckets.length; ++i) {
                if (this.m_buckets[i] == null) continue;
                this.m_buckets[i].clear();
            }
        }
    }

    protected QDRLite getGroupingKey(Row row, AggSpec spec) throws TransformException {
        List<String> cols = spec.getGroupingColumns(this.m_projInfo);
        LayerInterface li = this.m_projInfo.getDataLayer();
        QDRLite qdr = new QDRLite(li != null ? li.getValue() : null);
        for (String col : cols) {
            if (col.equals(qdr.getMeasureDim()) || this.m_projInfo.isIgnoredColumn(col)) continue;
            qdr.addDimMemberPair(col, row.getMemberCell(col).getMetadata("value"));
        }
        return qdr;
    }

    public void totalRow(Row row) throws TransformException {
        if (this.m_aggs == null) {
            return;
        }
        QDRLite groupingKey = null;
        TotalRow currRow = null;
        for (int i = 0; i < this.m_aggs.length; ++i) {
            AggWhat[] columns = this.m_aggs[i].getColumnsToAggregate();
            if (row instanceof TotalRow && columns != null) {
                boolean skip = false;
                for (int c = 0; c < columns.length; ++c) {
                    MemberInterface cell;
                    String colName;
                    if (!(columns[c] instanceof AggColumn) || (colName = ((AggColumn)columns[c]).getColumn()) == null || !((cell = row.getMemberCell(colName)) instanceof TotalMember)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            groupingKey = this.getGroupingKey(row, this.m_aggs[i]);
            if (this.m_buckets[i] == null) {
                this.m_buckets[i] = new LinkedHashMap();
            }
            if ((currRow = this.m_buckets[i].get(groupingKey)) == null) {
                currRow = new TotalRow(row, this.m_projInfo, this.m_aggs[i]);
                this.m_buckets[i].put(groupingKey, currRow);
            }
            currRow.aggregate(row, groupingKey);
        }
    }

    public TotalPlacement[] getTotalPlacements() {
        if (this.m_buckets != null) {
            Collection<TotalRow> values = null;
            TotalPlacement[] placements = new TotalPlacement[this.m_buckets.length];
            for (int bucket = 0; bucket < this.m_buckets.length; ++bucket) {
                ArrayList<TotalRow> totals = new ArrayList<TotalRow>();
                if (this.m_buckets[bucket] == null) continue;
                values = this.m_buckets[bucket].values();
                for (TotalRow total : values) {
                    if (!total.include()) continue;
                    totals.add(total);
                }
                placements[bucket] = new TotalPlacement(totals, this.m_aggs[bucket].getOptions().getAggLocation());
            }
            return placements;
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        return new AggBuckets(this.m_aggs, this.m_projInfo, (LinkedHashMap[])this.m_buckets.clone());
    }

    private class AggPositionMemberInterfaceImpl
    extends MemberInterfaceAbstractImpl {
        private MemberInterface m_memberInt = null;
        private Map<String, AggType>[] m_aggTypes = null;
        private String m_column = null;

        public AggPositionMemberInterfaceImpl(MemberInterface membInt, String column, Map<String, AggType>[] types) {
            this.m_memberInt = membInt;
            this.m_column = column;
            this.m_aggTypes = types;
        }

        @Override
        public String getValue() throws TransformException {
            String val = this.m_memberInt.getValue();
            return (String)this.removeWildcards(val, new String[]{"%!LAYER_NAME!%", "%!AGG_TYPE_NAME!%"}, new Object[]{this.getLayerInterface().getValue(), this.constructTypeString(this.m_aggTypes)});
        }

        private Object removeWildcards(Object startVal, String[] substType, Object[] substVal) throws TransformException {
            Object newVal = startVal;
            for (int i = 0; i < substVal.length; ++i) {
                newVal = this._removeWildcard(newVal, substType[i], substVal[i]);
            }
            return newVal;
        }

        private Object _removeWildcard(Object startVal, String substType, Object substVal) throws TransformException {
            if (startVal instanceof String && substVal instanceof String) {
                String startStr = (String)startVal;
                String substStr = (String)substVal;
                String newStr = startStr;
                return newStr.replace(substType, substStr);
            }
            return startVal;
        }

        private String constructTypeString(Map<String, AggType>[] types) {
            String typeStr = "";
            for (int i = 0; i < types.length; ++i) {
                typeStr = typeStr + types[i].get("dataValue").toString();
            }
            return typeStr;
        }

        @Override
        public Object getMetadata(String type) throws TransformException {
            if (type.equals("label") || type.equals("value")) {
                return this.removeWildcards(this.m_memberInt.getMetadata(type), new String[]{"%!LAYER_NAME!%", "%!AGG_TYPE_NAME!%"}, new Object[]{this.getLayerInterface().getMetadata(type.equals("label") ? "layerLabel" : "layerName"), this.constructTypeString(this.m_aggTypes)});
            }
            return this.m_memberInt.getMetadata(type);
        }

        private LayerInterface getLayerInterface() {
            return AggBuckets.this.m_projInfo.getLayer(this.m_column);
        }
    }
}

