/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform.calcColumns;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.ColumnValue;
import oracle.adfinternal.model.dvt.util.transform.ColumnValues;
import oracle.adfinternal.model.dvt.util.transform.TransformRuntimeException;
import oracle.adfinternal.model.dvt.util.transform.TransformUtils;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.CalcColumnValue;
import oracle.javatools.annotations.Concealed;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;

@Concealed
public class ColumnMetadata {
    private Object m_min = null;
    private Object m_max = null;
    private BigDecimal m_sum = BigDecimal.valueOf(0L);
    private long m_count = 0L;
    private Object m_median = null;
    private boolean m_calcedMedian = false;
    private List<ColumnValue> m_values = new ArrayList<ColumnValue>();
    private List<CalcColumnValue> m_calcColValues = new ArrayList<CalcColumnValue>();
    private ColumnValues m_sortedValues = null;
    private Set<Object> m_uniqueSet = new HashSet<Object>();

    public Object getMin() {
        return this.m_min;
    }

    public Object getMax() {
        return this.m_max;
    }

    public long getValueCount() {
        return this.m_count;
    }

    public int getUniqueValueCount() {
        return this.m_uniqueSet.size();
    }

    public Object getMean() {
        if (this.m_count == 0L) {
            return null;
        }
        if (this.m_min instanceof BigInteger && this.m_max instanceof BigInteger) {
            return this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP).toBigInteger();
        }
        if (this.m_min instanceof BigDecimal && this.m_max instanceof BigDecimal) {
            return this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP);
        }
        if (this.m_min instanceof Number && this.m_max instanceof Number) {
            return this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP).doubleValue();
        }
        if (this.m_min instanceof NUMBER && this.m_max instanceof NUMBER) {
            try {
                return new NUMBER(this.m_sum.divide(BigDecimal.valueOf(this.m_count), RoundingMode.HALF_UP));
            }
            catch (SQLException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
        return null;
    }

    public Object getMedian() {
        if (this.m_calcedMedian) {
            return this.m_median;
        }
        ColumnValues vals = this.getSortedValues();
        if (vals.getLength() == 0) {
            this.m_calcedMedian = true;
            return this.m_median;
        }
        this.m_calcedMedian = true;
        this.m_median = vals.getMedian();
        return this.m_median;
    }

    protected ColumnValues getSortedValues() {
        if (this.m_sortedValues == null) {
            ColumnValue[] vals = this.m_values.toArray(new ColumnValue[0]);
            this.m_sortedValues = new ColumnValues(vals);
            this.m_sortedValues.sort();
        }
        return this.m_sortedValues;
    }

    protected List<ColumnValue> getValues() {
        return this.m_values;
    }

    protected List<CalcColumnValue> getCalcColumnValues() {
        return this.m_calcColValues;
    }

    private void trackValue(ColumnValue value, CalcColumnValue ccv) throws TransformException {
        this.m_values.add(value);
        this.m_calcColValues.add(ccv);
        this.m_uniqueSet.add(value.getValue());
        ++this.m_count;
    }

    protected void update(ColumnValue inputColVal, CalcColumnValue ccv) throws TransformException {
        Object value = inputColVal.getValue();
        if (value instanceof BigInteger) {
            BigInteger biVal = (BigInteger)value;
            this.m_min = this.m_min == null ? value : biVal.min((BigInteger)this.m_min);
            this.m_max = this.m_max == null ? value : biVal.max((BigInteger)this.m_max);
            this.trackValue(inputColVal, ccv);
            this.m_sum = this.m_sum.add(new BigDecimal(biVal));
        } else if (value instanceof BigDecimal) {
            BigDecimal bdVal = (BigDecimal)value;
            this.m_min = this.m_min == null ? value : bdVal.min((BigDecimal)this.m_min);
            this.m_max = this.m_max == null ? value : bdVal.max((BigDecimal)this.m_max);
            this.trackValue(inputColVal, ccv);
            this.m_sum = this.m_sum.add(bdVal);
        } else if (value instanceof Number) {
            double dVal = ((Number)value).doubleValue();
            this.m_min = this.m_min == null ? value : new Double(Math.min(((Number)this.m_min).doubleValue(), dVal));
            this.m_max = this.m_max == null ? value : new Double(Math.max(((Number)this.m_max).doubleValue(), dVal));
            this.trackValue(inputColVal, ccv);
            this.m_sum = this.m_sum.add(BigDecimal.valueOf(dVal));
        } else if (value instanceof String) {
            if (this.m_min == null) {
                this.m_min = value;
            } else {
                Object object = this.m_min = ((String)value).compareTo((String)this.m_min) < 0 ? value : this.m_min;
            }
            this.m_max = this.m_max == null ? value : (((String)value).compareTo((String)this.m_max) > 0 ? value : this.m_max);
            this.trackValue(inputColVal, ccv);
        } else if (value instanceof Date) {
            if (this.m_min == null) {
                this.m_min = value;
            } else {
                Object object = this.m_min = ((Date)value).before((Date)this.m_min) ? value : this.m_min;
            }
            this.m_max = this.m_max == null ? value : (((Date)value).after((Date)this.m_max) ? value : this.m_max);
            this.trackValue(inputColVal, ccv);
        } else if (value instanceof NUMBER) {
            this.m_min = this.m_min == null ? value : TransformUtils.min(value, this.m_min);
            this.m_max = this.m_max == null ? value : TransformUtils.max(value, this.m_max);
            this.trackValue(inputColVal, ccv);
            try {
                this.m_sum = this.m_sum.add(((NUMBER)value).bigDecimalValue());
            }
            catch (SQLException e) {
                throw new TransformException(e.getMessage(), e);
            }
        } else if (value instanceof DATE) {
            this.m_min = this.m_min == null ? value : TransformUtils.min(value, this.m_min);
            this.m_max = this.m_max == null ? value : TransformUtils.max(value, this.m_max);
            this.trackValue(inputColVal, ccv);
        } else if (value instanceof TIMESTAMP) {
            this.m_min = this.m_min == null ? value : TransformUtils.min(value, this.m_min);
            this.m_max = this.m_max == null ? value : TransformUtils.max(value, this.m_max);
            this.trackValue(inputColVal, ccv);
        } else if (value instanceof CHAR) {
            this.m_min = this.m_min == null ? value : TransformUtils.min(value, this.m_min);
            this.m_max = this.m_max == null ? value : TransformUtils.max(value, this.m_max);
            this.trackValue(inputColVal, ccv);
        }
    }
}

