/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.model.dvt.util.transform;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.dvt.util.transform.BaseRowIterator;
import oracle.adf.model.dvt.util.transform.DataCellInterface;
import oracle.adf.model.dvt.util.transform.DataColumnProjection;
import oracle.adf.model.dvt.util.transform.DataColumnRowIterator;
import oracle.adf.model.dvt.util.transform.GetMemberInterface;
import oracle.adf.model.dvt.util.transform.LayerInterface;
import oracle.adf.model.dvt.util.transform.MemberInterface;
import oracle.adf.model.dvt.util.transform.MixedFrequencyProjection;
import oracle.adf.model.dvt.util.transform.RowIterator;
import oracle.adf.model.dvt.util.transform.RowProjection;
import oracle.adf.model.dvt.util.transform.TransformException;
import oracle.adfinternal.model.dvt.util.transform.CalcColumnDataCellInterfaceImpl;
import oracle.adfinternal.model.dvt.util.transform.CalcColumnMemberInterfaceImpl;
import oracle.adfinternal.model.dvt.util.transform.CalcColumnMemberInterfaceProvider;
import oracle.adfinternal.model.dvt.util.transform.ColumnValue;
import oracle.adfinternal.model.dvt.util.transform.ColumnValues;
import oracle.adfinternal.model.dvt.util.transform.ExtraColumnValue;
import oracle.adfinternal.model.dvt.util.transform.Filter;
import oracle.adfinternal.model.dvt.util.transform.ProjectionInfo;
import oracle.adfinternal.model.dvt.util.transform.Row;
import oracle.adfinternal.model.dvt.util.transform.SimpleMemberInterfaceImpl;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.CalcColumnMetadata;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.CalcColumnValue;
import oracle.adfinternal.model.dvt.util.transform.calcColumns.CalculatedColumnSpec;
import oracle.adfinternal.model.dvt.util.transform.total.AggBuckets;
import oracle.adfinternal.model.dvt.util.transform.total.AggSpec;
import oracle.javatools.annotations.Concealed;

@Concealed
public class DataTable {
    private static final int PROJECTION_STANDARD = 0;
    private static final int PROJECTION_DATA_COLUMN = 1;
    private static final int PROJECTION_MIXED_FREQUENCY = 2;
    private RowProjection m_projection = null;
    private ProjectionInfo m_projInfo = null;
    private int m_projectionType = 0;
    private int m_memberCount = -1;
    private int m_cellCount = -1;
    private Hashtable m_memberLookupTable = new Hashtable();
    private Hashtable<String, Object> m_cellLookupTable = new Hashtable();
    private Hashtable m_backwardCellLookupTable = new Hashtable();
    private String[] m_cellNames = null;
    private List<Row> m_data = null;
    private String[] m_memberLayers = null;
    private AggBuckets[] m_aggBucket = null;
    private AggSpec[][] m_aggs = null;
    private BaseRowIterator m_iter = null;
    private Filter[] m_filters = null;
    private CalculatedColumnSpec[] m_colSpecs = null;
    private Map<String, CalcColumnMetadata> m_specTable = new HashMap<String, CalcColumnMetadata>();
    private Map<String, Boolean> m_inDataItems = new HashMap<String, Boolean>();
    private Map<String, Boolean> m_inLayout = new HashMap<String, Boolean>();
    private Map<String, Boolean> m_isIgnored = new HashMap<String, Boolean>();
    private MemberInterface[] m_dataItems = null;

    protected DataTable() {
    }

    protected DataTable(BaseRowIterator iter, CalculatedColumnSpec[] colSpecs, AggSpec[][] aggs) throws TransformException {
        this(null, iter, colSpecs, aggs, null, false);
    }

    protected DataTable(RowProjection projection) throws TransformException {
        this(projection, null, null, false);
    }

    protected DataTable(RowProjection projection, AggSpec[][] aggs) throws TransformException {
        this(projection, aggs, null, false);
    }

    protected DataTable(RowProjection projection, AggSpec[][] aggs, boolean includeDataLayerinMembers) throws TransformException {
        this(projection, aggs, null, includeDataLayerinMembers);
    }

    protected DataTable(RowProjection projection, AggSpec[][] aggs, Filter[] filters, boolean includeDataLayerinMembers) throws TransformException {
        this(projection, null, null, aggs, filters, includeDataLayerinMembers);
    }

    protected DataTable(RowProjection projection, BaseRowIterator iter, CalculatedColumnSpec[] colSpecs, AggSpec[][] aggs, Filter[] filters, boolean includeDataLayerinMembers) throws TransformException {
        this.m_projection = projection;
        this.m_projInfo = new ProjectionInfo(projection);
        this.m_iter = iter;
        this.m_aggs = aggs;
        this.setUpCalculatedColumns(colSpecs);
        this.m_filters = filters;
        if (aggs != null) {
            this.m_aggBucket = new AggBuckets[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                if (aggs[i] == null) continue;
                this.m_aggBucket[i] = new AggBuckets(aggs[i], this.m_projInfo);
            }
        }
        this.m_dataItems = this.m_projInfo.getDataItems();
        if (projection instanceof DataColumnProjection || iter instanceof DataColumnRowIterator) {
            this.m_projectionType = 1;
            this.processDataColumnProjection();
        } else if (projection instanceof MixedFrequencyProjection) {
            this.m_projectionType = 2;
            this.processMixedFrequencyProjection();
        } else {
            this.m_projectionType = 0;
            this.processProjection(includeDataLayerinMembers);
        }
    }

    protected BaseRowIterator getIterator() {
        return this.m_iter;
    }

    private void setUpCalculatedColumns(CalculatedColumnSpec[] colSpecs) {
        this.m_colSpecs = colSpecs;
        if (colSpecs != null) {
            for (int i = 0; i < colSpecs.length; ++i) {
                if (colSpecs[i] == null) continue;
                this.m_specTable.put(colSpecs[i].getColumn(), colSpecs[i].getCalcColumnMetadata());
            }
        }
    }

    protected Filter[] getFilters() {
        return this.m_filters;
    }

    protected AggSpec[][] getAggSpec() {
        return this.m_aggs;
    }

    protected List<? extends Row> getRows() {
        return this.m_data;
    }

    public String[] getColumns() {
        int i;
        int memberLayers = this.m_memberLayers != null ? this.m_memberLayers.length : 0;
        Enumeration<String> dataEnum = this.m_cellLookupTable.keys();
        ArrayList<String> dataArray = new ArrayList<String>();
        while (dataEnum.hasMoreElements()) {
            dataArray.add(dataEnum.nextElement());
        }
        int dataSize = dataArray.size();
        String[] cols = new String[memberLayers + dataSize + this.m_specTable.size()];
        for (i = 0; i < memberLayers; ++i) {
            cols[i] = this.m_memberLayers[i];
        }
        for (i = memberLayers; i < memberLayers + dataSize; ++i) {
            cols[i] = (String)dataArray.get(i - memberLayers);
        }
        for (i = dataSize + memberLayers; i < cols.length; ++i) {
            cols[i] = this.m_colSpecs[i - (dataSize + memberLayers)].getColumn();
        }
        return cols;
    }

    public long getRowCount() {
        return this.m_data.size();
    }

    protected int getMemberCount() {
        return this.m_memberCount;
    }

    protected int getCellCount() {
        return this.m_cellCount;
    }

    public Row getRow(long row) {
        return this.m_data.get((int)row);
    }

    protected RowProjection getProjection() {
        return this.m_projection;
    }

    protected MemberInterface getMember(long row, int member) {
        if (row < this.getRowCount() && row >= 0L && member < this.m_memberCount && member >= 0) {
            return this.getRow(row).getMember(member);
        }
        return null;
    }

    protected DataCellInterface getCell(long row, int cell) {
        if (row < this.getRowCount() && row >= 0L && cell < this.m_cellCount && cell >= 0) {
            return this.getRow(row).getCell(cell);
        }
        return null;
    }

    protected MemberInterface getMember(long row, String colID) {
        return this.getMember(row, this.getMemberIndexFromID(colID));
    }

    protected DataCellInterface getCell(long row, String colID) {
        return this.getCell(row, this.getCellIndexFromID(colID));
    }

    private void setMember(long row, int column, MemberInterface newMember) {
        if (row < this.getRowCount() && row >= 0L && column < this.m_memberCount && column >= 0) {
            this.getRow(row).setMember(column, newMember);
        }
    }

    private void setCell(long row, int column, DataCellInterface newCell) {
        if (row < this.getRowCount() && row >= 0L && column < this.m_cellCount && column >= 0) {
            this.getRow(row).setCell(column, newCell);
        }
    }

    protected void setMember(long row, String colID, MemberInterface newMember) {
        this.setMember(row, this.getMemberIndexFromID(colID), newMember);
    }

    protected void setCell(long row, String colID, DataCellInterface newCell) {
        this.setCell(row, this.getCellIndexFromID(colID), newCell);
    }

    protected int getMemberIndexFromID(String colID) {
        Integer colNum = (Integer)this.m_memberLookupTable.get(colID);
        if (colNum != null) {
            return colNum;
        }
        return -1;
    }

    protected int getCellIndexFromID(String colID) {
        Integer colNum = (Integer)this.m_cellLookupTable.get(colID);
        if (colNum != null) {
            return colNum;
        }
        return -1;
    }

    protected void close() throws TransformException {
        if (this.m_iter != null) {
            this.m_iter.close();
        }
        if (this.m_memberLookupTable != null) {
            this.m_memberLookupTable.clear();
        }
        this.m_memberLookupTable = null;
        this.m_memberCount = -1;
        if (this.m_cellLookupTable != null) {
            this.m_cellLookupTable.clear();
        }
        this.m_cellLookupTable = null;
        if (this.m_backwardCellLookupTable != null) {
            this.m_backwardCellLookupTable.clear();
        }
        this.m_backwardCellLookupTable = null;
        this.m_cellNames = null;
        this.m_cellCount = -1;
        this.m_projection = null;
        this.m_projInfo = null;
        if (this.m_data != null) {
            long count = this.getRowCount();
            Row r = null;
            for (long i = 0L; i < count; ++i) {
                r = this.getRow(i);
                if (r == null) continue;
                r.release();
            }
        }
        this.m_data = null;
        this.m_memberLayers = null;
        this.m_isIgnored = null;
        this.m_inDataItems = null;
        this.m_inLayout = null;
        if (this.m_aggBucket != null) {
            for (int i = 0; i < this.m_aggBucket.length; ++i) {
                if (this.m_aggBucket[i] == null) continue;
                this.m_aggBucket[i].release();
            }
        }
        this.m_aggBucket = null;
    }

    private void processMixedFrequencyProjection() throws TransformException {
        this.createMemberLookupTable(false);
        this.createCellLookupTable();
        this.m_data = new ArrayList<Row>();
        Hashtable indices = new Hashtable();
        BaseRowIterator baseRowIterator = this.m_iter = this.m_projection != null ? this.m_projection.getRowIterator() : this.m_iter;
        while (this.m_iter.nextRow()) {
            this.processMixedFrequencyCurrentRow(this.m_data, indices, this.m_iter);
        }
    }

    private void processDataColumnProjection() throws TransformException {
        List<Row> data;
        this.createMemberLookupTable(false);
        this.createCellLookupTable();
        ArrayList<Row> rowList = new ArrayList<Row>();
        this.m_iter = this.m_projection != null ? this.m_projection.getRowIterator() : this.m_iter;
        ColumnValues extraMembers = null;
        Row row2 = null;
        long rowIndex = 0L;
        while (this.m_iter.nextRow()) {
            rowIndex = rowList.size();
            extraMembers = this._collectAggregatedMembers(this.m_iter, rowIndex, true);
            row2 = this.processDataColumnCurrentRow(rowList, this.m_iter, extraMembers, rowIndex);
            if (row2 == null) continue;
            rowList.add(row2);
        }
        if (this.m_specTable.size() > 0) {
            rowIndex = 0L;
            for (Row r : rowList) {
                r.setCalcColumns(this.getCalcColumns(r, rowIndex++));
            }
        }
        if (this.m_aggBucket != null && this.m_aggBucket.length > 0) {
            for (Row row2 : rowList) {
                if (this.m_aggBucket == null || this.m_aggBucket.length <= 0 || this.m_aggBucket[0] == null) continue;
                this.m_aggBucket[0].totalRow(row2);
            }
        }
        List<Row> list = data = this.m_aggBucket != null && this.m_aggBucket.length > 0 ? this.m_aggBucket[0].integrateAggregations(rowList) : rowList;
        if (this.m_aggBucket != null) {
            for (int i = 1; i < this.m_aggBucket.length; ++i) {
                rowList = new ArrayList();
                if (this.m_aggBucket[i] == null || data == null) continue;
                int count = data.size();
                Row currRow = null;
                for (int r = 0; r < count; ++r) {
                    currRow = (Row)data.get(r);
                    rowList.add(currRow);
                    this.m_aggBucket[i].totalRow(currRow);
                }
                data = this.m_aggBucket[i].integrateAggregations(rowList);
            }
        }
        this.m_data = data;
    }

    private boolean _inLayout(String column) {
        Boolean val = this.m_inLayout.get(column);
        if (val != null) {
            return val;
        }
        String[][] layout = this.m_projInfo.getLayout();
        if (layout == null) {
            this.m_inLayout.put(column, Boolean.FALSE);
            return false;
        }
        for (int e = 0; e < layout.length; ++e) {
            if (layout[e] == null) continue;
            for (int l = 0; l < layout[e].length; ++l) {
                if (!column.equals(layout[e][l])) continue;
                this.m_inLayout.put(column, Boolean.TRUE);
                return true;
            }
        }
        this.m_inLayout.put(column, Boolean.FALSE);
        return false;
    }

    private boolean _isDataItem(String col) throws TransformException {
        if (this.m_projection == null) {
            return false;
        }
        Boolean val = this.m_inDataItems.get(col);
        if (val != null) {
            return val;
        }
        if (this.m_dataItems != null) {
            for (int i = 0; i < this.m_dataItems.length; ++i) {
                if (this.m_dataItems[i] == null || !col.equals(this.m_dataItems[i].getValue())) continue;
                this.m_inDataItems.put(col, Boolean.TRUE);
                return true;
            }
        }
        this.m_inDataItems.put(col, Boolean.FALSE);
        return false;
    }

    private ColumnValues _collectAggregatedMembers(BaseRowIterator iter, long index, boolean dataColProjection) throws TransformException {
        if (this.m_aggBucket != null) {
            ArrayList<ExtraColumnValue> memberVec = new ArrayList<ExtraColumnValue>();
            ArrayList<String> colList = new ArrayList<String>();
            for (int i = 0; i < this.m_aggBucket.length; ++i) {
                String[] cols;
                if (this.m_aggBucket[i] == null || (cols = this.m_aggBucket[i].getAggColumns()) == null) continue;
                for (int c = 0; c < cols.length; ++c) {
                    if (cols[c] == null || colList.indexOf(cols[c]) != -1 || this._inLayout(cols[c])) continue;
                    colList.add(cols[c]);
                    if (dataColProjection && this._isDataItem(cols[c])) {
                        if (cols[c].equals(iter.getValue(((DataColumnProjection)this.m_projection).getDataItemIDColumn()))) {
                            memberVec.add(new ExtraColumnValue(cols[c], iter.getValue(((DataColumnProjection)this.m_projection).getDataColumn()), index, this.isIgnoredColumn(cols[c])));
                            continue;
                        }
                        memberVec.add(new ExtraColumnValue(cols[c], null, index, this.isIgnoredColumn(cols[c])));
                        continue;
                    }
                    memberVec.add(new ExtraColumnValue(cols[c], iter.getValue(cols[c]), index, this.isIgnoredColumn(cols[c])));
                }
            }
            return new ColumnValues(memberVec.toArray(new ColumnValue[0]));
        }
        return new ColumnValues(new ColumnValue[0]);
    }

    private boolean isIgnoredColumn(String column) {
        Boolean val = this.m_isIgnored.get(column);
        if (val != null) {
            return val;
        }
        String[] ignoredCols = this.m_projInfo.getIgnoredColumns();
        if (ignoredCols == null) {
            this.m_isIgnored.put(column, Boolean.FALSE);
            return false;
        }
        for (int i = 0; i < ignoredCols.length; ++i) {
            if (!column.equals(ignoredCols[i])) continue;
            this.m_isIgnored.put(column, Boolean.TRUE);
            return true;
        }
        this.m_isIgnored.put(column, Boolean.FALSE);
        return false;
    }

    public CalcColumnMetadata getCalcColumnMetadata(String column) {
        return this.m_specTable.get(column);
    }

    private ColumnValues getCalcColumns(Row row, long index) throws TransformException {
        ArrayList<CalcColumnValue> colVal = new ArrayList<CalcColumnValue>();
        Set<String> colSet = this.m_specTable.keySet();
        Iterator<String> iterSet = colSet.iterator();
        CalcColumnMetadata metadata = null;
        while (iterSet.hasNext()) {
            metadata = this.getCalcColumnMetadata(iterSet.next());
            colVal.add(metadata.getCalculatedColumnSpec().getCalcColumnValueObject(row, index));
        }
        return new ColumnValues(colVal.toArray(new ColumnValue[0]));
    }

    private void processProjection(boolean includeDataLayerinMembers) throws TransformException {
        List<Row> data;
        this.createMemberLookupTable(includeDataLayerinMembers);
        this.createCellLookupTable();
        ArrayList<Row> rowList = new ArrayList<Row>();
        Row row = null;
        this.m_iter = this.m_projection != null ? this.m_projection.getRowIterator() : this.m_iter;
        ColumnValues extraMembers = null;
        long rowIndex = 0L;
        if (this.m_iter != null) {
            while (this.m_iter.nextRow()) {
                extraMembers = this._collectAggregatedMembers(this.m_iter, rowIndex, false);
                row = this.processCurrentRow(this.m_iter, extraMembers, rowIndex);
                if (row == null) continue;
                rowList.add(row);
                ++rowIndex;
                if (this.m_aggBucket == null || this.m_aggBucket.length <= 0 || this.m_aggBucket[0] == null) continue;
                this.m_aggBucket[0].totalRow(row);
            }
        }
        List<Row> list = data = this.m_aggBucket != null && this.m_aggBucket.length > 0 && this.m_aggBucket[0] != null ? this.m_aggBucket[0].integrateAggregations(rowList) : rowList;
        if (this.m_aggBucket != null) {
            for (int i = 1; i < this.m_aggBucket.length; ++i) {
                rowList = new ArrayList();
                if (this.m_aggBucket[i] == null || data == null) continue;
                int count = data.size();
                Row currRow = null;
                for (int r = 0; r < count; ++r) {
                    currRow = (Row)data.get(r);
                    rowList.add(currRow);
                    this.m_aggBucket[i].totalRow(currRow);
                }
                data = this.m_aggBucket[i].integrateAggregations(rowList);
            }
        }
        this.m_data = data;
    }

    private boolean checkFilters(BaseRowIterator rowIter) throws TransformException {
        Filter[] filters = this.getFilters();
        if (filters == null || !(rowIter instanceof GetMemberInterface)) {
            return true;
        }
        for (int i = 0; i < filters.length; ++i) {
            if (filters[i] == null || filters[i].filter((GetMemberInterface)((Object)rowIter), null, null)) continue;
            return false;
        }
        return true;
    }

    protected boolean isMixedFrequencyProjection() {
        return this.m_projectionType == 2;
    }

    private void createMemberLookupTable(boolean includeDataLayerinMembers) throws TransformException {
        if (this.m_projection == null) {
            return;
        }
        String[][] layout = this.m_projInfo.getLayout();
        LayerInterface dataLayerInt = this.m_projInfo.getDataLayer();
        String dataLayer = dataLayerInt != null ? dataLayerInt.getValue() : null;
        this.m_memberLookupTable.clear();
        ArrayList<String> memberLayers = new ArrayList<String>();
        int index = 0;
        if (layout != null) {
            for (int edge = 0; edge < layout.length; ++edge) {
                if (layout[edge] == null) continue;
                for (int layer = 0; layer < layout[edge].length; ++layer) {
                    if (!includeDataLayerinMembers && dataLayer.equals(layout[edge][layer])) continue;
                    this.m_memberLookupTable.put(layout[edge][layer], new Integer(index++));
                    memberLayers.add(layout[edge][layer]);
                }
            }
        }
        this.m_memberLayers = memberLayers.toArray(new String[index]);
        this.m_memberCount = index;
    }

    private void createCellLookupTable() throws TransformException {
        block3: {
            block2: {
                this.m_cellLookupTable.clear();
                this.m_backwardCellLookupTable.clear();
                if (this.m_dataItems == null) break block2;
                this.m_cellCount = this.m_dataItems.length;
                for (int col = 0; col < this.m_cellCount; ++col) {
                    this.m_cellLookupTable.put(this.m_dataItems[col].getValue(), new Integer(col));
                }
                break block3;
            }
            if (this.m_iter == null) break block3;
            String[] cols = this.m_iter.getColumns();
            this.m_cellCount = cols.length;
            this.m_cellNames = new String[this.m_cellCount];
            for (int i = 0; i < cols.length; ++i) {
                this.m_cellLookupTable.put(cols[i], new Integer(i));
                this.m_cellNames[i] = cols[i];
            }
        }
    }

    private int cellLookup(String dataItemID) {
        Object val = this.m_cellLookupTable.get(dataItemID);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return -1;
    }

    protected DataCellInterface getCell(BaseRowIterator iter, String col, int colCount, Row row) throws TransformException {
        if (row.isCalcColumn(col)) {
            return new CalcColumnDataCellInterfaceImpl(row, col);
        }
        if (iter instanceof RowIterator) {
            return ((RowIterator)iter).getCell(col);
        }
        return new DataCellImpl(iter.getValue(col), col);
    }

    protected MemberInterface getMember(BaseRowIterator iter, String col, int colCount, Row row) throws TransformException {
        if (row.isCalcColumn(col)) {
            if (iter instanceof CalcColumnMemberInterfaceProvider) {
                return ((CalcColumnMemberInterfaceProvider)((Object)iter)).getCalcColumnMemberInterface(row, col);
            }
            return new CalcColumnMemberInterfaceImpl(row, col);
        }
        if (iter instanceof GetMemberInterface) {
            return ((GetMemberInterface)((Object)iter)).getMember(col);
        }
        return new SimpleMemberInterfaceImpl(iter.getValue(col), col);
    }

    protected Row processCurrentRow(BaseRowIterator iter, ColumnValues extraMembers, long rowIndex) throws TransformException {
        if (!this.checkFilters(iter)) {
            return null;
        }
        Row row = new Row(null, null, extraMembers, this, iter);
        row.setCalcColumns(this.getCalcColumns(row, rowIndex));
        MemberInterface[] memberCells = null;
        DataCellInterface[] cells = null;
        if (this.m_projection != null) {
            memberCells = new MemberInterface[this.m_memberCount >= 0 ? this.m_memberCount : 0];
            for (int col = 0; col < this.m_memberCount; ++col) {
                memberCells[col] = this.getMember(iter, this.m_memberLayers[col], col, row);
            }
            if (this.m_dataItems != null) {
                cells = new DataCellInterface[this.m_cellCount];
                String cellColumn = null;
                for (int col = 0; col < this.m_cellCount; ++col) {
                    cellColumn = this.m_dataItems[col].getValue();
                    cells[col] = this.getCell(iter, cellColumn, this.m_memberCount + col, row);
                }
            }
        } else {
            this.m_memberCount = 0;
            cells = new DataCellInterface[this.m_cellCount];
            String cellColumn = null;
            for (int col = 0; col < this.m_cellCount; ++col) {
                cellColumn = this.m_cellNames[col];
                cells[col] = this.getCell(iter, cellColumn, this.m_memberCount + col, row);
            }
        }
        row.setMembers(memberCells);
        row.setCells(cells);
        return row;
    }

    private MixedFrequencyProjection getMixedFrequencyProjection() {
        if (this.isMixedFrequencyProjection()) {
            return (MixedFrequencyProjection)this.m_projection;
        }
        return null;
    }

    private Row updateRow(Row row, ArrayList rowList) throws TransformException {
        if (rowList == null) {
            return null;
        }
        Iterator iter = rowList.iterator();
        Row currRow = null;
        while (iter.hasNext()) {
            currRow = (Row)iter.next();
            if (!row.membersEqual(currRow, this.m_dataItems)) continue;
            if (currRow.insertData(row.getCells())) {
                return currRow;
            }
            return null;
        }
        return null;
    }

    private Row processDataColumnCurrentRow(ArrayList rowList, BaseRowIterator iter, ColumnValues extraMembers, long rowIndex) throws TransformException {
        if (!this.checkFilters(iter)) {
            return null;
        }
        String dataID = null;
        String dataCol = null;
        MemberInterface mi = null;
        if (this.m_projection != null) {
            MemberInterface[] members = new MemberInterface[this.m_memberCount];
            for (int col = 0; col < this.m_memberCount; ++col) {
                members[col] = mi = ((GetMemberInterface)((Object)iter)).getMember(this.m_memberLayers[col]);
            }
            DataColumnProjection proj = (DataColumnProjection)this.m_projection;
            dataID = proj.getDataItemIDColumn();
            dataCol = proj.getDataColumn();
            DataCellInterface[] cells = new DataCellInterface[this.m_cellCount];
            mi = ((GetMemberInterface)((Object)iter)).getMember(dataID);
            int cellPos = this.cellLookup(mi.getValue());
            if (cellPos >= 0 && cellPos < this.m_cellCount) {
                cells[cellPos] = iter instanceof RowIterator ? ((RowIterator)iter).getCell(dataCol) : new DataCellImpl(iter.getValue(dataCol), dataCol);
                Row row = new Row(members, cells, extraMembers, this, iter);
                row.setCalcColumns(this.getCalcColumns(row, rowIndex));
                Row updatedRow = this.updateRow(row, rowList);
                if (updatedRow != null) {
                    return null;
                }
                return row;
            }
        } else if (iter instanceof DataColumnRowIterator) {
            dataID = ((DataColumnRowIterator)iter).getDataItemIDColumn();
            dataCol = ((DataColumnRowIterator)iter).getDataColumn();
            ArrayList<DataCellImpl> cells = new ArrayList<DataCellImpl>();
            ArrayList<SimpleMemberInterfaceImpl> members = new ArrayList<SimpleMemberInterfaceImpl>();
            int numCells = 0;
            int memberCount = 0;
            for (int c = 0; c < this.m_cellCount; ++c) {
                if (this.m_cellNames[c].equals(dataID) || this.m_cellNames[c].equals(dataCol)) {
                    int cellPos;
                    Object obj = this.m_cellLookupTable.get(iter.getValue(dataID));
                    int n = cellPos = obj instanceof Integer ? (Integer)obj : -1;
                    if (cellPos == -1) {
                        if (this.m_backwardCellLookupTable.get(new Integer(numCells)) == null) {
                            this.m_cellLookupTable.put((String)iter.getValue(dataID), new Integer(numCells));
                            this.m_backwardCellLookupTable.put(new Integer(numCells), iter.getValue(dataID));
                            cellPos = numCells;
                        } else {
                            cellPos = -1;
                        }
                    }
                    if (cellPos >= 0 && cellPos < this.m_cellCount) {
                        if (numCells == cellPos) {
                            String str = (String)iter.getValue(dataID);
                            cells.add(new DataCellImpl(iter.getValue(dataCol), str));
                        } else {
                            cells.add(null);
                        }
                    }
                    ++numCells;
                    continue;
                }
                this.m_memberLookupTable.put(this.m_cellNames[c], new Integer(memberCount++));
                members.add(new SimpleMemberInterfaceImpl(iter.getValue(this.m_cellNames[c]), this.m_cellNames[c]));
            }
            Row row = new Row(members.toArray(new MemberInterface[0]), cells.toArray(new DataCellInterface[0]), extraMembers, this, iter);
            Row updatedRow = this.updateRow(row, rowList);
            if (updatedRow != null) {
                return null;
            }
            return row;
        }
        return null;
    }

    private void processMixedFrequencyCurrentRow(List<Row> rowList, Hashtable indices, BaseRowIterator baseIter) throws TransformException {
        if (!(baseIter instanceof RowIterator)) {
            return;
        }
        RowIterator iter = (RowIterator)baseIter;
        MixedFrequencyProjection projection = this.getMixedFrequencyProjection();
        MemberInterface[] members1 = new MemberInterface[this.m_memberCount];
        MemberInterface[] members2 = new MemberInterface[this.m_memberCount];
        ArrayList<String> qdrMembers = new ArrayList<String>();
        int dynamicIndex = -1;
        for (int col = 0; col < this.m_memberCount; ++col) {
            if (!projection.getDynamicLayer().equals(this.m_memberLayers[col])) {
                members1[col] = iter.getMember(this.m_memberLayers[col]);
                members2[col] = members1[col];
                qdrMembers.add(members1[col].getValue());
                continue;
            }
            dynamicIndex = col;
        }
        Integer value = (Integer)indices.get(qdrMembers);
        if (value == null) {
            value = new Integer(-1);
        }
        int index = value + 1;
        indices.put(qdrMembers, new Integer(index));
        members1[dynamicIndex] = projection != null ? projection.getDynamicMember(index, 0) : null;
        members2[dynamicIndex] = projection != null ? projection.getDynamicMember(index, 1) : null;
        DataCellInterface[] cells1 = new DataCellInterface[this.m_cellCount];
        DataCellInterface[] cells2 = new DataCellInterface[this.m_cellCount];
        DataCellInterface frequency = iter.getCell(projection != null ? projection.getMixedFrequencyLayer() : null);
        if (this.m_dataItems != null) {
            for (int i = 0; i < this.m_dataItems.length; ++i) {
                cells1[i] = frequency;
                cells2[i] = iter.getCell(this.m_dataItems[i].getValue());
            }
        }
        Row row1 = new Row(members1, cells1, null, this, iter);
        Row row2 = new Row(members2, cells2, null, this, iter);
        rowList.add(row1);
        rowList.add(row2);
    }

    private class DataCellImpl
    implements DataCellInterface {
        protected Object m_value = null;
        protected String m_column = null;

        public DataCellImpl(Object value, String col) {
            this.m_value = value;
            this.m_column = col;
        }

        @Override
        public boolean setData(Object value, String type) {
            return false;
        }

        @Override
        public Object getData(String type) {
            if (type.equals("dataTypeColumn")) {
                return this.m_column;
            }
            return this.m_value;
        }
    }
}

