/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.natives.DirectoryWatcher;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;
import oracle.ide.persistence.NameSpace;
import oracle.ide.util.Assert;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;
import oracle.javatools.util.Maps;

public class VirtualFileSystemHelper
extends URLFileSystemHelperDecorator {
    private static boolean ENABLED = Boolean.getBoolean("VFS_ENABLE");
    private static boolean USE_UNVERIFIED = false;
    private static boolean SKIP_PERSISTENCE = false;
    private static boolean CHECK_EXISTENCE = true;
    private static final boolean VERBOSE_ENTRY;
    private static final boolean VERBOSE_HELPER;
    private static final boolean VERBOSE_WATCHER;
    private static final boolean VERBOSE_LISTENER;
    private static final boolean VERBOSE_PERSIST;
    private static final boolean VERBOSE_CACHE;
    private static final boolean VERBOSE_FILTER;
    private static final String VERBOSE_ENTRY_PREFIX = "VFS/ENTRY: ";
    private static final Object ENABLED_LOCK;
    private static boolean _enabled;
    private static boolean _watcherEnabled;
    private static List<VirtualFileSystemHelper> vfsList;
    private static final String VERBOSE_HELPER_PREFIX = "VFS/HELPER: ";
    private final Collection<URL> _pendingUrlList = new HashSet<URL>();
    private final Collection<URL> _disableUrlList = new HashSet<URL>();
    private final HashMap<URL, DirectoryWatcher> _urlToWatchMap = new HashMap(50);
    private final HashSet<URL> _failedURLSet = new HashSet();
    private static final String VERBOSE_WATCHER_PREFIX = "VFS/WATCHER: ";
    private DWListener _listener = new DWListener();
    private static final String VERBOSE_LISTENER_PREFIX = "VFS/LISTENER: ";
    private boolean _loaded = false;
    private static final String NS_KEY_PREFIX = "$VFSData$";
    private static final String DATA_KEY = "VFSData";
    private static final String VERBOSE_PERSIST_PREFIX = "VFS/PERSIST: ";
    private boolean _isFile = false;
    private static final String VERBOSE_CACHE_PREFIX = "VFS/CACHE: ";
    private static final DirEntry DIR_NON_EXISTENT;
    private static final URLFileSystem.FileInfo FILE_NON_EXISTENT;
    private static final String VERBOSE_FILTER_PREFIX = "VFS/FILTER: ";
    private final HashMap<URL, Set<Object>> _activeRootMap = new HashMap(50);
    private static final int CACHE_SIZE = 500;
    private final Map<URL, URL> _activeRootCache = new Maps.CacheMap(500, Maps.CacheMap.NOT_CANONICAL);
    private final HashMap<URL, DirEntry> _urlToDirEntryMap = new HashMap(1000);
    private static final int PROCESS_REMOVE = 1;
    private static final int PROCESS_INVALIDATE = 2;
    private static final int PROCESS_UNVERIFIED = 3;
    private static final AssemblyFactory FILE_INFO_FACTORY;
    private static final AssemblyFactory FP_FILE_INFO_FACTORY;
    private static final AssemblyFactory DIR_ENTRY_FACTORY;
    private static final AssemblyFactory FP_DIR_ENTRY_FACTORY;
    private static final AssemblyFactory DIR_ENTRY_ARRAY_FACTORY;
    private static final AssemblyFactory FP_DIR_ENTRY_ARRAY_FACTORY;

    public VirtualFileSystemHelper(URLFileSystemHelper helper) {
        super(helper);
        VirtualFileSystemHelper.registerVFS(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableVFS() {
        if (ENABLED) {
            if (VERBOSE_ENTRY) {
                Assert.println((String)"VFS/ENTRY: enableVFS() entry");
            }
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _enabled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void enableNativeWatching() {
        if (ENABLED) {
            if (VERBOSE_ENTRY) {
                Assert.println((String)"VFS/ENTRY: enableNativeWatching() entry");
            }
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _watcherEnabled = true;
            }
            int numHelpers = vfsList.size();
            for (int i = 0; i < numHelpers; ++i) {
                VirtualFileSystemHelper vfsHelper = vfsList.get(i);
                vfsHelper.updateDirectoryTracking();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdownVFS() {
        if (ENABLED) {
            if (VERBOSE_ENTRY) {
                Assert.println((String)"VFS/ENTRY: shutdownVFS() entry");
            }
            Object object = ENABLED_LOCK;
            synchronized (object) {
                _enabled = false;
            }
            int numHelpers = vfsList.size();
            for (int i = 0; i < numHelpers; ++i) {
                VirtualFileSystemHelper vfsHelper = vfsList.get(i);
                vfsHelper.saveDirData();
            }
        }
    }

    public static synchronized void invalidateDirectory(URL dirURL) {
        VirtualFileSystemHelper.invalidateDirectoryImpl(dirURL, false);
    }

    public static synchronized void invalidateDirectoryTree(URL rootDirURL) {
        VirtualFileSystemHelper.invalidateDirectoryImpl(rootDirURL, true);
    }

    public static synchronized void setVerifyPersistedData(boolean verify) {
        String property = System.getProperty("VFS_USE_UNVERIFIED");
        if (property != null) {
            Assert.println((String)("VFS: setVerifyPersistedData( " + verify + " ) overrided by VFS_USE_UNVERIFIED ( " + USE_UNVERIFIED + ")"));
            return;
        }
        USE_UNVERIFIED = !verify;
        Assert.println((String)("VFS: USE_UNVERIFIED = " + USE_UNVERIFIED));
    }

    private static synchronized void cacheDirectoryTree(URL rootDirURL, Object cookie) {
        if (ENABLED) {
            VirtualFileSystemHelper vfsHelper;
            if (VERBOSE_ENTRY) {
                Assert.println((String)("VFS/ENTRY: cacheDirectoryTree() entry url = " + rootDirURL.toString()));
            }
            if ((vfsHelper = VirtualFileSystemHelper.findVFSHelper(rootDirURL)) != null) {
                vfsHelper.activateDirectory(rootDirURL, cookie);
                vfsHelper.addToDirectoryTracking(rootDirURL);
            }
        }
    }

    private static synchronized void uncacheDirectoryTree(URL rootDirURL, Object cookie) {
        if (ENABLED) {
            VirtualFileSystemHelper vfsHelper;
            if (VERBOSE_ENTRY) {
                Assert.println((String)("VFS/ENTRY: uncacheDirectoryTree() entry url = " + rootDirURL.toString()));
            }
            if ((vfsHelper = VirtualFileSystemHelper.findVFSHelper(rootDirURL)) != null) {
                vfsHelper.deactivateDirectory(rootDirURL, cookie);
                vfsHelper.resyncDirectoryTracking();
            }
        }
    }

    private static void invalidateDirectoryImpl(URL dirURL, boolean recurse) {
        if (ENABLED) {
            VirtualFileSystemHelper vfsHelper;
            if (VERBOSE_ENTRY) {
                Assert.println((String)("VFS/ENTRY: cacheDirectoryTree() entry recurse = " + recurse + " url = " + dirURL.toString()));
            }
            if ((vfsHelper = VirtualFileSystemHelper.findVFSHelper(dirURL)) != null) {
                vfsHelper.invalidateDirEntry(dirURL, recurse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEnabled() {
        Object object = ENABLED_LOCK;
        synchronized (object) {
            return _enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isWatcherEnabled() {
        Object object = ENABLED_LOCK;
        synchronized (object) {
            return _watcherEnabled && NativeHandler.isLoaded();
        }
    }

    private static synchronized void registerVFS(VirtualFileSystemHelper vfsHelper) {
        if (VERBOSE_ENTRY) {
            Assert.println((String)("VFS/ENTRY: registerVFS() helper = " + vfsHelper._helper.getClass().getName()));
        }
        vfsList.add(vfsHelper);
    }

    public void delete(URL url) throws IOException {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: delete() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            this.disableDirectoryTrackingFor(url, true);
        }
        try {
            this._helper.delete(url);
            if (VirtualFileSystemHelper.isEnabled()) {
                this.removeCachedDirEntry(url);
                this.markParentDirty(url);
            }
        }
        finally {
            if (VirtualFileSystemHelper.isEnabled()) {
                this.updateDirectoryTracking();
            }
        }
    }

    public boolean exists(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: exists() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            return fileInfo != FILE_NON_EXISTENT;
        }
        return this._helper.exists(url);
    }

    public long getLength(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: getLength() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return -1L;
            }
            return fileInfo.length();
        }
        return this._helper.getLength(url);
    }

    public boolean isDirectory(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: isDirectory() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isDirectory();
        }
        return this._helper.isDirectory(url);
    }

    public boolean isHidden(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: isHidden() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isHidden();
        }
        return this._helper.isHidden(url);
    }

    public boolean isRegularFile(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: isRegularFile() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return false;
            }
            return fileInfo.isFile();
        }
        return this._helper.isRegularFile(url);
    }

    public long lastModified(URL url) {
        URLFileSystem.FileInfo fileInfo;
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: lastModified() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled() && (fileInfo = this.findCachedFileInfo(url)) != null) {
            if (fileInfo == FILE_NON_EXISTENT) {
                return -1L;
            }
            return fileInfo.lastModified();
        }
        return this._helper.lastModified(url);
    }

    public URL[] list(URL url) {
        return this.list(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] list(URL url, URLFilter filter) {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: list() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            ArrayList<URL> results;
            DirEntry foundEntry = this.findOrFetchDirEntry(url);
            if (foundEntry == null || this.isDirEntryNonExistent(foundEntry)) {
                return null;
            }
            DirEntry dirEntry = foundEntry;
            synchronized (dirEntry) {
                int numInfos = foundEntry._files.length;
                results = new ArrayList<URL>(numInfos);
                for (int i = 0; i < numInfos; ++i) {
                    results.add(foundEntry._files[i].getURL());
                }
            }
            if (filter != null) {
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    URL infoUrl = (URL)iterator.next();
                    if (filter.accept(infoUrl)) continue;
                    iterator.remove();
                }
            }
            return results.toArray(new URL[results.size()]);
        }
        return this._helper.list(url, filter);
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        return this.ls(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: ls() entry url = " + url.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            ArrayList<URLFileSystem.FileInfo> results;
            DirEntry foundEntry = this.findOrFetchDirEntry(url);
            if (foundEntry == null || this.isDirEntryNonExistent(foundEntry)) {
                return null;
            }
            DirEntry dirEntry = foundEntry;
            synchronized (dirEntry) {
                int numInfos = foundEntry._files.length;
                results = new ArrayList<URLFileSystem.FileInfo>(numInfos);
                for (int i = 0; i < numInfos; ++i) {
                    URLFileSystem.FileInfo info = foundEntry._files[i];
                    if (info == null) continue;
                    results.add(info);
                }
            }
            if (filter != null) {
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    URLFileSystem.FileInfo info = (URLFileSystem.FileInfo)iterator.next();
                    if (filter.accept(info.getURL())) continue;
                    iterator.remove();
                }
            }
            return results.toArray(new URLFileSystem.FileInfo[results.size()]);
        }
        return this._helper.ls(url, filter);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        return this.ls(url);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        return this.ls(url, filter);
    }

    public boolean mkdir(URL url) {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: mkdir() entry url = " + url.toString()));
        }
        boolean success = this._helper.mkdir(url);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markParentDirty(url);
            this.updateDirectoryTracking();
        }
        return success;
    }

    public boolean mkdirs(URL url) {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: mkdirs() entry url = " + url.toString()));
        }
        boolean success = this._helper.mkdirs(url);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markClosestParentDirty(url);
            this.updateDirectoryTracking();
        }
        return success;
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return this._helper.createTempFile(prefix, suffix, directory);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: openOutputStream() entry url = " + url.toString()));
        }
        OutputStream os = this._helper.openOutputStream(url);
        if (VirtualFileSystemHelper.isEnabled() && os != null) {
            this.markClosestParentDirty(url);
        }
        return os;
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: renameTo() old url = " + oldURL.toString()));
            Assert.println((String)("VFS/HELPER: renameTo() new url = " + newURL.toString()));
        }
        if (VirtualFileSystemHelper.isEnabled()) {
            this.disableDirectoryTrackingFor(oldURL, true);
        }
        try {
            this._helper.rename(oldURL, newURL);
            if (VirtualFileSystemHelper.isEnabled()) {
                this.removeCachedDirEntry(oldURL);
                this.markParentDirty(oldURL);
                this.markClosestParentDirty(newURL);
            }
        }
        finally {
            if (VirtualFileSystemHelper.isEnabled()) {
                this.updateDirectoryTracking();
            }
        }
    }

    public boolean setLastModified(URL url, long time) {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: setLastModified() url = " + url.toString()));
        }
        boolean success = this._helper.setLastModified(url, time);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markParentDirty(url);
        }
        return success;
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        if (VERBOSE_HELPER) {
            Assert.println((String)("VFS/HELPER: setReadOnly() url = " + url.toString()));
        }
        boolean success = this._helper.setReadOnly(url, readOnly);
        if (VirtualFileSystemHelper.isEnabled() && success) {
            this.markParentDirty(url);
        }
        return success;
    }

    public void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        VirtualFileSystemHelper.cacheDirectoryTree(rootURL, listener);
        this._helper.addURLFileSystemListener(rootURL, listener);
    }

    public void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        VirtualFileSystemHelper.uncacheDirectoryTree(rootURL, listener);
        this._helper.removeURLFileSystemListener(rootURL, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDirectoryTracking(URL dirURL) {
        if (VERBOSE_WATCHER) {
            Assert.println((String)("VFS/WATCHER: addToDirectoryTracking() url = " + dirURL.toString()));
        }
        Collection<URL> collection = this._pendingUrlList;
        synchronized (collection) {
            this._pendingUrlList.add(dirURL);
        }
        this.updateDirectoryTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncDirectoryTracking() {
        if (VERBOSE_WATCHER) {
            Assert.println((String)"VFS/WATCHER: resyncDirectoryTracking()");
        }
        URL[] activeURLs = this.getActiveDirectories();
        Collection<URL> collection = this._pendingUrlList;
        synchronized (collection) {
            Collection<URL> collection2 = this._disableUrlList;
            synchronized (collection2) {
                HashMap<URL, DirectoryWatcher> hashMap = this._urlToWatchMap;
                synchronized (hashMap) {
                    ArrayList<URL> activeList = new ArrayList<URL>(Arrays.asList(activeURLs));
                    HashSet<URL> watchList = new HashSet<URL>();
                    watchList.addAll(this._pendingUrlList);
                    watchList.addAll(this._disableUrlList);
                    watchList.addAll(this._failedURLSet);
                    watchList.addAll(this._urlToWatchMap.keySet());
                    HashSet<URL> removeList = watchList;
                    removeList.removeAll(activeList);
                    for (URL url : removeList) {
                        if (VERBOSE_WATCHER) {
                            Assert.println((String)("VFS/WATCHER: resyncDirectoryTracking() removing = " + url.toString()));
                        }
                        this.disableDirectoryTrackingFor(url, false);
                    }
                    this._pendingUrlList.removeAll(removeList);
                    this._disableUrlList.removeAll(removeList);
                    this._failedURLSet.removeAll(removeList);
                }
            }
        }
    }

    private void updateDirectoryTracking() {
        if (VERBOSE_WATCHER) {
            Assert.println((String)"VFS/WATCHER: updateDirectoryTracking() entry");
        }
        if (!VirtualFileSystemHelper.isWatcherEnabled() || !this.isFileProtocol()) {
            return;
        }
        if (VERBOSE_WATCHER) {
            Assert.println((String)"VFS/WATCHER: updateDirectoryTracking() enable pending");
        }
        this.enableDirectoryTrackingFor(this._pendingUrlList);
        if (VERBOSE_WATCHER) {
            Assert.println((String)"VFS/WATCHER: updateDirectoryTracking() re-enable disabled");
        }
        this.enableDirectoryTrackingFor(this._disableUrlList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableDirectoryTrackingFor(Collection<URL> urlList) {
        if (VERBOSE_WATCHER) {
            Assert.println((String)("VFS/WATCHER: enableDirectoryTrackingFor(), list count = " + urlList.size()));
        }
        Collection<URL> collection = urlList;
        synchronized (collection) {
            if (urlList.isEmpty()) {
                return;
            }
            Iterator<URL> iterator = urlList.iterator();
            while (iterator.hasNext()) {
                this.enableDirectoryTrackingFor(iterator.next());
            }
            urlList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableDirectoryTrackingFor(URL dirURL) {
        if (this._urlToWatchMap.containsKey(dirURL)) {
            if (VERBOSE_WATCHER) {
                Assert.println((String)("VFS/WATCHER: enableDirectoryTrackingFor(), skipping existing = " + dirURL.toString()));
            }
            HashSet<URL> hashSet = this._failedURLSet;
            synchronized (hashSet) {
                this._failedURLSet.remove(dirURL);
            }
            return;
        }
        DirectoryWatcher watcher = DirectoryWatcher.createDirectoryWatcher((URL)dirURL, (DirectoryWatcher.DirectoryListener)this._listener);
        if (watcher != null) {
            if (VERBOSE_WATCHER) {
                Assert.println((String)("VFS/WATCHER: enableDirectoryTrackingFor(), watch created = " + dirURL.toString()));
            }
            Cloneable cloneable = this._urlToWatchMap;
            synchronized (cloneable) {
                this._urlToWatchMap.put(dirURL, watcher);
            }
            cloneable = this._failedURLSet;
            synchronized (cloneable) {
                this._failedURLSet.remove(dirURL);
            }
        }
        if (VERBOSE_WATCHER) {
            Assert.println((String)("VFS/WATCHER: enableDirectoryTrackingFor(), failed creation = " + dirURL.toString()));
        }
        HashSet<URL> hashSet = this._failedURLSet;
        synchronized (hashSet) {
            this._failedURLSet.add(dirURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableDirectoryTrackingFor(URL dirURL, boolean includeNested) {
        DirectoryWatcher watcher;
        if (!URLFileSystem.isDirectoryPath((URL)dirURL)) {
            return;
        }
        if (VERBOSE_WATCHER) {
            Assert.println((String)("VFS/WATCHER: disableDirectoryTrackingFor() url = " + dirURL.toString()));
        }
        int disabledCount = 0;
        HashMap<URL, DirectoryWatcher> hashMap = this._urlToWatchMap;
        synchronized (hashMap) {
            watcher = this._urlToWatchMap.remove(dirURL);
        }
        if (watcher != null) {
            this.disableDirectoryWatcher(watcher);
            ++disabledCount;
        }
        if (includeNested) {
            hashMap = this._urlToWatchMap;
            synchronized (hashMap) {
                Iterator<URL> enabledIterator = this._urlToWatchMap.keySet().iterator();
                while (enabledIterator.hasNext()) {
                    URL checkURL = enabledIterator.next();
                    if (!URLFileSystem.isBaseURLFor((URL)dirURL, (URL)checkURL)) continue;
                    watcher = this._urlToWatchMap.get(checkURL);
                    enabledIterator.remove();
                    this.disableDirectoryWatcher(watcher);
                    ++disabledCount;
                }
            }
        }
        if (VERBOSE_WATCHER && disabledCount == 0) {
            Assert.println((String)("VFS/WATCHER: disableDirectoryTrackingFor() no watch for = " + dirURL.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableDirectoryWatcher(DirectoryWatcher watcher) {
        URL dirURL = watcher.getRootURL();
        if (VERBOSE_WATCHER) {
            Assert.println((String)("VFS/WATCHER: disableDirectoryTrackingFor() disabled url = " + dirURL.toString()));
        }
        DirectoryWatcher.destroyDirectoryWatcher((DirectoryWatcher)watcher);
        Collection<URL> collection = this._disableUrlList;
        synchronized (collection) {
            this._disableUrlList.add(dirURL);
        }
    }

    protected String getNameSpaceKey() {
        URLFileSystemHelper helper = this._helper;
        while (helper instanceof URLFileSystemHelperDecorator) {
            helper = ((URLFileSystemHelperDecorator)helper).getHelper();
        }
        return NS_KEY_PREFIX + helper.getClass().getName();
    }

    private NameSpace getNameSpace() {
        NameSpace namespace;
        String keyName = this.getNameSpaceKey();
        if (VERBOSE_PERSIST) {
            Assert.println((String)("VFS/PERSIST: getNameSpace() key = " + keyName));
        }
        if ((namespace = NameSpace.getNameSpace((String)keyName)) == null && VERBOSE_PERSIST) {
            Assert.println((String)("VFS/PERSIST: getNameSpace() no data for key = " + keyName));
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDataLoaded() {
        if (!this._loaded && VirtualFileSystemHelper.isEnabled()) {
            HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
            synchronized (hashMap) {
                if (!this._loaded) {
                    this.loadDirData();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirData() {
        if (VERBOSE_PERSIST) {
            Assert.println((String)"VFS/PERSIST: loadDirData() entry");
        }
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!this._loaded) {
                NameSpace namespace;
                this.checkIfIsFileProtocol();
                if (VERBOSE_PERSIST) {
                    Assert.println((String)("VFS/PERSIST: loadDirData() isfile = " + this.isFileProtocol() + " helper = " + this._helper.getClass().getName()));
                }
                this._urlToDirEntryMap.clear();
                if (!SKIP_PERSISTENCE && (namespace = this.getNameSpace()) != null) {
                    try {
                        long start = System.currentTimeMillis();
                        byte[] data = namespace.getRecord(DATA_KEY);
                        long total = System.currentTimeMillis() - start;
                        if (data != null) {
                            if (VERBOSE_PERSIST) {
                                Assert.printTiming((long)total, (String)("VFS/PERSIST: loadDirData() bytes read = " + data.length), null);
                            }
                            start = System.currentTimeMillis();
                            Object[] dirEntries = (Object[])(this.isFileProtocol() ? FP_DIR_ENTRY_ARRAY_FACTORY.assemble(data) : DIR_ENTRY_ARRAY_FACTORY.assemble(data));
                            int numEntries = dirEntries != null ? dirEntries.length : 0;
                            for (int i = 0; i < numEntries; ++i) {
                                DirEntry dirEntry = (DirEntry)dirEntries[i];
                                if (dirEntry == null) continue;
                                URL dirURL = dirEntry._dirURL;
                                DirEntry dirEntry2 = dirEntry;
                                dirEntry2._flags = (byte)(dirEntry2._flags | 4);
                                this._urlToDirEntryMap.put(dirURL, dirEntry);
                            }
                            total = System.currentTimeMillis() - start;
                            if (VERBOSE_PERSIST) {
                                Assert.printTiming((long)total, (String)("VFS/PERSIST: loadDirData() entries loaded = " + numEntries), null);
                            }
                        } else if (VERBOSE_PERSIST) {
                            Assert.println((String)"VFS/PERSIST: loadDirData() no data found");
                        }
                    }
                    catch (AssemblyException e) {
                        Assert.println((String)"Warning: Cannot load VFS data");
                        Assert.printStackTrace((Throwable)e);
                        namespace.delRecord(DATA_KEY);
                        namespace.flush();
                    }
                }
                this._loaded = true;
                this.updateDirectoryTracking();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDirData() {
        if (VERBOSE_PERSIST) {
            Assert.println((String)"VFS/PERSIST: saveDirData() entry");
        }
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (VERBOSE_PERSIST) {
                Assert.println((String)("VFS/PERSIST: saveDirData() isfile = " + this.isFileProtocol() + " helper = " + this._helper.getClass().getName()));
            }
            if (!SKIP_PERSISTENCE) {
                try {
                    NameSpace namespace = this.getNameSpace();
                    if (namespace != null) {
                        long start = System.currentTimeMillis();
                        Object[] dirEntries = this._urlToDirEntryMap.values().toArray();
                        byte[] data = this.isFileProtocol() ? FP_DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)dirEntries) : DIR_ENTRY_ARRAY_FACTORY.disassemble((Object)dirEntries);
                        long total = System.currentTimeMillis() - start;
                        if (VERBOSE_PERSIST) {
                            Assert.printTiming((long)total, (String)("VFS/PERSIST: saveDirData() entries saved = " + dirEntries.length), null);
                        }
                        start = System.currentTimeMillis();
                        namespace.putRecord(DATA_KEY, data);
                        namespace.flush();
                        total = System.currentTimeMillis() - start;
                        if (VERBOSE_PERSIST) {
                            Assert.printTiming((long)total, (String)("VFS/PERSIST: saveDirData() bytes written = " + data.length), null);
                        }
                    }
                }
                catch (AssemblyException e) {
                    Assert.println((String)"Warning: Cannot save VFS data");
                    Assert.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private boolean isFileProtocol() {
        return this._isFile;
    }

    private void checkIfIsFileProtocol() {
        URLFileSystemHelper fileHelper = URLFileSystem.findHelper((String)"file");
        VirtualFileSystemHelper vfsHelper = VirtualFileSystemHelper.findVFSHelper(fileHelper);
        if (vfsHelper == this) {
            this._isFile = true;
        }
        if (VERBOSE_PERSIST) {
            Assert.println((String)("VFS/PERSIST: checkIfIsFileProtocol() check = " + this._isFile));
        }
    }

    private static VirtualFileSystemHelper findVFSHelper(URL url) {
        return VirtualFileSystemHelper.findVFSHelper(URLFileSystem.findHelper((URL)url));
    }

    private static VirtualFileSystemHelper findVFSHelper(URLFileSystemHelper helper) {
        while (true) {
            if (helper instanceof VirtualFileSystemHelper) {
                return (VirtualFileSystemHelper)helper;
            }
            if (!(helper instanceof URLFileSystemHelperDecorator)) break;
            helper = ((URLFileSystemHelperDecorator)helper).getHelper();
        }
        return null;
    }

    private void markDirDirty(URL dirURL) {
        DirEntry foundEntry;
        if (dirURL != null && (foundEntry = this.lookupCacheImpl(dirURL)) != null) {
            this.markDirEntryDirty(foundEntry);
        }
    }

    private void markParentDirty(URL url) {
        URL dirURL;
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: markParentDirty() entry url = " + url.toString()));
        }
        if ((dirURL = this.getParent(url)) != null) {
            this.markDirDirty(dirURL);
            URL parentURL = this.getParent(dirURL);
            if (parentURL != null) {
                this.markDirDirty(parentURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClosestParentDirty(URL url) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: markClosestParentDirty() entry url = " + url.toString()));
        }
        URL currentURL = url;
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            while (currentURL != null) {
                DirEntry foundEntry = this.lookupCacheImpl(currentURL);
                if (foundEntry != null) {
                    this.markDirEntryDirty(foundEntry);
                    URL parentURL = this.getParent(currentURL);
                    if (parentURL == null) break;
                    this.markDirDirty(parentURL);
                    break;
                }
                currentURL = this.getParent(currentURL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateDirEntry(URL dirURL, boolean recurse) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: invalidateDirEntry() recurse = " + recurse + " dirURL = " + dirURL.toString()));
        }
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (!recurse) {
                DirEntry foundEntry = this.lookupCacheImpl(dirURL);
                if (foundEntry != null) {
                    this.markDirEntryDirty(foundEntry);
                }
            } else {
                this.processChildrenCacheImpl(dirURL, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLFileSystem.FileInfo findCachedFileInfo(URL url) {
        DirEntry dirEntry;
        URL dirURL;
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: findCachedFileInfo() url = " + url.toString()));
        }
        if ((dirURL = this.getParent(url)) != null && (dirEntry = this.findCachedDirEntry(dirURL)) != null) {
            if (this.isDirEntryNonExistent(dirEntry)) {
                return FILE_NON_EXISTENT;
            }
            DirEntry dirEntry2 = dirEntry;
            synchronized (dirEntry2) {
                URLFileSystem.FileInfo[] infos = dirEntry._files;
                int numInfos = infos.length;
                for (int i = 0; i < numInfos; ++i) {
                    if (!url.equals(infos[i].getURL())) continue;
                    if (VERBOSE_CACHE) {
                        Assert.println((String)("VFS/CACHE: findCachedFileInfo() found url = " + url.toString()));
                    }
                    return infos[i];
                }
                if (CHECK_EXISTENCE && this.isFileProtocol()) {
                    String dirPath = dirURL.getPath();
                    boolean possibleMatch = false;
                    for (int i = 0; i < numInfos; ++i) {
                        if (!dirPath.equalsIgnoreCase(infos[i].getURL().getPath())) continue;
                        possibleMatch = true;
                    }
                    if (!possibleMatch) {
                        return FILE_NON_EXISTENT;
                    }
                }
            }
        }
        return null;
    }

    private boolean couldExist(URL url, URL rootURL) {
        if (this.isFileProtocol()) {
            String path;
            String topPath = rootURL.getPath();
            int barrierLength = topPath.length();
            while ((path = url.getPath()).length() > barrierLength) {
                URL parent = this.getParent(url);
                DirEntry dirEntry = this.lookupCacheImpl(parent);
                if (dirEntry != null) {
                    if (this.isDirEntryValid(dirEntry)) {
                        for (URLFileSystem.FileInfo fileInfo : dirEntry._files) {
                            URL infoUrl = fileInfo.getURL();
                            if (!path.equalsIgnoreCase(infoUrl.getPath())) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
                url = parent;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry findCachedDirEntry(URL dirURL) {
        URL activeRoot;
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: findCachedDirEntry() entry url = " + dirURL.toString()));
        }
        if ((activeRoot = this.getActiveRoot(dirURL)) == null) {
            return null;
        }
        DirEntry foundEntry = this.lookupCacheImpl(dirURL);
        if (foundEntry == null) {
            if (VERBOSE_CACHE) {
                Assert.println((String)("VFS/CACHE: findCachedDirEntry() not cached url = " + dirURL.toString()));
            }
            if (CHECK_EXISTENCE && !this.couldExist(dirURL, activeRoot)) {
                return DIR_NON_EXISTENT;
            }
            return null;
        }
        DirEntry dirEntry = foundEntry;
        synchronized (dirEntry) {
            if (!this.isDirEntryValid(foundEntry)) {
                if (VERBOSE_CACHE) {
                    Assert.println((String)("VFS/CACHE: findCachedDirEntry() stale url = " + dirURL.toString()));
                }
                return null;
            }
        }
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: findCachedDirEntry() valid cached url = " + dirURL.toString()));
        }
        return foundEntry;
    }

    private void removeCachedDirEntry(URL dirURL) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: removeCachedDirEntry() url = " + dirURL.toString()));
        }
        this.processChildrenCacheImpl(dirURL, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry findOrFetchDirEntry(URL dirURL) {
        URL reuseURL;
        DirEntry returnEntry;
        URL activeRoot;
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() entry url = " + dirURL.toString()));
        }
        boolean isActiveDir = (activeRoot = this.getActiveRoot(dirURL)) != null;
        DirEntry cachedEntry = this.lookupCacheImpl(dirURL);
        if (isActiveDir) {
            if (cachedEntry != null) {
                DirEntry dirEntry = cachedEntry;
                synchronized (dirEntry) {
                    if (this.isDirEntryValid(cachedEntry)) {
                        if (VERBOSE_CACHE) {
                            Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() valid cached url = " + dirURL.toString()));
                        }
                        return cachedEntry;
                    }
                    if (VERBOSE_CACHE) {
                        Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() stale url = " + dirURL.toString()));
                    }
                }
            } else if (CHECK_EXISTENCE && !this.couldExist(dirURL, activeRoot)) {
                return null;
            }
        }
        if ((returnEntry = this.fetchDirFromHelper(reuseURL = cachedEntry != null ? cachedEntry._dirURL : dirURL)) == null) {
            if (VERBOSE_CACHE) {
                Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() not found url = " + dirURL.toString()));
            }
            if (cachedEntry != null) {
                if (VERBOSE_CACHE) {
                    Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() clear stale url = " + dirURL.toString()));
                }
                this.processChildrenCacheImpl(dirURL, 1);
            }
            if (isActiveDir && !activeRoot.equals(dirURL)) {
                DirEntry nonExistentEntry = new DirEntry();
                nonExistentEntry._dirURL = reuseURL;
                nonExistentEntry._flags = (byte)8;
                DirEntry.access$002(nonExistentEntry, DIR_NON_EXISTENT._files);
                this.storeCacheImpl(nonExistentEntry);
                return nonExistentEntry;
            }
        } else {
            if (VERBOSE_CACHE) {
                Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() fetched url = " + dirURL.toString()));
            }
            if (isActiveDir || cachedEntry != null) {
                this.storeCacheImpl(returnEntry);
            }
            if (isActiveDir) {
                HashSet<URL> nonExistentEntry = this._failedURLSet;
                synchronized (nonExistentEntry) {
                    if (this._failedURLSet.contains(dirURL)) {
                        this.enableDirectoryTrackingFor(dirURL);
                    }
                }
            }
            if (cachedEntry != null) {
                if (VERBOSE_CACHE) {
                    Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() clean stale url = " + dirURL.toString()));
                }
                HashSet<URL> oldSet = new HashSet<URL>();
                URLFileSystem.FileInfo[] cachedFileInfos = cachedEntry._files;
                int numCachedInfos = cachedFileInfos.length;
                for (int i = 0; i < numCachedInfos; ++i) {
                    URLFileSystem.FileInfo cachedInfo = cachedFileInfos[i];
                    if (!cachedInfo.isDirectory()) continue;
                    oldSet.add(cachedFileInfos[i].getURL());
                }
                URLFileSystem.FileInfo[] fetchedFileInfos = returnEntry._files;
                int numFetchedInfos = fetchedFileInfos.length;
                for (int i = 0; i < numFetchedInfos; ++i) {
                    URLFileSystem.FileInfo fetchedInfo = fetchedFileInfos[i];
                    if (!fetchedInfo.isDirectory()) continue;
                    oldSet.remove(fetchedFileInfos[i].getURL());
                }
                for (URL obseleteURL : oldSet) {
                    this.processChildrenCacheImpl(obseleteURL, 1);
                    if (!VERBOSE_CACHE) continue;
                    Assert.println((String)("VFS/CACHE: findOrFetchDirEntry() removing child url = " + obseleteURL.toString()));
                }
            }
        }
        return returnEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateDirectory(URL rootDirURL, Object cookie) {
        if (VERBOSE_FILTER) {
            Assert.println((String)("VFS/FILTER: activateDirectory() url = " + rootDirURL.toString() + " cookie = " + cookie.toString()));
        }
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set<Object> cookieSet = this._activeRootMap.get(rootDirURL);
            if (cookieSet == null) {
                cookieSet = new HashSet<Object>(5);
                this._activeRootMap.put(rootDirURL, cookieSet);
                this.processChildrenCacheImpl(rootDirURL, 3);
            }
            cookieSet.add(cookie);
            this._activeRootCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateDirectory(URL rootDirURL, Object cookie) {
        if (VERBOSE_FILTER) {
            Assert.println((String)("VFS/FILTER: deactivateDirectory() url = " + rootDirURL.toString() + " cookie = " + cookie.toString()));
        }
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set<Object> cookieSet = this._activeRootMap.get(rootDirURL);
            if (cookieSet != null) {
                cookieSet.remove(cookie);
                if (cookieSet.isEmpty()) {
                    this._activeRootMap.remove(rootDirURL);
                }
                this._activeRootCache.clear();
            } else {
                Assert.printStackTrace((Throwable)new IllegalStateException("VFS Warning, empty cookie set"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL[] getActiveDirectories() {
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            Set<URL> keySet = this._activeRootMap.keySet();
            return keySet.toArray(new URL[keySet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getActiveRoot(URL dirURL) {
        URL activeURL = null;
        HashMap<URL, Set<Object>> hashMap = this._activeRootMap;
        synchronized (hashMap) {
            if (this._activeRootMap.containsKey(dirURL)) {
                return dirURL;
            }
            activeURL = this._activeRootCache.get(dirURL);
            if (activeURL != null || this._activeRootCache.containsKey(dirURL)) {
                return activeURL;
            }
            activeURL = this.getParent(dirURL);
            while (activeURL != null && !this._activeRootMap.containsKey(activeURL)) {
                activeURL = this.getParent(activeURL);
            }
            this._activeRootCache.put(dirURL, activeURL);
        }
        if (VERBOSE_FILTER) {
            Assert.println((String)("VFS/FILTER: getActiveRoot() root = " + activeURL + " url = " + dirURL.toString()));
        }
        return activeURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirEntryDirty(DirEntry dirEntry) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: markDirEntryDirty() marking = " + dirEntry._dirURL.toString()));
        }
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            DirEntry dirEntry3 = dirEntry;
            dirEntry3._flags = (byte)(dirEntry3._flags | 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markDirEntryUnverified(DirEntry dirEntry) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: markDirEntryDirty() marking = " + dirEntry._dirURL.toString()));
        }
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            DirEntry dirEntry3 = dirEntry;
            dirEntry3._flags = (byte)(dirEntry3._flags | 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirEntry lookupCacheImpl(URL dirURL) {
        DirEntry foundEntry;
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: lookupCacheImpl() entry url = " + dirURL.toString()));
        }
        this.ensureDataLoaded();
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            foundEntry = this._urlToDirEntryMap.get(dirURL);
        }
        return foundEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCacheImpl(DirEntry dirEntry) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: storeCacheImpl() entry url = " + dirEntry._dirURL.toString()));
        }
        this.ensureDataLoaded();
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            if (dirEntry != null) {
                if (VERBOSE_CACHE) {
                    Assert.println((String)("VFS/CACHE: storeCacheImpl() caching url = " + dirEntry._dirURL.toString()));
                }
                this._urlToDirEntryMap.put(dirEntry._dirURL, dirEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenCacheImpl(URL rootDirURL, int howToProcess) {
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: processChildrenCacheImpl() entry how = " + howToProcess + " url = " + rootDirURL.toString()));
        }
        this.ensureDataLoaded();
        HashMap<URL, DirEntry> hashMap = this._urlToDirEntryMap;
        synchronized (hashMap) {
            String dirPath = rootDirURL.getPath();
            Collection<DirEntry> entries = this._urlToDirEntryMap.values();
            Iterator<DirEntry> entryIterator = entries.iterator();
            while (entryIterator.hasNext()) {
                DirEntry entry = entryIterator.next();
                URL checkURL = entry._dirURL;
                boolean process = false;
                if (this.isFileProtocol()) {
                    String checkPath = checkURL.getPath();
                    if (checkPath.startsWith(dirPath)) {
                        process = true;
                    }
                } else if (checkURL.equals(rootDirURL) || this.isBaseURLFor(rootDirURL, checkURL)) {
                    process = true;
                }
                if (!process) continue;
                if (VERBOSE_CACHE) {
                    Assert.println((String)("VFS/CACHE: processChildrenCacheImpl() processing url = " + checkURL.toString()));
                }
                switch (howToProcess) {
                    case 1: {
                        entryIterator.remove();
                        break;
                    }
                    case 2: {
                        this.markDirEntryDirty(entry);
                        break;
                    }
                    case 3: {
                        this.markDirEntryUnverified(entry);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryDirty(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            return VirtualFileSystemHelper.isFlagSet(dirEntry._flags, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryUnverified(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            return VirtualFileSystemHelper.isFlagSet(dirEntry._flags, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryNonExistent(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            return dirEntry == DIR_NON_EXISTENT || VirtualFileSystemHelper.isFlagSet(dirEntry._flags, 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirEntryValid(DirEntry dirEntry) {
        DirEntry dirEntry2 = dirEntry;
        synchronized (dirEntry2) {
            boolean dirty = this.isDirEntryDirty(dirEntry);
            boolean unverified = this.isDirEntryUnverified(dirEntry);
            return !dirty && (USE_UNVERIFIED || !unverified);
        }
    }

    private DirEntry fetchDirFromHelper(URL dirURL) {
        URLFileSystem.FileInfo[] fileInfos;
        if (!VirtualFileSystemHelper.isEnabled()) {
            Assert.println((String)"Warning: fetch on disabled VFS");
        }
        if (VERBOSE_CACHE) {
            Assert.println((String)("VFS/CACHE: fetchDirFromHelper() url = " + dirURL.toString()));
        }
        if ((fileInfos = this._helper.ls(dirURL)) != null) {
            if (VERBOSE_CACHE) {
                Assert.println((String)("VFS/CACHE: fetchDirFromHelper() build entry url = " + dirURL.toString()));
            }
            DirEntry entry = new DirEntry();
            entry._dirURL = dirURL;
            entry._flags = (byte)0;
            DirEntry.access$002(entry, entry.convertFileInfos(fileInfos));
            return entry;
        }
        return null;
    }

    private static boolean isFlagSet(int value, int flag) {
        return (value & flag) != 0;
    }

    private static int getAttributes(URLFileSystem.FileInfo fileInfo) {
        int attributes = 0;
        if (fileInfo.isDirectory()) {
            attributes |= 1;
        }
        if (fileInfo.isFile()) {
            attributes |= 2;
        }
        if (fileInfo.isHidden()) {
            attributes |= 4;
        }
        return attributes;
    }

    static {
        String property = System.getProperty("VFS_USE_UNVERIFIED", "false");
        boolean bl = USE_UNVERIFIED = property != null && Boolean.valueOf(property) != false;
        if (USE_UNVERIFIED) {
            Assert.println((String)("VFS: Use of unverified info: " + USE_UNVERIFIED));
        }
        boolean bl2 = SKIP_PERSISTENCE = (property = System.getProperty("VFS_SKIP_PERSISTENCE", "false")) != null && Boolean.valueOf(property) != false;
        if (SKIP_PERSISTENCE) {
            Assert.println((String)("VFS: Skipping of persistence: " + SKIP_PERSISTENCE));
        }
        if (CHECK_EXISTENCE = Boolean.valueOf(System.getProperty("VFS_CHECK_EXISTENCE", "false")).booleanValue()) {
            Assert.println((String)("VFS: Passthrough to file system:VFS_CHECK_EXISTENCE=" + CHECK_EXISTENCE));
        }
        VERBOSE_ENTRY = Boolean.getBoolean("VFS.VERBOSE_ENTRY");
        VERBOSE_HELPER = Boolean.getBoolean("VFS.VERBOSE_HELPER");
        VERBOSE_WATCHER = Boolean.getBoolean("VFS.VERBOSE_WATCHER");
        VERBOSE_LISTENER = Boolean.getBoolean("VFS.VERBOSE_LISTENER");
        VERBOSE_PERSIST = Boolean.getBoolean("VFS.VERBOSE_PERSIST");
        VERBOSE_CACHE = Boolean.getBoolean("VFS.VERBOSE_CACHE");
        VERBOSE_FILTER = Boolean.getBoolean("VFS.VERBOSE_FILTER");
        ENABLED_LOCK = new Object();
        _enabled = false;
        _watcherEnabled = false;
        vfsList = new ArrayList<VirtualFileSystemHelper>();
        DIR_NON_EXISTENT = new DirEntry();
        DIR_NON_EXISTENT._dirURL = URLFactory.newFileURL((String)"non_existing_directory");
        DirEntry.access$002(DIR_NON_EXISTENT, new URLFileSystem.FileInfo[0]);
        URL fileURL = URLFactory.newFileURL((String)"non_existing_file");
        FILE_NON_EXISTENT = new URLFileSystem.FileInfo(fileURL, 0, 0L, 0L);
        FILE_INFO_FACTORY = new FileInfoFactory(false);
        FP_FILE_INFO_FACTORY = new FileInfoFactory(true);
        DIR_ENTRY_FACTORY = new DirEntryFactory(false);
        FP_DIR_ENTRY_FACTORY = new DirEntryFactory(true);
        DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(DIR_ENTRY_FACTORY);
        FP_DIR_ENTRY_ARRAY_FACTORY = new ObjectArrayFactory(FP_DIR_ENTRY_FACTORY);
    }

    private static final class DirEntryFactory
    extends ObjectFactory {
        private boolean _isFileProtocol;
        public static final byte DIR_ENTRY_CODE = -34;
        public static final byte FP_DIR_ENTRY_CODE = -37;

        private DirEntryFactory(boolean isFileProtocol) {
            this._isFileProtocol = isFileProtocol;
        }

        public byte getObjectCode() {
            return this._isFileProtocol ? (byte)-37 : -34;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String urlString = (String)StringFactory.STRING_FACTORY.assemble(input);
            URL dirURL = this._isFileProtocol ? URLFactory.newFileURL((String)urlString) : URLFactory.newURL((String)urlString);
            byte flags = input.readByte();
            int numInfos = input.readInt();
            URLFileSystem.FileInfo[] fileInfos = new URLFileSystem.FileInfo[numInfos];
            for (int i = 0; i < numInfos; ++i) {
                fileInfos[i] = (URLFileSystem.FileInfo)(this._isFileProtocol ? FP_FILE_INFO_FACTORY.assemble(input) : FILE_INFO_FACTORY.assemble(input));
            }
            DirEntry dirEntry = new DirEntry();
            dirEntry._dirURL = dirURL;
            dirEntry._flags = flags;
            DirEntry.access$002(dirEntry, dirEntry.convertFileInfos(fileInfos));
            return dirEntry;
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            DirEntry dirEntry = (DirEntry)object;
            URL dirURL = dirEntry._dirURL;
            String urlString = this._isFileProtocol ? dirURL.getPath() : dirURL.toString();
            byte flags = dirEntry._flags;
            URLFileSystem.FileInfo[] fileInfos = dirEntry._files;
            int numInfos = fileInfos != null ? fileInfos.length : 0;
            StringFactory.STRING_FACTORY.disassemble((Object)urlString, output);
            output.writeByte(flags);
            output.writeInt(numInfos);
            for (int i = 0; i < numInfos; ++i) {
                if (this._isFileProtocol) {
                    FP_FILE_INFO_FACTORY.disassemble((Object)fileInfos[i], output);
                    continue;
                }
                FILE_INFO_FACTORY.disassemble((Object)fileInfos[i], output);
            }
        }
    }

    private static final class FileInfoFactory
    extends ObjectFactory {
        private boolean _isFileProtocol;
        public static final byte FILE_INFO_CODE = -15;
        public static final byte FP_FILE_INFO_CODE = -5;

        private FileInfoFactory(boolean isFileProtocol) {
            this._isFileProtocol = isFileProtocol;
        }

        public byte getObjectCode() {
            return this._isFileProtocol ? (byte)-5 : -15;
        }

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            String urlString = (String)StringFactory.STRING_FACTORY.assemble(input);
            URL fileURL = this._isFileProtocol ? URLFactory.newFileURL((String)urlString) : URLFactory.newURL((String)urlString);
            int attributes = input.readInt();
            long modified = input.readLong();
            long length = input.readLong();
            return new URLFileSystem.FileInfo(fileURL, attributes, modified, length);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            URLFileSystem.FileInfo fileInfo = (URLFileSystem.FileInfo)object;
            URL fileURL = fileInfo.getURL();
            String urlString = this._isFileProtocol ? fileURL.getPath() : fileURL.toString();
            int attributes = VirtualFileSystemHelper.getAttributes(fileInfo);
            long modified = fileInfo.lastModified();
            long length = fileInfo.length();
            StringFactory.STRING_FACTORY.disassemble((Object)urlString, output);
            output.writeInt(attributes);
            output.writeLong(modified);
            output.writeLong(length);
        }
    }

    private static final class DirEntry {
        private URL _dirURL;
        private static final int FLAGS_NONE = 0;
        private static final int FLAGS_DIRTY = 1;
        private static final int FLAGS_UNVERIFIED = 4;
        private static final int FLAGS_NONEXISTENT = 8;
        private byte _flags;
        private URLFileSystem.FileInfo[] _files;

        private DirEntry() {
        }

        public URLFileSystem.FileInfo[] convertFileInfos(URLFileSystem.FileInfo[] infos) {
            for (int i = 0; i < infos.length; ++i) {
                infos[i] = new FileInfo(URLFileSystem.getFileName((URL)infos[i].getURL()), VirtualFileSystemHelper.getAttributes(infos[i]), infos[i].lastModified(), infos[i].length());
            }
            return infos;
        }

        static /* synthetic */ URLFileSystem.FileInfo[] access$002(DirEntry x0, URLFileSystem.FileInfo[] x1) {
            x0._files = x1;
            return x1;
        }

        private class FileInfo
        extends URLFileSystem.FileInfo {
            private final String name;

            public FileInfo(String name, int attributes, long lastModified, long length) {
                super((URL)null, attributes, lastModified, length);
                this.name = name;
            }

            public URL getURL() {
                return (this.attributes & 1) != 0 ? URLFactory.newDirURL((URL)DirEntry.this._dirURL, (String)this.name) : URLFactory.newURL((URL)DirEntry.this._dirURL, (String)this.name);
            }
        }
    }

    private class DWListener
    implements DirectoryWatcher.DirectoryListener {
        private DWListener() {
        }

        public void directoryUpdate(DirectoryWatcher.DirectoryEvent event) {
            int type = event.getEventType();
            URL rootURL = event.getRootURL();
            switch (type) {
                case 2: {
                    String filename = event.getFileName().replace('\\', '/');
                    URL fileURL = URLFactory.newURL((URL)rootURL, (String)filename);
                    if (VERBOSE_LISTENER) {
                        Assert.println((String)("VFS/LISTENER: directoryUpdate() removed url = " + fileURL.toString()));
                    }
                    VirtualFileSystemHelper.this.removeCachedDirEntry(fileURL);
                    VirtualFileSystemHelper.this.markParentDirty(fileURL);
                    break;
                }
                case 4: {
                    String filename = event.getOldFileName().replace('\\', '/');
                    URL fileURL = URLFactory.newURL((URL)rootURL, (String)filename);
                    if (VERBOSE_LISTENER) {
                        Assert.println((String)("VFS/LISTENER: directoryUpdate() renamed old url = " + fileURL.toString()));
                    }
                    VirtualFileSystemHelper.this.removeCachedDirEntry(fileURL);
                    VirtualFileSystemHelper.this.markParentDirty(fileURL);
                    break;
                }
                case 1: 
                case 3: {
                    String filename = event.getFileName().replace('\\', '/');
                    URL fileURL = URLFactory.newURL((URL)rootURL, (String)filename);
                    if (VERBOSE_LISTENER) {
                        Assert.println((String)("VFS/LISTENER: directoryUpdate() add/modified url = " + fileURL.toString()));
                    }
                    if (type == 1) {
                        VirtualFileSystemHelper.this.removeCachedDirEntry(fileURL);
                    }
                    VirtualFileSystemHelper.this.markParentDirty(fileURL);
                    break;
                }
            }
        }

        public void watchCancelled(DirectoryWatcher.DirectoryEvent event) {
            URL rootURL = event.getRootURL();
            if (VERBOSE_LISTENER) {
                Assert.println((String)("VFS/LISTENER: watchCancelled()  url = " + rootURL.toString()));
            }
            VirtualFileSystemHelper.this.disableDirectoryTrackingFor(rootURL, false);
        }
    }
}

